/***************************************************************************
                          rotationdialog.cpp  -  description
                             -------------------
    begin                : Thu Jan 31 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rotationdialog.h"
#include "quiteinsane/qdoublespinbox.h"
#include "quiteinsane/qxmlconfig.h"

#include <math.h>

#include <qapplication.h>
#include <qcheckbox.h>
#include <qcolordialog.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qvbox.h>

RotationDialog::RotationDialog(int preview_size,QImage* image,QWidget* parent)
               :ImageFilterDialog(preview_size,image,parent)
{
  mBgColor = qRgb(0,0,0);
  mPixmap.resize(20,20);
  initControls();
}
RotationDialog::~RotationDialog()
{
}
/** No descriptions */
void RotationDialog::initControls()
{
  int angle = xmlConfig->intValue("FILTER_ROTATION_ANGLE",0);
  bool trans = xmlConfig->boolValue("FILTER_ROTATION_TRANSPARENCY",true);
  mBgColor = xmlConfig->uintValue("FILTER_ROTATION_BG_COLOR",0x000000);
  bool c_up = xmlConfig->boolValue("FILTER_ROTATION_CONTINOUS_UPDATE",false);
  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Rotation"));
  setCaption(tr("Rotation"));
  //rotation
  QHBox* rothbox = new QHBox(vb);
  QLabel* rotlabel = new QLabel(tr("Rotation angle"),rothbox);
  rothbox->setSpacing(3);
  mpRotationSpin = new QDoubleSpinBox(rothbox);
  mpRotationSpin->setRange(-36000,36000);
  mpRotationSpin->setValue(angle);
  rothbox->setStretchFactor(rotlabel,1);
  //transparent
  mpTransparentCheckBox = new QCheckBox(tr("Transparent background"),vb);
  mpTransparentCheckBox->setChecked(trans);
  //background color chooser
  mpBgHBox = new QHBox(vb);
  mpBgHBox->setSpacing(3);
  QLabel* bglabel = new QLabel(tr("Background color"),mpBgHBox);
  mpBgButton = new QPushButton(mpBgHBox);
  mPixmap.fill(QColor(mBgColor));
  mpBgButton->setPixmap(mPixmap);
  mpBgHBox->setStretchFactor(bglabel,1);
  mpBgHBox->setEnabled(!trans);
  //dummy
  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);

  connect(mpRotationSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotRotationChanged(int)));
  connect(mpTransparentCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotTransparency(bool)));
  connect(mpBgButton,SIGNAL(clicked()),
          this,SLOT(slotBgColor()));
  //load values
  slotRotationChanged(angle);
  setContinousUpdate(c_up);
  setFixedSize(minimumSizeHint());
}
/** No descriptions */
bool RotationDialog::apply(QImage* image,bool emit_progress)
{
  int x,y;
  int xm,ym;
  int old_p;
  bool transparent_bg;
  bool has_alpha;
  int progress,progresscnt;
  int alpha,inv_alpha;
  QRgb rgb_val;
  QImage im;

  old_p = 0;

  if(!image)
    return false;
  has_alpha = image->hasAlphaBuffer();
  im = image->copy();
  if(im.depth() < 32)
    im = im.convertDepth(32);

  transparent_bg = mpTransparentCheckBox->isChecked();
  resizeImage(im);

  progress = im.width() * im.height();
  progresscnt = 0;

  if(transparent_bg)
    im.setAlphaBuffer(true);
  QRgb rgb_trans = qRgba(qRed(mBgColor),
                         qGreen(mBgColor),
                         qBlue(mBgColor),
                         qAlpha(255));
  for (y=0; y < im.height(); y++)
  {
    for (x=0; x < im.width(); x++)
    {
      mInvertedMatrix.map(x+mOffX,y+mOffY,&xm,&ym);
      if((xm >= 0) && (xm < image->width()) &&
         (ym >= 0) && (ym < image->height()))
      {
        rgb_val = image->pixel(xm,ym);
        //Eventually we must merge transparent parts of the
        //original image with the background color
        if(has_alpha && !transparent_bg)
        {
          inv_alpha = 255 - qAlpha(rgb_val);
          alpha = qAlpha(rgb_val);
          rgb_val = qRgba(qRed(mBgColor)*inv_alpha/255 + qRed(rgb_val)*alpha/255,
                          qGreen(mBgColor)*inv_alpha/255 + qGreen(rgb_val)*alpha/255,
                          qBlue(mBgColor)*inv_alpha/255 + qBlue(rgb_val)*alpha/255,alpha);
        }
      }
      else
      {
        if(transparent_bg)
          rgb_val = rgb_trans;
        else
          rgb_val = mBgColor;
      }
      im.setPixel(x,y,rgb_val);
      if(emit_progress)
      {
        if(stopped())
          return false;
        ++progresscnt;
        int p = int(100.0*double(progresscnt)/double(progress));
        if(((p % 10) == 0) && (p > old_p))
        {
          old_p = p;
          emit signalFilterProgress(p);
          qApp->processEvents();
        }
      }
    }
  }
  *image = im;
  return true;
}
/**  */
void RotationDialog::slotRotationChanged(int angle)
{
  double rotation = double(angle)/100.0;
  mMatrix.reset();
  mMatrix.rotate(rotation);
  mInvertedMatrix = mMatrix.invert();
  updatePreview();
}
/**  */
void RotationDialog::slotTransparency(bool state)
{
  mpBgHBox->setEnabled(!state);
  updatePreview();
}
/**  */
void RotationDialog::slotBgColor()
{
  bool ok;
  QRgb rgb;
  rgb = QColorDialog::getRgba(mBgColor,&ok,this);
  if(ok)
  {
    mBgColor = rgb;
    mPixmap.fill(QColor(mBgColor));
    mpBgButton->setPixmap(mPixmap);
    updatePreview();
  }
}
/** No descriptions */
void RotationDialog::resizeImage(QImage image)
{
  int x,y;
  int minx,miny,maxx,maxy;
  minx = image.width();
  miny = image.height();
  maxx = 0;
  maxy = 0;
  for(int i=0;i<4;i++)
  {
    switch(i)
    {
      case 0:
        mMatrix.map(0,0,&x,&y);
        break;
      case 1:
        mMatrix.map(image.width(),0,&x,&y);
        break;
      case 2:
        mMatrix.map(image.width(),image.height(),&x,&y);
        break;
      case 3:
        mMatrix.map(0,image.height(),&x,&y);
        break;
      default:;
    }
    if(x<minx)
      minx = x;
    if(y<miny)
      miny = y;
    if(x>maxx)
      maxx = x;
    if(y>maxy)
      maxy = y;
  }
  mOffX = minx;
  mOffY = miny;
  image.create(maxx-minx,maxy-miny,32);
}
/** No descriptions */
void RotationDialog::saveConfig()
{
  xmlConfig->setIntValue("FILTER_ROTATION_ANGLE",
                         mpRotationSpin->value());
  xmlConfig->setBoolValue("FILTER_ROTATION_TRANSPARENCY",
                         mpTransparentCheckBox->isChecked());
  xmlConfig->setUintValue("FILTER_ROTATION_BG_COLOR",
                         mBgColor);
  xmlConfig->setBoolValue("FILTER_ROTATION_CONTINOUS_UPDATE",
                          continousUpdate());
}
