/***************************************************************************
                          sharpendialog.cpp  -  description
                             -------------------
    begin                : Thu Feb 7 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*****************************************************************************
 * The algorithm used in this class is taken from the Gimp 1.2.0             *
 * Original filename: sharpen.c                                              *
 * Original copyright message:                                               *
 * Copyright 1997-1998 Michael Sweet (mike@easysw.com)                       *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 *****************************************************************************/

#include "sharpendialog.h"
#include "quiteinsane/qxmlconfig.h"
#include "quiteinsane/sliderspin.h"

#include <math.h>

#include <qapplication.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qvbox.h>

SharpenDialog::SharpenDialog(int preview_size,QImage* image,QWidget* parent)
              :ImageFilterDialog(preview_size,image,parent)
{
  initControls();
}
SharpenDialog::~SharpenDialog()
{
}
/** No descriptions */
void SharpenDialog::initControls()
{
  int val = xmlConfig->intValue("FILTER_SHARPEN_VALUE",1);
  bool c_up = xmlConfig->boolValue("FILTER_SHARPEN_CONTINOUS_UPDATE",false);

  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Sharpen"));
  setCaption(tr("Sharpen"));
  //brightness
  mpSharpenSlider = new SliderSpin(1,99,val,tr("Value"),vb);
  mpSharpenSlider->setMinimumWidth(150);
  //dummy
  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);

  connect(mpSharpenSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotSharpenChanged(int)));
  slotSharpenChanged(val);
  setContinousUpdate(c_up);
  setFixedSize(minimumSizeHint());
}
/** No descriptions */
bool SharpenDialog::apply(QImage* image,bool emit_progress)
{
  QImage im;
  unsigned char	*src_rows[4],*src_ptr,*dst_row;
  int	*neg_rows[4],*neg_ptr;
  int	i,y,row,count,width;
  bool has_alpha;
  int filter = 0; //0 = RGB, 1 = RGBA
  int progress,progresscnt;
  progress = image->height();
  progresscnt = 0;
  int old_p = 0;

  if(image->depth() < 8)
    return false;
  computeLuts();


  im = image->copy();
  if(im.depth() < 32)
    im = im.convertDepth(32);

  has_alpha = image->hasAlphaBuffer();

  if(!has_alpha)
  {
    width = im.width() * 3;
    filter = 0;
  }
  else
  {
    width = im.width() * 4;
    filter = 1;
  }

  for (row = 0; row < 4; row ++)
  {
    src_rows[row] = new unsigned char [width];
    neg_rows[row] = new int [width];
  }

  dst_row = new unsigned char [width];

  unsigned char* up = src_rows[0];
  for(int n=0;n<image->width();n++)
  {
    QRgb rgb = image->pixel(n,0);
    if(has_alpha)
    {
      up[n*4] = (unsigned char)qRed(rgb);
      up[n*4+1] = (unsigned char)qGreen(rgb);
      up[n*4+2] = (unsigned char)qBlue(rgb);
      up[n*4+3] = (unsigned char)qAlpha(rgb);
    }
    else
    {
      up[n*3] = (unsigned char)qRed(rgb);
      up[n*3+1] = (unsigned char)qGreen(rgb);
      up[n*3+2] = (unsigned char)qBlue(rgb);
    }
  }

  for(i = width, src_ptr = src_rows[0], neg_ptr = neg_rows[0];
       i > 0;
       i --, src_ptr ++, neg_ptr ++)
    *neg_ptr = mNegLut[*src_ptr];

  row   = 1;
  count = 1;

  for (y = 0; y < image->height(); y ++)
  {
    if ((y + 1) < image->height())
  	{
	    if (count >= 3)
	      count --;
      unsigned char* up = src_rows[row];
      for(int n=0;n<image->width();n++)
      {
        QRgb rgb = image->pixel(n,y+1);
        if(has_alpha)
        {
          up[n*4] = (unsigned char)qRed(rgb);
          up[n*4+1] = (unsigned char)qGreen(rgb);
          up[n*4+2] = (unsigned char)qBlue(rgb);
          up[n*4+3] = (unsigned char)qAlpha(rgb);
        }
        else
        {
          up[n*3] = (unsigned char)qRed(rgb);
          up[n*3+1] = (unsigned char)qGreen(rgb);
          up[n*3+2] = (unsigned char)qBlue(rgb);
        }
      }

  	  for (i = width, src_ptr = src_rows[row], neg_ptr = neg_rows[row];
  	       i > 0;
  	       i --, src_ptr ++, neg_ptr ++)
  	    *neg_ptr = mNegLut[*src_ptr];

  	  count ++;
  	  row = (row + 1) & 3;
  	}
    else
  	{
	    count --;
	  }

    if (count == 3)
	  {
      if(filter == 0)
      {
        rgbFilter(image->width(),src_rows[(row + 2) & 3], dst_row,
		              neg_rows[(row + 1) & 3] + 3,
		              neg_rows[(row + 2) & 3] + 3,
		              neg_rows[(row + 3) & 3] + 3);
      }
      else
      {
        rgbaFilter(image->width(),src_rows[(row + 2) & 3], dst_row,
		               neg_rows[(row + 1) & 3] + 4,
		               neg_rows[(row + 2) & 3] + 4,
		               neg_rows[(row + 3) & 3] + 4);
      }
      for(int n=0;n<image->width();n++)
      {
        int r,g,b,a;
        if(has_alpha)
        {
          r = (int)dst_row[n*4];
          g = (int)dst_row[n*4+1];
          b = (int)dst_row[n*4+2];
          a = (int)dst_row[n*4+3];
          im.setPixel(n,y,qRgba(r,g,b,a));
        }
        else
        {
          r = (int)dst_row[n*3];
          g = (int)dst_row[n*3+1];
          b = (int)dst_row[n*3+2];
          im.setPixel(n,y,qRgb(r,g,b));
        }
      }
  	}
    else if (count == 2)
	  {
      unsigned char* up;
      up = src_rows[0];
	    if (y == 0)
      {
        for(int n=0;n<image->width();n++)
        {
          int r,g,b,a;
          if(has_alpha)
          {
            r = (int)up[n*4];
            g = (int)up[n*4+1];
            b = (int)up[n*4+2];
            a = (int)up[n*4+3];
            im.setPixel(n,y,qRgba(r,g,b,a));
          }
          else
          {
            r = (int)up[n*3];
            g = (int)up[n*3+1];
            b = (int)up[n*3+2];
            im.setPixel(n,y,qRgb(r,g,b));
          }
        }
      }
	    else
      {
        unsigned char* up;
        up = src_rows[2];
        for(int n=0;n<image->width();n++)
        {
          int r,g,b,a;
          if(has_alpha)
          {
            r = (int)up[n*4];
            g = (int)up[n*4+1];
            b = (int)up[n*4+2];
            a = (int)up[n*4+3];
            im.setPixel(n,y,qRgba(r,g,b,a));
          }
          else
          {
            r = (int)up[n*3];
            g = (int)up[n*3+1];
            b = (int)up[n*3+2];
            im.setPixel(n,y,qRgb(r,g,b));
          }
        }
      }
    }
    if(emit_progress)
    {
      if(stopped())
        return false;
      ++progresscnt;
      int p = int(100.0*double(progresscnt)/double(progress));
      if((p % 5 == 0) && (p > old_p))
      {
        old_p = p;
        emit signalFilterProgress(p);
        qApp->processEvents();
      }
    }
  }
  for(i=0;i<4;i++)
  {
    delete src_rows[i];
    delete neg_rows[i];
  }
  delete [] dst_row;
  if(im.depth() != image->depth())
    im = im.convertDepth(image->depth());
  *image = im;
  return true;
}
/**  */
void SharpenDialog::slotSharpenChanged(int value)
{
  mSharpenPercent = value;
  updatePreview();
}
void SharpenDialog::computeLuts()
{
  int i;	
  int fact;

  fact = 100 - mSharpenPercent;
  if (fact < 1)
    fact = 1;
  for (i = 0; i < 256; i ++)
  {
    mPosLut[i] = 800 * i / fact;
    mNegLut[i] = (4 + mPosLut[i] - (i << 3)) >> 3;
  }
}

void SharpenDialog::rgbFilter(int  width,unsigned char *src,
	                            unsigned char *dst,int *neg0,
	                            int *neg1,int *neg2)
{
  int pixel;

  *dst++ = *src++;
  *dst++ = *src++;
  *dst++ = *src++;
  width -= 2;

  while (width > 0)
  {
    pixel = (mPosLut[*src++] - neg0[-3] - neg0[0] - neg0[3] -
       neg1[-3] - neg1[3] -
       neg2[-3] - neg2[0] - neg2[3]);
    pixel = (pixel + 4) >> 3;
    if (pixel < 0)
    	*dst++ = 0;
    else if (pixel < 255)
	    *dst++ = (unsigned char)pixel;
    else
	    *dst++ = 255;

    pixel = (mPosLut[*src++] - neg0[-2] - neg0[1] - neg0[4] -
             neg1[-2] - neg1[4] -
             neg2[-2] - neg2[1] - neg2[4]);
    pixel = (pixel + 4) >> 3;
    if (pixel < 0)
    	*dst++ = 0;
    else if (pixel < 255)
	    *dst++ = (unsigned char)pixel;
    else
	    *dst++ = 255;

    pixel = (mPosLut[*src++] - neg0[-1] - neg0[2] - neg0[5] -
    	       neg1[-1] - neg1[5] -
	           neg2[-1] - neg2[2] - neg2[5]);
    pixel = (pixel + 4) >> 3;
    if (pixel < 0)
    	*dst++ = 0;
    else if (pixel < 255)
    	*dst++ = (unsigned char)pixel;
    else
    	*dst++ = 255;

    neg0 += 3;
    neg1 += 3;
    neg2 += 3;
    width --;
  }
  *dst++ = *src++;
  *dst++ = *src++;
  *dst++ = *src++;
}

void SharpenDialog::rgbaFilter(int width,unsigned char *src,
                        	     unsigned char *dst,int *neg0,
                        	     int *neg1,int *neg2)
{
  int pixel;

  *dst++ = *src++;
  *dst++ = *src++;
  *dst++ = *src++;
  *dst++ = *src++;
  width -= 2;

  while (width > 0)
  {
    pixel = (mPosLut[*src++] - neg0[-4] - neg0[0] - neg0[4] -
       neg1[-4] - neg1[4] -
       neg2[-4] - neg2[0] - neg2[4]);
    pixel = (pixel + 4) >> 3;
    if (pixel < 0)
    	*dst++ = 0;
    else if (pixel < 255)
	    *dst++ = (unsigned char)pixel;
    else
	    *dst++ = 255;

    pixel = (mPosLut[*src++] - neg0[-3] - neg0[1] - neg0[5] -
             neg1[-3] - neg1[5] -
             neg2[-3] - neg2[1] - neg2[5]);
    pixel = (pixel + 4) >> 3;
    if (pixel < 0)
    	*dst++ = 0;
    else if (pixel < 255)
	    *dst++ = (unsigned char)pixel;
    else
	    *dst++ = 255;

    pixel = (mPosLut[*src++] - neg0[-2] - neg0[2] - neg0[6] -
             neg1[-2] - neg1[6] -
             neg2[-2] - neg2[2] - neg2[6]);
    pixel = (pixel + 4) >> 3;
    if (pixel < 0)
    	*dst++ = 0;
    else if (pixel < 255)
	    *dst++ = (unsigned char)pixel;
    else
	    *dst++ = 255;

    *dst++ = *src++;

    neg0 += 4;
    neg1 += 4;
    neg2 += 4;
    width --;
  }

  *dst++ = *src++;
  *dst++ = *src++;
  *dst++ = *src++;
  *dst++ = *src++;
}
/** No descriptions */
void SharpenDialog::saveConfig()
{
  xmlConfig->setIntValue("FILTER_SHARPEN_VALUE",
                         mpSharpenSlider->value());
  xmlConfig->setBoolValue("FILTER_SHARPEN_CONTINOUS_UPDATE",
                          continousUpdate());
}
