/*
 * chrome://tabmixplus/content/links/setup.js
 *
 * original code by Bradley Chapman
 * modified and developped by Hemiola SUN
 * modified again by Bradley Chapman
 *
 */
var __contentAreaClick;

/**
 * @brief Install the link-handling functions of Tab Mix Plus.
 *
 * @returns		Nothing.
 */
function TMP_TBP_init() {
  var eStrings = document.getElementById("extensionsStrings");
  if (eStrings) {
      // we're in the EM
      openURL = TMP_openURL;

      // catch call to tabmix options from EM
      eval("gExtensionsViewController.commands.cmd_options ="+gExtensionsViewController.commands.cmd_options.toString().replace(
      'var optionsURL = aSelectedItem.getAttribute("optionsURL");',
      '$& \ if (TMP_cmd_options(optionsURL)) return;'
      ));
  }

  // with MR Tech's local install
  if (typeof(Local_Install) == "object") {
    // use TMP call to TMP Options
    var _aURL = "'chrome://tabmixplus/content/pref/pref-tabmix.xul'";
    eval("Local_Install.createDropDownMenu ="+Local_Install.createDropDownMenu.toString().replace(
    'aMenuItem.setAttribute("oncommand", thisAction + "; event.stopPropagation();");',
    'if (thisAction.indexOf(_aURL) != -1) thisAction = "TMP_cmd_options(" + _aURL + ")"; \ $&'
    ));
  }

  // we need this only for use our loadSearchInBackground pref
  var autoComplete = document.getElementById("PopupAutoCompleteRichResult");
  if (autoComplete) {
    eval("autoComplete.onPopupClick ="+autoComplete.onPopupClick.toString().replace(
      'openUILink(url, aEvent);',
      'TMP_BrowserLoadURL(aEvent, null, null, url);'
    ));
  }

  if ("contentAreaClick" in window) {
    __contentAreaClick = window.contentAreaClick;
    window.contentAreaClick = TMP_contentAreaClick;
  }
  window.BrowserOpenTab = TMP_BrowserOpenTab;
  window.openUILink = TMP_openUILink;
  // BrowserLoadURL removed in Firefox 3.5
  if ("BrowserLoadURL" in window)
     window.BrowserLoadURL = TMP_BrowserLoadURL;

  // for dotCOMplete extensoin
  if ("dotCOMplete" in window)
     window.dotCOMplete.realBrowserLoadURL = TMP_BrowserLoadURL;
}

/**
 * @brief Force-call the window observer at least one time.
 *
 * @returns		Nothing.
 */
function TMP_TBP_Startup() {
  try {
    gTMPprefObserver.init();
    // force-call the observer once, in order to kill new windows faster
    TMP_DOMWindowOpenObserver.onObserve(window, TMP_DOMWindowOpenObserver);

    // make tabmix compatible with ezsidebar extension
    var TMP_BrowserStartup = "__ezsidebar__BrowserStartup" in window ? "__ezsidebar__BrowserStartup" : "BrowserStartup";
    var bowserStartup = window[TMP_BrowserStartup].toString();

    if (gIsFirefox35) {
      var pbs = Cc["@mozilla.org/privatebrowsing;1"].
                getService(Ci.nsIPrivateBrowsingService);
      SessionManager._inPrivateBrowsing = pbs.privateBrowsingEnabled;
      bowserStartup = bowserStartup.replace(
        'gBrowser.swapBrowsersAndCloseOther(gBrowser.selectedTab, uriToLoad);',
        'var remoteBrowser = uriToLoad.ownerDocument.defaultView.gBrowser; \
         var url = remoteBrowser.getBrowserForTab(uriToLoad).currentURI.spec; \
         gBrowser.tabContainer.adjustTabstrip(true, url); \
         if (!gSingleWindowMode) { \
           window.tabmix_afterTabduplicated = true; \
           $& \
         }'
      );
    }

    var stringBundle = document.getElementById("tmp-string-bundle");
    var tabmix_loading = stringBundle.getString("session.loading.label") + "...";

    var windowOpeneByTabmix = "tabmixdata" in window;
    var firstWindow = numberOfWindows() == 1;

    var disAllow = SessionManager._inPrivateBrowsing || TMP_SessionStore.isSessionStoreEnabled() || "gSessionManager" in window;
    var sessionManager = gTabmixPrefs.getBoolPref("extensions.tabmix.sessions.manager");
    var crashRecovery = gTabmixPrefs.getBoolPref("extensions.tabmix.sessions.crashRecovery");
    var afterRestart = false;

    var restoreOrAsk = gTabmixPrefs.getIntPref("extensions.tabmix.sessions.onStart") < 2 || afterRestart;
    var afterCrash = gTabmixPrefs.prefHasUserValue("extensions.tabmix.sessions.crashed");

    // don't load home page on first window if session manager or crash recovery is enabled
    window.isLoadHomePage = true;
    if (!disAllow && ((sessionManager && windowOpeneByTabmix) ||
         (firstWindow && crashRecovery && afterCrash) ||
         (firstWindow && sessionManager && restoreOrAsk))) {
      bowserStartup = bowserStartup.replace(
        'uriToLoad = window.arguments[0];',
        'uriToLoad = gHomeButton.getHomePage() == window.arguments[0] ? "about:blank" : window.arguments[0];'
      );
      bowserStartup = bowserStartup.replace(
        'if (window.opener && !window.opener.closed) {',
        'if (uriToLoad && uriToLoad != "about:blank")\
           for (var i = 0; i < gBrowser.tabs.length ; i++)\
             gBrowser.tabs[i].loadOnStartup = true;\
         $&'
      );
      if (!("TabGroupsManagerApiVer1" in window)) {
        bowserStartup = bowserStartup.replace(
          'if (window.opener && !window.opener.closed) {',
          'if (uriToLoad == "about:blank" || "tabmixdata" in window) {\
            var aBrowser = gBrowser.selectedBrowser;\
            aBrowser.contentDocument.title = tabmix_loading;\
            aBrowser.mIconURL = "chrome://tabmixplus/skin/tmp.png";\
            gBrowser.mCurrentTab.setAttribute("image", aBrowser.mIconURL);\
          }\
          $&'
        );
      }
    }

    // call TMP_SessionStore.setService before delayedStartup, so this will run before sessionStore.init
    eval("window."+TMP_BrowserStartup+" ="+bowserStartup.replace(
      'setTimeout(delayedStartup, 0',
      'if (numberOfWindows() == 1) TMP_SessionStore.setService(1, true); \
       $&'
    ));

    // look for installed extensions that are incompatible with tabmix
    if (firstWindow && gTabmixPrefs.getBoolPref("extensions.tabmix.disableIncompatible")) {
      let checkCompatibility = function (aWindow) {
        tabmix_checkCompatibility.start(aWindow, true);
      }
      window.setTimeout(checkCompatibility, tabmixAddonManager ? 0 : 3000, window);
    }

   // add tabmix menu item to tab context menu before menumanipulator and MenuEdit initialize
    tabmix_tabContextMenu();

    // if nglayout.debug.disable_xul_cache == true sometimes sessionHistory act strange
    // especially with many extensions installed
    var pref = "nglayout.debug.disable_xul_cache";
    if ((!firstWindow && !windowOpeneByTabmix) && gTabmixPrefs.prefHasUserValue(pref) && gTabmixPrefs.getBoolPref(pref))
      window.setTimeout(window[TMP_BrowserStartup], 0);
    else
      window[TMP_BrowserStartup]();

    return;
  } catch (ex) {TMP_ASSERT(ex);}
}

// Create new items in the tab bar context menu
function tabmix_tabContextMenu() {
  var tabContextMenu;
  if (gIsFirefox37) {
    tabContextMenu = gBrowser.tabContextMenu;
    // from Firefox 3.7 2009-09-11 there is gContextMenu.openLinkInCurrent in contentAreaContextMenu
    // move our menu to that position
    let openLinkInCurrent = document.getElementById("context-openlinkincurrent");
    let tabmix_menu = document.getElementById("tm-openlinkhere");
    openLinkInCurrent.parentNode.insertBefore(tabmix_menu, openLinkInCurrent);
  }
  else {
    // getBrowser() here is for Firefox 3 we get here before BrowserStartup
    // from Firefox 3.5 window have getter for gBrowser
    if (!getBrowser().tabContextMenu)
      gBrowser.tabContextMenu = document.getAnonymousElementByAttribute(gBrowser, "anonid", "tabContextMenu");
    tabContextMenu = gBrowser.tabContextMenu;

    if (!tabContextMenu.hasAttribute("id"))
      tabContextMenu.setAttribute("id", "tabContextMenu");

    // we use it to make sure context menu is not hide when stip is collapsed in Firefox 3.0-3.6
    let _class = tabContextMenu.hasAttribute("class") ? tabContextMenu.setAttribute("class") + " ": "";
    tabContextMenu.setAttribute("class", _class + "tabmix-tabContextMenu");
    if (gIsFirefox35) {
      // From Firefox 3.5.4pre we can not use anonymous menupopup from toolbar button
      // this hack enable tabmix to use tab context menu from tablist tollbar button
      gBrowser.tabContainer.parentNode.insertBefore(gBrowser.tabContextMenu, gBrowser.tabContainer);
    }
  }
  if (gIsFirefox35) {
    // to be compatible with firefox 3.0 we use our own move-tab-to-new-window
    // firefox don't have function to duplicate the tab to new windows
    // look in gBrowser.duplicateInWindow
    let item = document.getElementById("context_openTabInWindow");
    if (item) // make sure no one removed it before we do
      tabContextMenu.removeChild(item);
  }

  tabContextMenu.setAttribute("onpopuphidden", tabContextMenu.getAttribute("onpopuphidden") + "if (event.target == this) TM_hidePopup();");
  tabContextMenu.addEventListener("popupshowing", Tm_checkTabClick, false);
  tabContextMenu.addEventListener("popupshown", TMP_tabContextMenuShown, false);

  var separators = tabContextMenu.getElementsByTagName(gIsFirefox37 ? "menuseparator" : "xul:menuseparator");
  for (let i = 0; i < separators.length; i++ ) {
    let separator = separators[i];
    separator.setAttribute("id", "original-separator-" + i);
    separator.setAttribute("type", "tabmix");
  }

  // update context_newTab attribute
  var newTab = document.getElementById("context_newTab");
  newTab.setAttribute("_newtab", newTab.getAttribute("label"));
  newTab.setAttribute("_afterthis", document.getElementById("tm-separator").getAttribute("_afterthis"));
  newTab.setAttribute("tmp_iconic", "menuitem-iconic tabs-newbutton tabs-newbutton-menu tmp-icon");
  newTab.removeAttribute(gIsFirefox37 ? "command" : "xbl:inherits");

  // group the close-tab options together
  var closeTab = document.getElementById("context_closeTab");
  var closeOther = document.getElementById("context_closeOtherTabs");
  tabContextMenu.insertBefore( closeTab, closeOther );

  var newMenuItems = ["tm-duplicateTab","tm-duplicateinWin","tm-context_openTabInWindow","tm-mergeWindowsTab","tm-renameTab",
                      "tm-copyTabUrl", "tm-autoreloadTab_menu", "tm-reloadOther","tm-reloadLeft","tm-reloadRight","tm-separator",
                      "tm-undoCloseList","tm-separator-2",
                      "tm-closeAllTabs","tm-closeSimilar","tm-closeLeftTabs","tm-closeRightTabs",
                      "tm-docShell","tm-freezeTab","tm-protectTab","tm-lockTab"];

  var newMenuOrders = [ 1, 2, 3, 4, 5, 6,
                        9, 11, 12, 13, 14,
                        15, 16,
                        18, 19, 21, 22,
                        24, 25, 26, 27];

  // insert new menuitems and separators
  for (let i = 0; i < newMenuItems.length; i++ ) {
    let newMenuItem = document.getElementById(newMenuItems[i]);
    tabContextMenu.insertBefore(newMenuItem, tabContextMenu.childNodes.item(newMenuOrders[i]));
  }
  // remove our empty popup
  var popup = document.getElementById("extTabMixPopup");
  popup.parentNode.removeChild(popup);

  // use firefox id with our oun item
  let item = document.getElementById("tm-context_openTabInWindow");
  item.setAttribute("id", "context_openTabInWindow");

  // move context_undoCloseTab before tm-undoCloseList
  var _undoCloseTab = document.getElementById("context_undoCloseTab");
  _undoCloseTab.setAttribute("key", "key_undoCloseTab");
  tabContextMenu.insertBefore(_undoCloseTab, document.getElementById("tm-undoCloseList"));
  // we can't disable menus with command attribute
  _undoCloseTab.removeAttribute("command");
  _undoCloseTab.setAttribute("oncommand", "TMP_ClosedTabs.undoCloseTab();");

  // insret IE Tab menu-items before Bookmakrs menu-items or at the end if origSep2 is null
  if ("gIeTab" in window) {
    var aFunction = "createTabbarMenu" in IeTab.prototype ? "createTabbarMenu" : "init";
    if (aFunction in IeTab.prototype) {
      eval("IeTab.prototype." + aFunction +" ="+IeTab.prototype[aFunction].toString().replace(
           'tabbarMenu.insertBefore(document.getElementById("ietab-tabbar-sep"), separator);',
           'separator = document.getElementById("original-separator-2"); $&'
      ));
    }
  }

  // fix conflict with CookiePie extension
  if ("cookiepieContextMenu" in window && !cookiepieContextMenu.initialized)
    cookiepieContextMenu.init();
}

// this must run before all
function TMP_beforStartup(tabBrowser, aTabContainer) {
    // ODFReader change Cc to something else maybe some other extensions do that too !!!
    if ("Cc" in window && Cc != Components.classes)
       Cc = Components.classes;

    if ("Ci" in window && Ci != Components.interfaces)
       Ci = Components.interfaces;

    var appInfo = Cc["@mozilla.org/xre/app-info;1"]
                     .getService(Ci.nsIXULAppInfo);
    var versionChecker = Cc["@mozilla.org/xpcom/version-comparator;1"]
                     .getService(Ci.nsIVersionComparator);
    gIsFirefox35 = versionChecker.compare(appInfo.version, "3.1a2") > 0;
    gIsFirefox36 = versionChecker.compare(appInfo.version, "3.6a1pre") >= 0;
    gIsFirefox37 = versionChecker.compare(appInfo.version, "3.7a1pre") >= 0;

    if (!gIsFirefox36) {
      // for Firefox 3.0.x - 3.5.x
      eval("tabBrowser.moveTabTo ="+tabBrowser.moveTabTo.toString().replace(
           'this.mTabContainer.mTabstrip.scrollBoxObject.ensureElementIsVisible(this.mCurrentTab);',
           'this.mTabContainer.ensureTabIsVisible(this.mCurrentTab._tPos);'
      ));

      eval("tabBrowser.addTab ="+tabBrowser.addTab.toString().replace(
           'this.mTabContainer.mTabstrip.scrollBoxObject.scrollBy(this.mTabContainer.firstChild.boxObject.width, 0);',
           ''
      ));
    }

    if (!gIsFirefox35) {
       // for Firefox 3.0.x //
       eval("tabBrowser.removeTab ="+tabBrowser.removeTab.toString().replace(
            'tabStrip.scrollBoxObject.getPosition(scrollPos, {});',
            'scrollPos.value = -tabStrip.boxObject.width;'
           ).replace(
            'tabStrip.scrollBoxObject.getScrolledSize(scrolledSize, {});',
            'scrolledSize.value = 2000;'
       ));
    }

    // return true if all tabs in the window are blank
    tabBrowser.isBlankWindow = function() {
       for (var i = 0; i < this.tabs.length; i++) {
          if (!this.isBlankBrowser(this.getBrowserAtIndex(i)))
             return false;
       }
       return true;
    }

    tabBrowser.isBlankTab = function(aTab) {
      return this.isBlankBrowser(this.getBrowserForTab(aTab));
    }

    if (("loadTabsProgressively" in window)) {
      tabBrowser.isBlankNotBusyTab = function TMP_isBlankNotBusyTab(aTab) {
         // loadTabsProgressively add pending attribute to pending tab when it stop the tab
         if (aTab.hasAttribute("busy") || aTab.hasAttribute("pending"))
            return false;

         return this.isBlankBrowser(this.getBrowserForTab(aTab));
      }
    }
    else {
      tabBrowser.isBlankNotBusyTab = function TMP_isBlankNotBusyTab(aTab) {
         if (aTab.hasAttribute("busy"))
            return false;

         return this.isBlankBrowser(this.getBrowserForTab(aTab));
      }
    }

    tabBrowser.isBlankBrowser = function _isBlankBrowser(aBrowser) {
       try{
          if (!aBrowser)
             return true;
          return (!aBrowser.sessionHistory || aBrowser.sessionHistory.index < 0 ||
                  (aBrowser.sessionHistory.count < 2 &&
                  (!aBrowser.currentURI || this.tabmix_isNewTabUrls(aBrowser.currentURI.spec))));
       } catch (ex) {TMP_ASSERT(ex); return true;}
    }

    tabBrowser.tabmix_isNewTabUrls = function (aUrl) {
          return this.tabmix_newTabUrls.indexOf(aUrl) > -1
    }

    tabBrowser.tabmix_newTabUrls =         [
         "about:blank",
         "chrome://abouttab/content/text.html",
         "chrome://abouttab/content/tab.html",
         "chrome://google-toolbar/content/new-tab.html",
         "chrome://fastdial/content/fastdial.html"
         ];

    var tabContainer = aTabContainer || tabBrowser.mTabContainer ||
                       document.getAnonymousElementByAttribute(tabBrowser, "anonid", "tabcontainer");

    // tabmix_isNewTabUrls and isBlankNotBusyTab isn't exist when we call adjustTabstrip from tabcontainer constructor
    // so we add this code after constructor already run
    var adjustTabstrip = tabContainer.adjustTabstrip.toString().replace(
      'this._closeWindowWithLastTab',
      '(url  && url != "about:blank" ? this.tabbrowser.tabmix_isNewTabUrls(url) : this.tabbrowser.isBlankNotBusyTab(this.selectedItem)) || $&'
    );

    if (gIsFirefox35)
      adjustTabstrip = adjustTabstrip.replace('this.childNodes.length', '$& - this.tabbrowser._removingTabs.length');
    else
      adjustTabstrip = adjustTabstrip.replace('getBoundingClientRect()', 'boxObject');

    eval("tabContainer.adjustTabstrip ="+ adjustTabstrip)
    tabContainer.adjustTabstrip();

    try {
      if ("TabGroupsManagerApiVer1" in window)
        TMP_TabGroupsManager.init(tabContainer);
    } catch (ex) {TMP_ASSERT(ex);}

    TMP_eventListener.init(tabContainer);

    // Firefox sessionStore and session manager extension start to add tab before our onWindowOpen run
    // so we initialize this before start
    gWidthFitTitle = TMP_getBoolPref(tabxBranch, "flexTabs", false) &&
                    (TMP_getIntPref("", "browser.tabs.tabMaxWidth", 250) != gTabmixPrefs.getIntPref("browser.tabs.tabMinWidth"));

    tabscroll = gTabmixPrefs.getIntPref("extensions.tabmix.tabBarMode")
    if (tabscroll < 0 || tabscroll > 3 || (tabscroll != 1 && "TreeStyleTabBrowser" in window)) {
      gTabmixPrefs.setIntPref("extensions.tabmix.tabBarMode", 1);
      tabscroll = 1;
    }
}
