#
# taglog_help.tcl - routines providing the help system for taglog
# Copyright John Lines (john@paladin.demon.co.uk) November 2000
#
# This program is released under the terms of the GNU Public Licence
#

# Note that only one argument will be substituted at present.

package provide taglog_help 0.1

proc taghelp { subject args } {
global language helpdir


set description ""
set helpfile "$helpdir/taglog_help_$language.tag"
if { ! [file exists $helpfile] } {
 set description "Help text not found for item $subject in language $language - please check that $helpfile exists"
}
set test [list Id "==" $subject]
lappend tests $test
set helpentry [tag readselected $helpfile $tests]

foreach entry $helpentry {
 foreach item $entry {
  if { [lindex $item 0] == "Description" } {
	set description [lindex $item 1]
	}
  }
}

if { $description == "" } {
unset tests
set test [list Id "==" UNKNOWN ]
lappend tests $test
set helpentry [tag readselected $helpfile $tests]
foreach entry $helpentry {
 foreach item $entry {
  if { [lindex $item 0] == "Description" } {
        set description [lindex $item 1]
        }
  }
}
}

# if args is non empty then perform argument substitution

set i 1
for { set i 1 } { $i <= [ llength $args] } { incr i } {
 set thisarg [lindex $args [expr $i - 1]]

regsub {\$1} $description $thisarg description

}

toplevel .taghelp_$subject
wm title .taghelp_$subject "Help on $subject"

frame .taghelp_$subject.body
message .taghelp_$subject.body.msg -text $description -width 7i
pack .taghelp_$subject.body.msg
pack .taghelp_$subject.body

frame .taghelp_$subject.bot
button .taghelp_$subject.bot.ok -text OK -command "doCancel .taghelp_$subject"
pack .taghelp_$subject.bot.ok
pack .taghelp_$subject.bot

tkwait window .taghelp_$subject
}

