/***************************************************************************
 *   Copyright (C) 2006 by Marco Martin                                    *
 *   notmart@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the Lesser GNU General Public                   *
 *   License as published by the Free Software Foundation;                 *
 *   either version 2 of the License, or (at your option)                  *
 *   any later version.                                                    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MENUHANDLER_H
#define MENUHANDLER_H

#include <kservicegroup.h>
#include <kservice.h>
#include <klistbox.h>
#include <klistview.h>
#include <klistviewsearchline.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <krecentdocument.h>
#include <krun.h>
#include <dcopref.h>
#include <qheader.h>
#include <qimage.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qcombobox.h>
#include <kdirwatch.h>
#include <kdirlister.h>
#include <qlayout.h>
#include <kfileitem.h>

#include "dmctl.h"
#include "menu.h"
#include "prefs.h"
#include "tastylistview.h"

/**
 @author Marco Martin <notmart@gmail.com>
*/
class MenuHandler : public QFrame{
    Q_OBJECT

public:
    MenuHandler( QWidget *parent, Prefs *prefs, char *name=0, WFlags fl=WType_TopLevel );

    ~MenuHandler();

    void readConfig();
    void popup(QPoint pos);
    void updateConfig();
    void focusNextChild(){focusNextPrevChild(true);}
    void focusPrevChild(){focusNextPrevChild(false);}
    void clearNewInstalledApplications()
     {newInstalledList.clear();newInstalledTimeStamps.clear();
      prefSkel->setNewInstalledApps( newInstalledList );
      prefSkel->setNewInstalledAppsTimeStamps( newInstalledTimeStamps );}

signals:
    void newApplications(int);
    void kickerConfChanged();
    void hidden();

protected:
    virtual bool eventFilter( QObject *o, QEvent * e );

    virtual void closeEvent ( QCloseEvent *e);
    virtual void resizeEvent ( QResizeEvent *e)
    { QWidget::resizeEvent(e); menu->leftFrame->setMaximumWidth( (int)((width()-24)/3) ); }
    virtual void mousePressEvent( QMouseEvent *e);

private:
    typedef QMap<ulong, QString> RecentlyUsedMap;
    typedef enum
    {
      Favourites = 0,
      MoreUsed = 1,
      RecentlyUsed = 2,
      RecentDocuments = 3
    } MenuMode;

    RecentlyUsedMap recentlyUsedMap;

    QStringList moreUsedList, favouriteList;

    Menu * menu;
    MenuMode currentMenuMode;
    KIconLoader *iconLoader;
    QPopupMenu *sessionsMenu;
    bool searchMode;
    Prefs *prefSkel;
    KConfig *kickerConf;
    KDirWatch *kickerConfWatch;
    //xdgMenuWatch for applications-kmenuedit.menu xdgMenuLister for all the desktop files
    KDirWatch *xdgMenuWatch;
    KDirLister *xdgMenuLister;
    int firstListing;
    QStringList oldInstalledList, newInstalledList;
    QValueList<int> newInstalledTimeStamps;

    QPixmap bookMarkPix;
    QVBoxLayout * MenuHandlerLayout;

//configuration items
    int _menuMode;
    QString _currentCategory;
    int _numRecentEntries;
    int _iconSize1;
    int _iconSize2;
    int _iconSize3;
    int _actionIconSize;
    bool _displaySubText;
    bool _newAppsNotification;
    bool _kerryIntegration;
    bool _strigiIntegration;
    double _menuWidth;
    double _menuHeight;
    bool _isNormalWindow;
    bool _showExpander;
    bool _alwaysCollapsed;
    bool _hideOneChild;
    bool _alphabetical;

    typedef QMap<QString, KServiceGroup::List> SListMap;
    SListMap sListMap;
    //KServiceGroup::List getServiceGroupList( KServiceGroup *serviceGroup );
    void setupColumns();
    void loadNewInstalledApps();
    void initOldInstalledApps(KServiceGroup::Ptr group);
    void initNewInstalledApps(KServiceGroup::Ptr group);
    void populateList( KServiceGroup *serviceGroup,
                       TastyListView *listView,
                       TastyListViewItem *listItemFather,
                       bool recursive, const QString & query = NULL );

    void listClicked( TastyListViewItem * listItem, const QPoint & coord );
    void fillRecentDocuments( );
    void fillMoreUsed( );
    void fillRecentlyUsed( );
    void fillFavourites( );
    void setupDynList( MenuMode mode );
    //FIXME: this thing is UBER HEAVY
    bool searchNewItems(KServiceGroup::Ptr group);

public slots:
    void slotUpdateApplications();

private slots:
    void dynListElemMoved( );
    void dynListClicked( QListViewItem * listItem, const QPoint & coord, int c );
    void slotContextMenu(QListViewItem *listItem, const QPoint &coord, int c );
    void initializeRecentlyUsed(  );
    void slotModKickerConf();
    void slotApplicationsAdded(const KFileItemList & newItems);
    void slotApplicationRemoved();
    void childListClicked( QListViewItem * listItem, const QPoint & coord, int c );
    void rootListClicked( QListViewItem * listItem, const QPoint & coord, int c );
    void doLogout();
    void doLock();
    void slotPopulateSessions();
    void slotSessionActivated( int ent );
    void doNewSession( bool lock );
    void runDialog();
    void initializeSearch( const QString & query );
    void kerrySearch( const QString & query );
    void strigiSearch( const QString & query );
    void clearDynList();
    void menuModeChanged( int index );
    void switchWindowMode();
};

#endif
