/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.paraprof.ColorChooserFrame;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SavedPreferences;
import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class ColorChooser
implements WindowListener {
    private ParaProfTrial trial = null;
    private Vector colors = new Vector();
    private Vector groupColors = new Vector();
    private Color functionHighlightColor = Color.red;
    private Function highlightedFunction = null;
    private Color groupHighlightColor = new Color(0, 255, 255);
    private Group highlightedGroup = null;
    private Color userEventHighlightColor = new Color(255, 255, 0);
    private UserEvent highlightedUserEvent = null;
    private Color miscFunctionColor = Color.black;
    private boolean clrChooserFrameShowing = false;
    private ColorChooserFrame clrChooserFrame;

    public ColorChooser(ParaProfTrial paraProfTrial, SavedPreferences savedPreferences) {
        this.trial = paraProfTrial;
        if (savedPreferences != null) {
            this.colors = savedPreferences.getColors();
            this.groupColors = savedPreferences.getGroupColors();
            this.functionHighlightColor = savedPreferences.getHighlightColor();
            this.groupHighlightColor = savedPreferences.getGroupHighlightColor();
            this.userEventHighlightColor = savedPreferences.getUserEventHighlightColor();
            this.miscFunctionColor = savedPreferences.getMiscFunctionColor();
        } else {
            this.setDefaultColors();
            this.setDefaultGroupColors();
        }
    }

    public void showColorChooser() {
        if (!this.clrChooserFrameShowing) {
            this.clrChooserFrame = new ColorChooserFrame(this.trial, this);
            this.clrChooserFrame.addWindowListener(this);
            this.clrChooserFrame.show();
            this.clrChooserFrameShowing = true;
        } else {
            this.clrChooserFrame.show();
        }
    }

    public void setSavedColors() {
        ParaProf.savedPreferences.setColors(this.colors);
        ParaProf.savedPreferences.setGroupColors(this.groupColors);
        ParaProf.savedPreferences.setHighlightColor(this.functionHighlightColor);
        ParaProf.savedPreferences.setGroupHighlightColor(this.groupHighlightColor);
        ParaProf.savedPreferences.setMiscFunctionColor(this.miscFunctionColor);
    }

    public int getNumberOfColors() {
        int n = -1;
        n = this.colors.size();
        return n;
    }

    public int getNumberOfGroupColors() {
        int n = -1;
        n = this.groupColors.size();
        return n;
    }

    public void addColor(Color color) {
        this.colors.add(color);
    }

    public void setColor(Color color, int n) {
        this.colors.setElementAt(color, n);
    }

    public Color getColor(int n) {
        Color color = null;
        color = (Color)this.colors.elementAt(n);
        return color;
    }

    public Vector getColors() {
        return this.colors;
    }

    public void addGroupColor(Color color) {
        this.groupColors.add(color);
    }

    public void setGroupColor(Color color, int n) {
        this.groupColors.setElementAt(color, n);
    }

    public Color getGroupColor(int n) {
        return (Color)this.groupColors.elementAt(n);
    }

    public Vector getGroupColors() {
        return this.groupColors;
    }

    public void setHighlightColor(Color color) {
        this.functionHighlightColor = color;
    }

    public Color getHighlightColor() {
        return this.functionHighlightColor;
    }

    public void setHighlightedFunction(Function function) {
        this.highlightedFunction = function;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public Function getHighlightedFunction() {
        return this.highlightedFunction;
    }

    public void toggleHighlightedFunction(Function function) {
        this.highlightedFunction = this.highlightedFunction == function ? null : function;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public void setGroupHighlightColor(Color color) {
        this.groupHighlightColor = color;
    }

    public Color getGroupHighlightColor() {
        return this.groupHighlightColor;
    }

    public void setHighlightedGroup(Group group) {
        this.highlightedGroup = group;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public Group getHighlightedGroup() {
        return this.highlightedGroup;
    }

    public void toggleHighlightedGroup(Group group) {
        this.highlightedGroup = this.highlightedGroup == group ? null : group;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public void setUserEventHighlightColor(Color color) {
        this.userEventHighlightColor = color;
    }

    public Color getUserEventHighlightColor() {
        return this.userEventHighlightColor;
    }

    public void setHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = userEvent;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public UserEvent getHighlightedUserEvent() {
        return this.highlightedUserEvent;
    }

    public void toggleHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = this.highlightedUserEvent == userEvent ? null : userEvent;
        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public void setMiscFunctionColor(Color color) {
        this.miscFunctionColor = color;
    }

    public Color getMiscFunctionColor() {
        return this.miscFunctionColor;
    }

    public void setDefaultColors() {
        this.colors.clear();
        this.addColor(new Color(70, 156, 168));
        this.addColor(new Color(255, 153, 0));
        this.addColor(new Color(0, 51, 255));
        this.addColor(new Color(102, 0, 51));
        this.addColor(new Color(221, 232, 30));
        this.addColor(new Color(0, 255, 0));
        this.addColor(new Color(121, 196, 144));
        this.addColor(new Color(86, 88, 112));
        this.addColor(new Color(151, 204, 255));
        this.addColor(new Color(102, 102, 255));
        this.addColor(new Color(0, 102, 102));
        this.addColor(new Color(204, 255, 51));
        this.addColor(new Color(102, 132, 25));
        this.addColor(new Color(255, 204, 153));
        this.addColor(new Color(204, 0, 204));
        this.addColor(new Color(0, 102, 102));
        this.addColor(new Color(204, 204, 255));
        this.addColor(new Color(61, 104, 63));
        this.addColor(new Color(102, 255, 255));
        this.addColor(new Color(255, 102, 102));
        this.addColor(new Color(119, 71, 145));
        this.addColor(new Color(255, 204, 204));
        this.addColor(new Color(240, 97, 159));
        this.addColor(new Color(0, 102, 153));
    }

    public void setDefaultGroupColors() {
        this.groupColors.clear();
        this.addGroupColor(new Color(102, 0, 102));
        this.addGroupColor(new Color(51, 51, 0));
        this.addGroupColor(new Color(204, 0, 51));
        this.addGroupColor(new Color(0, 102, 102));
        this.addGroupColor(new Color(255, 255, 102));
        this.addGroupColor(new Color(0, 0, 102));
        this.addGroupColor(new Color(153, 153, 255));
        this.addGroupColor(new Color(255, 51, 0));
        this.addGroupColor(new Color(255, 153, 0));
        this.addGroupColor(new Color(255, 102, 102));
        this.addGroupColor(new Color(51, 0, 51));
        this.addGroupColor(new Color(255, 255, 102));
    }

    public void setColors(ParaProfTrial paraProfTrial, int n) {
        Vector vector;
        Object object;
        int n2;
        if (n == -1 || n == 0) {
            n2 = this.getNumberOfColors();
            object = new DataSorter(paraProfTrial);
            vector = ((DataSorter)object).getFunctionProfiles(-1, -1, -1, 20);
            for (int i = 0; i < vector.size(); ++i) {
                Function function = ((PPFunctionProfile)vector.get(i)).getFunction();
                function.setColor(this.getColor(i % n2));
            }
        }
        if (n == -1 || n == 1) {
            n2 = this.getNumberOfGroupColors();
            object = paraProfTrial.getDataSource().getGroups();
            while (object.hasNext()) {
                vector = (Group)object.next();
                vector.setColor(this.getGroupColor(vector.getID() % n2));
            }
        }
        if (n == -1 || n == 2) {
            n2 = this.getNumberOfColors();
            object = paraProfTrial.getDataSource().getUserEvents();
            while (object.hasNext()) {
                vector = (UserEvent)object.next();
                vector.setColor(this.getColor(vector.getID() % n2));
            }
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.clrChooserFrame) {
            this.clrChooserFrameShowing = false;
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

