'\"
'\" Generated by tcllib/doctools/toc with format 'nroff'
.TH "Table Of Contents" n
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH CONTENTS
tcllib
.RS
.TP
\fBaes\fR
\fIfiles/modules/aes/aes\&.n\fR: Implementation of the AES block cipher
.TP
\fBascii85\fR
\fIfiles/modules/base64/ascii85\&.n\fR: ascii85-encode/decode binary data
.TP
\fBasn\fR
\fIfiles/modules/asn/asn\&.n\fR: ASN\&.1 BER encoder/decoder
.TP
\fBautoproxy\fR
\fIfiles/modules/http/autoproxy\&.n\fR: Automatic HTTP proxy usage and authentication
.TP
\fBbase32\fR
\fIfiles/modules/base32/base32\&.n\fR: base32 standard encoding
.TP
\fBbase32::core\fR
\fIfiles/modules/base32/base32core\&.n\fR: Expanding basic base32 maps
.TP
\fBbase32::hex\fR
\fIfiles/modules/base32/base32hex\&.n\fR: base32 extended hex encoding
.TP
\fBbase64\fR
\fIfiles/modules/base64/base64\&.n\fR: base64-encode/decode binary data
.TP
\fBbee\fR
\fIfiles/modules/bee/bee\&.n\fR: BitTorrent Serialization Format Encoder/Decoder
.TP
\fBbench\fR
\fIfiles/modules/bench/bench\&.n\fR: bench - Processing benchmark suites
.TP
\fBbench::in\fR
\fIfiles/modules/bench/bench_read\&.n\fR: bench::in - Reading benchmark results
.TP
\fBbench::out::csv\fR
\fIfiles/modules/bench/bench_wcsv\&.n\fR: bench::out::csv - Formatting benchmark results as CSV
.TP
\fBbench::out::text\fR
\fIfiles/modules/bench/bench_wtext\&.n\fR: bench::out::text - Formatting benchmark results as human readable text
.TP
\fBbench_intro\fR
\fIfiles/modules/bench/bench_intro\&.n\fR: bench introduction
.TP
\fBbench_lang_intro\fR
\fIfiles/modules/bench/bench_lang_intro\&.n\fR: bench language introduction
.TP
\fBbench_lang_spec\fR
\fIfiles/modules/bench/bench_lang_spec\&.n\fR: bench language specification
.TP
\fBbibtex\fR
\fIfiles/modules/bibtex/bibtex\&.n\fR: Parse bibtex files
.TP
\fBblowfish\fR
\fIfiles/modules/blowfish/blowfish\&.n\fR: Implementation of the Blowfish block cipher
.TP
\fBcache::async\fR
\fIfiles/modules/cache/async\&.n\fR: Asynchronous in-memory cache
.TP
\fBcksum\fR
\fIfiles/modules/crc/cksum\&.n\fR: Calculate a cksum(1) compatible checksum
.TP
\fBclock_iso8601\fR
\fIfiles/modules/clock/iso8601\&.n\fR: Parsing ISO 8601 dates/times
.TP
\fBclock_rfc2822\fR
\fIfiles/modules/clock/rfc2822\&.n\fR: Parsing ISO 8601 dates/times
.TP
\fBcmdline\fR
\fIfiles/modules/cmdline/cmdline\&.n\fR: Procedures to process command lines and options\&.
.TP
\fBcomm\fR
\fIfiles/modules/comm/comm\&.n\fR: A remote communication facility for Tcl (8\&.3 and later)
.TP
\fBcomm_wire\fR
\fIfiles/modules/comm/comm_wire\&.n\fR: The comm wire protocol
.TP
\fBcontrol\fR
\fIfiles/modules/control/control\&.n\fR: Procedures for control flow structures\&.
.TP
\fBcoroutine\fR
\fIfiles/modules/coroutine/tcllib_coroutine\&.n\fR: Coroutine based event and IO handling
.TP
\fBcoroutine::auto\fR
\fIfiles/modules/coroutine/coro_auto\&.n\fR: Automatic event and IO coroutine awareness
.TP
\fBcounter\fR
\fIfiles/modules/counter/counter\&.n\fR: Procedures for counters and histograms
.TP
\fBcrc16\fR
\fIfiles/modules/crc/crc16\&.n\fR: Perform a 16bit Cyclic Redundancy Check
.TP
\fBcrc32\fR
\fIfiles/modules/crc/crc32\&.n\fR: Perform a 32bit Cyclic Redundancy Check
.TP
\fBcron\fR
\fIfiles/modules/cron/cron\&.n\fR: Tool for automating the period callback of commands
.TP
\fBcsv\fR
\fIfiles/modules/csv/csv\&.n\fR: Procedures to handle CSV data\&.
.TP
\fBdebug\fR
\fIfiles/modules/debug/debug\&.n\fR: debug narrative - core
.TP
\fBdebug::caller\fR
\fIfiles/modules/debug/debug_caller\&.n\fR: debug narrative - caller
.TP
\fBdebug::heartbeat\fR
\fIfiles/modules/debug/debug_heartbeat\&.n\fR: debug narrative - heartbeat
.TP
\fBdebug::timestamp\fR
\fIfiles/modules/debug/debug_timestamp\&.n\fR: debug narrative - timestamping
.TP
\fBdeleg_method\fR
\fIfiles/modules/interp/deleg_method\&.n\fR: Creation of comm delegates (snit methods)
.TP
\fBdeleg_proc\fR
\fIfiles/modules/interp/deleg_proc\&.n\fR: Creation of comm delegates (procedures)
.TP
\fBdes\fR
\fIfiles/modules/des/des\&.n\fR: Implementation of the DES and triple-DES ciphers
.TP
\fBdicttool\fR
\fIfiles/modules/dicttool/dicttool\&.n\fR: Dictionary Tools
.TP
\fBdns\fR
\fIfiles/modules/dns/tcllib_dns\&.n\fR: Tcl Domain Name Service Client
.TP
\fBdocidx_intro\fR
\fIfiles/modules/doctools/docidx_intro\&.n\fR: docidx introduction
.TP
\fBdocidx_lang_cmdref\fR
\fIfiles/modules/doctools/docidx_lang_cmdref\&.n\fR: docidx language command reference
.TP
\fBdocidx_lang_faq\fR
\fIfiles/modules/doctools/docidx_lang_faq\&.n\fR: docidx language faq
.TP
\fBdocidx_lang_intro\fR
\fIfiles/modules/doctools/docidx_lang_intro\&.n\fR: docidx language introduction
.TP
\fBdocidx_lang_syntax\fR
\fIfiles/modules/doctools/docidx_lang_syntax\&.n\fR: docidx language syntax
.TP
\fBdocidx_plugin_apiref\fR
\fIfiles/modules/doctools/docidx_plugin_apiref\&.n\fR: docidx plugin API reference
.TP
\fBdocstrip\fR
\fIfiles/modules/docstrip/docstrip\&.n\fR: Docstrip style source code extraction
.TP
\fBdocstrip_util\fR
\fIfiles/modules/docstrip/docstrip_util\&.n\fR: Docstrip-related utilities
.TP
\fBdoctoc_intro\fR
\fIfiles/modules/doctools/doctoc_intro\&.n\fR: doctoc introduction
.TP
\fBdoctoc_lang_cmdref\fR
\fIfiles/modules/doctools/doctoc_lang_cmdref\&.n\fR: doctoc language command reference
.TP
\fBdoctoc_lang_faq\fR
\fIfiles/modules/doctools/doctoc_lang_faq\&.n\fR: doctoc language faq
.TP
\fBdoctoc_lang_intro\fR
\fIfiles/modules/doctools/doctoc_lang_intro\&.n\fR: doctoc language introduction
.TP
\fBdoctoc_lang_syntax\fR
\fIfiles/modules/doctools/doctoc_lang_syntax\&.n\fR: doctoc language syntax
.TP
\fBdoctoc_plugin_apiref\fR
\fIfiles/modules/doctools/doctoc_plugin_apiref\&.n\fR: doctoc plugin API reference
.TP
\fBdoctools\fR
\fIfiles/modules/doctools/doctools\&.n\fR: doctools - Processing documents
.TP
\fBdoctools2idx_introduction\fR
\fIfiles/modules/doctools2idx/idx_introduction\&.n\fR: DocTools - Keyword indices
.TP
\fBdoctools2toc_introduction\fR
\fIfiles/modules/doctools2toc/toc_introduction\&.n\fR: DocTools - Tables of Contents
.TP
\fBdoctools::changelog\fR
\fIfiles/modules/doctools/changelog\&.n\fR: Processing text in Emacs ChangeLog format
.TP
\fBdoctools::cvs\fR
\fIfiles/modules/doctools/cvs\&.n\fR: Processing text in 'cvs log' format
.TP
\fBdoctools::html::cssdefaults\fR
\fIfiles/modules/doctools2base/html_cssdefaults\&.n\fR: Default CSS style for HTML export plugins
.TP
\fBdoctools::idx\fR
\fIfiles/modules/doctools2idx/idx_container\&.n\fR: Holding keyword indices
.TP
\fBdoctools::idx\fR
\fIfiles/modules/doctools/docidx\&.n\fR: docidx - Processing indices
.TP
\fBdoctools::idx::export\fR
\fIfiles/modules/doctools2idx/idx_export\&.n\fR: Exporting keyword indices
.TP
\fBdoctools::idx::export::docidx\fR
\fIfiles/modules/doctools2idx/export_docidx\&.n\fR: docidx export plugin
.TP
\fBdoctools::idx::export::html\fR
\fIfiles/modules/doctools2idx/idx_export_html\&.n\fR: HTML export plugin
.TP
\fBdoctools::idx::export::json\fR
\fIfiles/modules/doctools2idx/idx_export_json\&.n\fR: JSON export plugin
.TP
\fBdoctools::idx::export::nroff\fR
\fIfiles/modules/doctools2idx/idx_export_nroff\&.n\fR: nroff export plugin
.TP
\fBdoctools::idx::export::text\fR
\fIfiles/modules/doctools2idx/idx_export_text\&.n\fR: plain text export plugin
.TP
\fBdoctools::idx::export::wiki\fR
\fIfiles/modules/doctools2idx/idx_export_wiki\&.n\fR: wiki export plugin
.TP
\fBdoctools::idx::import\fR
\fIfiles/modules/doctools2idx/idx_import\&.n\fR: Importing keyword indices
.TP
\fBdoctools::idx::import::docidx\fR
\fIfiles/modules/doctools2idx/import_docidx\&.n\fR: docidx import plugin
.TP
\fBdoctools::idx::import::json\fR
\fIfiles/modules/doctools2idx/idx_import_json\&.n\fR: JSON import plugin
.TP
\fBdoctools::idx::parse\fR
\fIfiles/modules/doctools2idx/idx_parse\&.n\fR: Parsing text in docidx format
.TP
\fBdoctools::idx::structure\fR
\fIfiles/modules/doctools2idx/idx_structure\&.n\fR: Docidx serialization utilities
.TP
\fBdoctools::msgcat\fR
\fIfiles/modules/doctools2base/tcllib_msgcat\&.n\fR: Message catalog management for the various document parsers
.TP
\fBdoctools::msgcat::idx::c\fR
\fIfiles/modules/doctools2idx/idx_msgcat_c\&.n\fR: Message catalog for the docidx parser (C)
.TP
\fBdoctools::msgcat::idx::de\fR
\fIfiles/modules/doctools2idx/idx_msgcat_de\&.n\fR: Message catalog for the docidx parser (DE)
.TP
\fBdoctools::msgcat::idx::en\fR
\fIfiles/modules/doctools2idx/idx_msgcat_en\&.n\fR: Message catalog for the docidx parser (EN)
.TP
\fBdoctools::msgcat::idx::fr\fR
\fIfiles/modules/doctools2idx/idx_msgcat_fr\&.n\fR: Message catalog for the docidx parser (FR)
.TP
\fBdoctools::msgcat::toc::c\fR
\fIfiles/modules/doctools2toc/toc_msgcat_c\&.n\fR: Message catalog for the doctoc parser (C)
.TP
\fBdoctools::msgcat::toc::de\fR
\fIfiles/modules/doctools2toc/toc_msgcat_de\&.n\fR: Message catalog for the doctoc parser (DE)
.TP
\fBdoctools::msgcat::toc::en\fR
\fIfiles/modules/doctools2toc/toc_msgcat_en\&.n\fR: Message catalog for the doctoc parser (EN)
.TP
\fBdoctools::msgcat::toc::fr\fR
\fIfiles/modules/doctools2toc/toc_msgcat_fr\&.n\fR: Message catalog for the doctoc parser (FR)
.TP
\fBdoctools::nroff::man_macros\fR
\fIfiles/modules/doctools2base/nroff_manmacros\&.n\fR: Default CSS style for NROFF export plugins
.TP
\fBdoctools::tcl::parse\fR
\fIfiles/modules/doctools2base/tcl_parse\&.n\fR: Processing text in 'subst -novariables' format
.TP
\fBdoctools::toc\fR
\fIfiles/modules/doctools/doctoc\&.n\fR: doctoc - Processing tables of contents
.TP
\fBdoctools::toc\fR
\fIfiles/modules/doctools2toc/toc_container\&.n\fR: Holding tables of contents
.TP
\fBdoctools::toc::export\fR
\fIfiles/modules/doctools2toc/toc_export\&.n\fR: Exporting tables of contents
.TP
\fBdoctools::toc::export::doctoc\fR
\fIfiles/modules/doctools2toc/export_doctoc\&.n\fR: doctoc export plugin
.TP
\fBdoctools::toc::export::html\fR
\fIfiles/modules/doctools2toc/toc_export_html\&.n\fR: HTML export plugin
.TP
\fBdoctools::toc::export::json\fR
\fIfiles/modules/doctools2toc/toc_export_json\&.n\fR: JSON export plugin
.TP
\fBdoctools::toc::export::nroff\fR
\fIfiles/modules/doctools2toc/toc_export_nroff\&.n\fR: nroff export plugin
.TP
\fBdoctools::toc::export::text\fR
\fIfiles/modules/doctools2toc/toc_export_text\&.n\fR: plain text export plugin
.TP
\fBdoctools::toc::export::wiki\fR
\fIfiles/modules/doctools2toc/toc_export_wiki\&.n\fR: wiki export plugin
.TP
\fBdoctools::toc::import\fR
\fIfiles/modules/doctools2toc/toc_import\&.n\fR: Importing keyword indices
.TP
\fBdoctools::toc::import::doctoc\fR
\fIfiles/modules/doctools2toc/import_doctoc\&.n\fR: doctoc import plugin
.TP
\fBdoctools::toc::import::json\fR
\fIfiles/modules/doctools2toc/toc_import_json\&.n\fR: JSON import plugin
.TP
\fBdoctools::toc::parse\fR
\fIfiles/modules/doctools2toc/toc_parse\&.n\fR: Parsing text in doctoc format
.TP
\fBdoctools::toc::structure\fR
\fIfiles/modules/doctools2toc/toc_structure\&.n\fR: Doctoc serialization utilities
.TP
\fBdoctools_intro\fR
\fIfiles/modules/doctools/doctools_intro\&.n\fR: doctools introduction
.TP
\fBdoctools_lang_cmdref\fR
\fIfiles/modules/doctools/doctools_lang_cmdref\&.n\fR: doctools language command reference
.TP
\fBdoctools_lang_faq\fR
\fIfiles/modules/doctools/doctools_lang_faq\&.n\fR: doctools language faq
.TP
\fBdoctools_lang_intro\fR
\fIfiles/modules/doctools/doctools_lang_intro\&.n\fR: doctools language introduction
.TP
\fBdoctools_lang_syntax\fR
\fIfiles/modules/doctools/doctools_lang_syntax\&.n\fR: doctools language syntax
.TP
\fBdoctools_plugin_apiref\fR
\fIfiles/modules/doctools/doctools_plugin_apiref\&.n\fR: doctools plugin API reference
.TP
\fBdtplite\fR
\fIfiles/apps/dtplite\&.n\fR: Lightweight DocTools Markup Processor
.TP
\fBdtplite\fR
\fIfiles/modules/dtplite/pkg_dtplite\&.n\fR: Lightweight DocTools Markup Processor
.TP
\fBfileutil\fR
\fIfiles/modules/fileutil/fileutil\&.n\fR: Procedures implementing some file utilities
.TP
\fBfileutil::magic::cfront\fR
\fIfiles/modules/fumagic/cfront\&.n\fR: Generator core for compiler of magic(5) files
.TP
\fBfileutil::magic::cgen\fR
\fIfiles/modules/fumagic/cgen\&.n\fR: Generator core for compiler of magic(5) files
.TP
\fBfileutil::magic::filetype\fR
\fIfiles/modules/fumagic/filetypes\&.n\fR: Procedures implementing file-type recognition
.TP
\fBfileutil::magic::mimetype\fR
\fIfiles/modules/fumagic/mimetypes\&.n\fR: Procedures implementing mime-type recognition
.TP
\fBfileutil::magic::rt\fR
\fIfiles/modules/fumagic/rtcore\&.n\fR: Runtime core for file type recognition engines written in pure Tcl
.TP
\fBfileutil::multi\fR
\fIfiles/modules/fileutil/multi\&.n\fR: Multi-file operation, scatter/gather, standard object
.TP
\fBfileutil::multi::op\fR
\fIfiles/modules/fileutil/multiop\&.n\fR: Multi-file operation, scatter/gather
.TP
\fBfileutil_traverse\fR
\fIfiles/modules/fileutil/traverse\&.n\fR: Iterative directory traversal
.TP
\fBftp\fR
\fIfiles/modules/ftp/ftp\&.n\fR: Client-side tcl implementation of the ftp protocol
.TP
\fBftp::geturl\fR
\fIfiles/modules/ftp/ftp_geturl\&.n\fR: Uri handler for ftp urls
.TP
\fBftpd\fR
\fIfiles/modules/ftpd/ftpd\&.n\fR: Tcl FTP server implementation
.TP
\fBgenerator\fR
\fIfiles/modules/generator/generator\&.n\fR: Procedures for creating and using generators\&.
.TP
\fBgpx\fR
\fIfiles/modules/gpx/gpx\&.n\fR: Extracts waypoints, tracks and routes from GPX files
.TP
\fBgrammar::aycock\fR
\fIfiles/modules/grammar_aycock/aycock\&.n\fR: Aycock-Horspool-Earley parser generator for Tcl
.TP
\fBgrammar::fa\fR
\fIfiles/modules/grammar_fa/fa\&.n\fR: Create and manipulate finite automatons
.TP
\fBgrammar::fa::dacceptor\fR
\fIfiles/modules/grammar_fa/dacceptor\&.n\fR: Create and use deterministic acceptors
.TP
\fBgrammar::fa::dexec\fR
\fIfiles/modules/grammar_fa/dexec\&.n\fR: Execute deterministic finite automatons
.TP
\fBgrammar::fa::op\fR
\fIfiles/modules/grammar_fa/faop\&.n\fR: Operations on finite automatons
.TP
\fBgrammar::me::cpu\fR
\fIfiles/modules/grammar_me/me_cpu\&.n\fR: Virtual machine implementation II for parsing token streams
.TP
\fBgrammar::me::cpu::core\fR
\fIfiles/modules/grammar_me/me_cpucore\&.n\fR: ME virtual machine state manipulation
.TP
\fBgrammar::me::cpu::gasm\fR
\fIfiles/modules/grammar_me/gasm\&.n\fR: ME assembler
.TP
\fBgrammar::me::tcl\fR
\fIfiles/modules/grammar_me/me_tcl\&.n\fR: Virtual machine implementation I for parsing token streams
.TP
\fBgrammar::me::util\fR
\fIfiles/modules/grammar_me/me_util\&.n\fR: AST utilities
.TP
\fBgrammar::me_ast\fR
\fIfiles/modules/grammar_me/me_ast\&.n\fR: Various representations of ASTs
.TP
\fBgrammar::me_intro\fR
\fIfiles/modules/grammar_me/me_intro\&.n\fR: Introduction to virtual machines for parsing token streams
.TP
\fBgrammar::me_vm\fR
\fIfiles/modules/grammar_me/me_vm\&.n\fR: Virtual machine for parsing token streams
.TP
\fBgrammar::peg\fR
\fIfiles/modules/grammar_peg/peg\&.n\fR: Create and manipulate parsing expression grammars
.TP
\fBgrammar::peg::interp\fR
\fIfiles/modules/grammar_peg/peg_interp\&.n\fR: Interpreter for parsing expression grammars
.TP
\fBhook\fR
\fIfiles/modules/hook/hook\&.n\fR: Hooks
.TP
\fBhtml\fR
\fIfiles/modules/html/html\&.n\fR: Procedures to generate HTML structures
.TP
\fBhtmlparse\fR
\fIfiles/modules/htmlparse/htmlparse\&.n\fR: Procedures to parse HTML strings
.TP
\fBhuddle\fR
\fIfiles/modules/yaml/huddle\&.n\fR: Create and manipulate huddle object
.TP
\fBident\fR
\fIfiles/modules/ident/ident\&.n\fR: Ident protocol client
.TP
\fBimap4\fR
\fIfiles/modules/imap4/imap4\&.n\fR: imap client-side tcl implementation of imap protocol
.TP
\fBinifile\fR
\fIfiles/modules/inifile/ini\&.n\fR: Parsing of Windows INI files
.TP
\fBinterp\fR
\fIfiles/modules/interp/tcllib_interp\&.n\fR: Interp creation and aliasing
.TP
\fBirc\fR
\fIfiles/modules/irc/irc\&.n\fR: Create IRC connection and interface\&.
.TP
\fBjavascript\fR
\fIfiles/modules/javascript/javascript\&.n\fR: Procedures to generate HTML and Java Script structures\&.
.TP
\fBjpeg\fR
\fIfiles/modules/jpeg/jpeg\&.n\fR: JPEG querying and manipulation of meta data
.TP
\fBjson\fR
\fIfiles/modules/json/json\&.n\fR: JSON parser
.TP
\fBjson::write\fR
\fIfiles/modules/json/json_write\&.n\fR: JSON generation
.TP
\fBlambda\fR
\fIfiles/modules/lambda/lambda\&.n\fR: Utility commands for anonymous procedures
.TP
\fBldap\fR
\fIfiles/modules/ldap/ldap\&.n\fR: LDAP client
.TP
\fBldapx\fR
\fIfiles/modules/ldap/ldapx\&.n\fR: LDAP extended object interface
.TP
\fBlog\fR
\fIfiles/modules/log/log\&.n\fR: Procedures to log messages of libraries and applications\&.
.TP
\fBlogger\fR
\fIfiles/modules/log/logger\&.n\fR: System to control logging of events\&.
.TP
\fBlogger::appender\fR
\fIfiles/modules/log/loggerAppender\&.n\fR: Collection of predefined appenders for logger
.TP
\fBlogger::utils\fR
\fIfiles/modules/log/loggerUtils\&.n\fR: Utilities for logger
.TP
\fBmap::geocode::nominatim\fR
\fIfiles/modules/map/map_geocode_nominatim\&.n\fR: Resolving geographical names with a Nominatim service
.TP
\fBmap::slippy\fR
\fIfiles/modules/map/map_slippy\&.n\fR: Common code for slippy based map packages
.TP
\fBmap::slippy::cache\fR
\fIfiles/modules/map/map_slippy_cache\&.n\fR: Management of a tile cache in the local filesystem
.TP
\fBmap::slippy::fetcher\fR
\fIfiles/modules/map/map_slippy_fetcher\&.n\fR: Accessing a server providing tiles for slippy-based maps
.TP
\fBmapproj\fR
\fIfiles/modules/mapproj/mapproj\&.n\fR: Map projection routines
.TP
\fBmath\fR
\fIfiles/modules/math/math\&.n\fR: Tcl Math Library
.TP
\fBmath::bigfloat\fR
\fIfiles/modules/math/bigfloat\&.n\fR: Arbitrary precision floating-point numbers
.TP
\fBmath::bignum\fR
\fIfiles/modules/math/bignum\&.n\fR: Arbitrary precision integer numbers
.TP
\fBmath::calculus\fR
\fIfiles/modules/math/calculus\&.n\fR: Integration and ordinary differential equations
.TP
\fBmath::calculus::romberg\fR
\fIfiles/modules/math/romberg\&.n\fR: Romberg integration
.TP
\fBmath::calculus::symdiff\fR
\fIfiles/modules/math/symdiff\&.n\fR: Symbolic differentiation for Tcl
.TP
\fBmath::combinatorics\fR
\fIfiles/modules/math/combinatorics\&.n\fR: Combinatorial functions in the Tcl Math Library
.TP
\fBmath::complexnumbers\fR
\fIfiles/modules/math/qcomplex\&.n\fR: Straightforward complex number package
.TP
\fBmath::constants\fR
\fIfiles/modules/math/constants\&.n\fR: Mathematical and numerical constants
.TP
\fBmath::decimal\fR
\fIfiles/modules/math/decimal\&.n\fR: General decimal arithmetic
.TP
\fBmath::exact\fR
\fIfiles/modules/math/exact\&.n\fR: Exact Real Arithmetic
.TP
\fBmath::fourier\fR
\fIfiles/modules/math/fourier\&.n\fR: Discrete and fast fourier transforms
.TP
\fBmath::fuzzy\fR
\fIfiles/modules/math/fuzzy\&.n\fR: Fuzzy comparison of floating-point numbers
.TP
\fBmath::geometry\fR
\fIfiles/modules/math/math_geometry\&.n\fR: Geometrical computations
.TP
\fBmath::interpolate\fR
\fIfiles/modules/math/interpolate\&.n\fR: Interpolation routines
.TP
\fBmath::linearalgebra\fR
\fIfiles/modules/math/linalg\&.n\fR: Linear Algebra
.TP
\fBmath::numtheory\fR
\fIfiles/modules/math/numtheory\&.n\fR: Number Theory
.TP
\fBmath::optimize\fR
\fIfiles/modules/math/optimize\&.n\fR: Optimisation routines
.TP
\fBmath::polynomials\fR
\fIfiles/modules/math/polynomials\&.n\fR: Polynomial functions
.TP
\fBmath::rationalfunctions\fR
\fIfiles/modules/math/rational_funcs\&.n\fR: Polynomial functions
.TP
\fBmath::roman\fR
\fIfiles/modules/math/roman\&.n\fR: Tools for creating and manipulating roman numerals
.TP
\fBmath::special\fR
\fIfiles/modules/math/special\&.n\fR: Special mathematical functions
.TP
\fBmath::statistics\fR
\fIfiles/modules/math/statistics\&.n\fR: Basic statistical functions and procedures
.TP
\fBmd4\fR
\fIfiles/modules/md4/md4\&.n\fR: MD4 Message-Digest Algorithm
.TP
\fBmd5\fR
\fIfiles/modules/md5/md5\&.n\fR: MD5 Message-Digest Algorithm
.TP
\fBmd5crypt\fR
\fIfiles/modules/md5crypt/md5crypt\&.n\fR: MD5-based password encryption
.TP
\fBmime\fR
\fIfiles/modules/mime/mime\&.n\fR: Manipulation of MIME body parts
.TP
\fBmpexpand\fR
\fIfiles/modules/doctools/mpexpand\&.n\fR: Markup processor
.TP
\fBmultiplexer\fR
\fIfiles/modules/multiplexer/multiplexer\&.n\fR: One-to-many communication with sockets\&.
.TP
\fBnameserv\fR
\fIfiles/modules/nns/nns_client\&.n\fR: Name service facility, Client
.TP
\fBnameserv::auto\fR
\fIfiles/modules/nns/nns_auto\&.n\fR: Name service facility, Client Extension
.TP
\fBnameserv::common\fR
\fIfiles/modules/nns/nns_common\&.n\fR: Name service facility, shared definitions
.TP
\fBnameserv::protocol\fR
\fIfiles/modules/nns/nns_protocol\&.n\fR: Name service facility, client/server protocol
.TP
\fBnameserv::server\fR
\fIfiles/modules/nns/nns_server\&.n\fR: Name service facility, Server
.TP
\fBnamespacex\fR
\fIfiles/modules/namespacex/namespacex\&.n\fR: Namespace utility commands
.TP
\fBncgi\fR
\fIfiles/modules/ncgi/ncgi\&.n\fR: Procedures to manipulate CGI values\&.
.TP
\fBnettool\fR
\fIfiles/modules/nettool/nettool\&.n\fR: Tools for networked applications
.TP
\fBnmea\fR
\fIfiles/modules/nmea/nmea\&.n\fR: Process NMEA data
.TP
\fBnns\fR
\fIfiles/apps/nns\&.n\fR: Name service facility, Commandline Client Application
.TP
\fBnns_intro\fR
\fIfiles/modules/nns/nns_intro\&.n\fR: Name service facility, introduction
.TP
\fBnnsd\fR
\fIfiles/apps/nnsd\&.n\fR: Name service facility, Commandline Server Application
.TP
\fBnnslog\fR
\fIfiles/apps/nnslog\&.n\fR: Name service facility, Commandline Logging Client Application
.TP
\fBnntp\fR
\fIfiles/modules/nntp/nntp\&.n\fR: Tcl client for the NNTP protocol
.TP
\fBntp_time\fR
\fIfiles/modules/ntp/ntp_time\&.n\fR: Tcl Time Service Client
.TP
\fBoauth\fR
\fIfiles/modules/oauth/oauth\&.n\fR: oauth API base signature
.TP
\fBoo::util\fR
\fIfiles/modules/tool/meta\&.n\fR: Utility commands for TclOO
.TP
\fBoo::util\fR
\fIfiles/modules/ooutil/ooutil\&.n\fR: Utility commands for TclOO
.TP
\fBotp\fR
\fIfiles/modules/otp/otp\&.n\fR: One-Time Passwords
.TP
\fBpage\fR
\fIfiles/apps/page\&.n\fR: Parser Generator
.TP
\fBpage_intro\fR
\fIfiles/modules/page/page_intro\&.n\fR: page introduction
.TP
\fBpage_pluginmgr\fR
\fIfiles/modules/page/page_pluginmgr\&.n\fR: page plugin manager
.TP
\fBpage_util_flow\fR
\fIfiles/modules/page/page_util_flow\&.n\fR: page dataflow/treewalker utility
.TP
\fBpage_util_norm_lemon\fR
\fIfiles/modules/page/page_util_norm_lemon\&.n\fR: page AST normalization, LEMON
.TP
\fBpage_util_norm_peg\fR
\fIfiles/modules/page/page_util_norm_peg\&.n\fR: page AST normalization, PEG
.TP
\fBpage_util_peg\fR
\fIfiles/modules/page/page_util_peg\&.n\fR: page PEG transformation utilities
.TP
\fBpage_util_quote\fR
\fIfiles/modules/page/page_util_quote\&.n\fR: page character quoting utilities
.TP
\fBpicoirc\fR
\fIfiles/modules/irc/picoirc\&.n\fR: Small and simple embeddable IRC client\&.
.TP
\fBpki\fR
\fIfiles/modules/pki/pki\&.n\fR: Implementation of the public key cipher
.TP
\fBpluginmgr\fR
\fIfiles/modules/pluginmgr/pluginmgr\&.n\fR: Manage a plugin
.TP
\fBpng\fR
\fIfiles/modules/png/png\&.n\fR: PNG querying and manipulation of meta data
.TP
\fBpop3\fR
\fIfiles/modules/pop3/pop3\&.n\fR: Tcl client for POP3 email protocol
.TP
\fBpop3d\fR
\fIfiles/modules/pop3d/pop3d\&.n\fR: Tcl POP3 server implementation
.TP
\fBpop3d::dbox\fR
\fIfiles/modules/pop3d/pop3d_dbox\&.n\fR: Simple mailbox database for pop3d
.TP
\fBpop3d::udb\fR
\fIfiles/modules/pop3d/pop3d_udb\&.n\fR: Simple user database for pop3d
.TP
\fBprocessman\fR
\fIfiles/modules/processman/processman\&.n\fR: Tool for automating the period callback of commands
.TP
\fBprofiler\fR
\fIfiles/modules/profiler/profiler\&.n\fR: Tcl source code profiler
.TP
\fBpt\fR
\fIfiles/apps/pt\&.n\fR: Parser Tools Application
.TP
\fBpt::ast\fR
\fIfiles/modules/pt/pt_astree\&.n\fR: Abstract Syntax Tree Serialization
.TP
\fBpt::cparam::configuration::critcl\fR
\fIfiles/modules/pt/pt_cparam_config_critcl\&.n\fR: C/PARAM, Canned configuration, Critcl
.TP
\fBpt::cparam::configuration::tea\fR
\fIfiles/modules/pt/pt_cparam_config_tea\&.n\fR: C/PARAM, Canned configuration, TEA
.TP
\fBpt::json_language\fR
\fIfiles/modules/pt/pt_json_language\&.n\fR: The JSON Grammar Exchange Format
.TP
\fBpt::param\fR
\fIfiles/modules/pt/pt_param\&.n\fR: PackRat Machine Specification
.TP
\fBpt::pe\fR
\fIfiles/modules/pt/pt_pexpression\&.n\fR: Parsing Expression Serialization
.TP
\fBpt::pe::op\fR
\fIfiles/modules/pt/pt_pexpr_op\&.n\fR: Parsing Expression Utilities
.TP
\fBpt::peg\fR
\fIfiles/modules/pt/pt_pegrammar\&.n\fR: Parsing Expression Grammar Serialization
.TP
\fBpt::peg::container\fR
\fIfiles/modules/pt/pt_peg_container\&.n\fR: PEG Storage
.TP
\fBpt::peg::container::peg\fR
\fIfiles/modules/pt/pt_peg_container_peg\&.n\fR: PEG Storage\&. Canned PEG grammar specification
.TP
\fBpt::peg::export\fR
\fIfiles/modules/pt/pt_peg_export\&.n\fR: PEG Export
.TP
\fBpt::peg::export::container\fR
\fIfiles/modules/pt/pt_peg_export_container\&.n\fR: PEG Export Plugin\&. Write CONTAINER format
.TP
\fBpt::peg::export::json\fR
\fIfiles/modules/pt/pt_peg_export_json\&.n\fR: PEG Export Plugin\&. Write JSON format
.TP
\fBpt::peg::export::peg\fR
\fIfiles/modules/pt/pt_peg_export_peg\&.n\fR: PEG Export Plugin\&. Write PEG format
.TP
\fBpt::peg::from::container\fR
\fIfiles/modules/pt/pt_peg_from_container\&.n\fR: PEG Conversion\&. From CONTAINER format
.TP
\fBpt::peg::from::json\fR
\fIfiles/modules/pt/pt_peg_from_json\&.n\fR: PEG Conversion\&. Read JSON format
.TP
\fBpt::peg::from::peg\fR
\fIfiles/modules/pt/pt_peg_from_peg\&.n\fR: PEG Conversion\&. Read PEG format
.TP
\fBpt::peg::import\fR
\fIfiles/modules/pt/pt_peg_import\&.n\fR: PEG Import
.TP
\fBpt::peg::import::container\fR
\fIfiles/modules/pt/pt_peg_import_container\&.n\fR: PEG Import Plugin\&. From CONTAINER format
.TP
\fBpt::peg::import::json\fR
\fIfiles/modules/pt/pt_peg_import_json\&.n\fR: PEG Import Plugin\&. Read JSON format
.TP
\fBpt::peg::import::peg\fR
\fIfiles/modules/pt/pt_peg_import_peg\&.n\fR: PEG Import Plugin\&. Read PEG format
.TP
\fBpt::peg::interp\fR
\fIfiles/modules/pt/pt_peg_interp\&.n\fR: Interpreter for parsing expression grammars
.TP
\fBpt::peg::to::container\fR
\fIfiles/modules/pt/pt_peg_to_container\&.n\fR: PEG Conversion\&. Write CONTAINER format
.TP
\fBpt::peg::to::cparam\fR
\fIfiles/modules/pt/pt_peg_to_cparam\&.n\fR: PEG Conversion\&. Write CPARAM format
.TP
\fBpt::peg::to::json\fR
\fIfiles/modules/pt/pt_peg_to_json\&.n\fR: PEG Conversion\&. Write JSON format
.TP
\fBpt::peg::to::param\fR
\fIfiles/modules/pt/pt_peg_to_param\&.n\fR: PEG Conversion\&. Write PARAM format
.TP
\fBpt::peg::to::peg\fR
\fIfiles/modules/pt/pt_peg_to_peg\&.n\fR: PEG Conversion\&. Write PEG format
.TP
\fBpt::peg::to::tclparam\fR
\fIfiles/modules/pt/pt_peg_to_tclparam\&.n\fR: PEG Conversion\&. Write TCLPARAM format
.TP
\fBpt::peg_language\fR
\fIfiles/modules/pt/pt_peg_language\&.n\fR: PEG Language Tutorial
.TP
\fBpt::pegrammar\fR
\fIfiles/modules/pt/pt_peg_introduction\&.n\fR: Introduction to Parsing Expression Grammars
.TP
\fBpt::pgen\fR
\fIfiles/modules/pt/pt_pgen\&.n\fR: Parser Generator
.TP
\fBpt::rde\fR
\fIfiles/modules/pt/pt_rdengine\&.n\fR: Parsing Runtime Support, PARAM based
.TP
\fBpt::tclparam::configuration::snit\fR
\fIfiles/modules/pt/pt_tclparam_config_snit\&.n\fR: Tcl/PARAM, Canned configuration, Snit
.TP
\fBpt::tclparam::configuration::tcloo\fR
\fIfiles/modules/pt/pt_tclparam_config_tcloo\&.n\fR: Tcl/PARAM, Canned configuration, Tcloo
.TP
\fBpt::util\fR
\fIfiles/modules/pt/pt_util\&.n\fR: General utilities
.TP
\fBpt_export_api\fR
\fIfiles/modules/pt/pt_to_api\&.n\fR: Parser Tools Export API
.TP
\fBpt_import_api\fR
\fIfiles/modules/pt/pt_from_api\&.n\fR: Parser Tools Import API
.TP
\fBpt_introduction\fR
\fIfiles/modules/pt/pt_introduction\&.n\fR: Introduction to Parser Tools
.TP
\fBpt_parse_peg\fR
\fIfiles/modules/pt/pt_parse_peg\&.n\fR: Parser Tools PEG Parser
.TP
\fBpt_parser_api\fR
\fIfiles/modules/pt/pt_parser_api\&.n\fR: Parser API
.TP
\fBpt_peg_op\fR
\fIfiles/modules/pt/pt_peg_op\&.n\fR: Parser Tools PE Grammar Utility Operations
.TP
\fBrc4\fR
\fIfiles/modules/rc4/rc4\&.n\fR: Implementation of the RC4 stream cipher
.TP
\fBrcs\fR
\fIfiles/modules/rcs/rcs\&.n\fR: RCS low level utilities
.TP
\fBreport\fR
\fIfiles/modules/report/report\&.n\fR: Create and manipulate report objects
.TP
\fBrest\fR
\fIfiles/modules/rest/rest\&.n\fR: define REST web APIs and call them inline or asychronously
.TP
\fBripemd128\fR
\fIfiles/modules/ripemd/ripemd128\&.n\fR: RIPEMD-128 Message-Digest Algorithm
.TP
\fBripemd160\fR
\fIfiles/modules/ripemd/ripemd160\&.n\fR: RIPEMD-160 Message-Digest Algorithm
.TP
\fBS3\fR
\fIfiles/modules/amazon-s3/S3\&.n\fR: Amazon S3 Web Service Interface
.TP
\fBSASL\fR
\fIfiles/modules/sasl/sasl\&.n\fR: Implementation of SASL mechanisms for Tcl
.TP
\fBSASL::NTLM\fR
\fIfiles/modules/sasl/ntlm\&.n\fR: Implementation of SASL NTLM mechanism for Tcl
.TP
\fBSASL::SCRAM\fR
\fIfiles/modules/sasl/scram\&.n\fR: Implementation of SASL SCRAM mechanism for Tcl
.TP
\fBSASL::XGoogleToken\fR
\fIfiles/modules/sasl/gtoken\&.n\fR: Implementation of SASL NTLM mechanism for Tcl
.TP
\fBsha1\fR
\fIfiles/modules/sha1/sha1\&.n\fR: SHA1 Message-Digest Algorithm
.TP
\fBsha256\fR
\fIfiles/modules/sha1/sha256\&.n\fR: SHA256 Message-Digest Algorithm
.TP
\fBsimulation::annealing\fR
\fIfiles/modules/simulation/annealing\&.n\fR: Simulated annealing
.TP
\fBsimulation::montecarlo\fR
\fIfiles/modules/simulation/montecarlo\&.n\fR: Monte Carlo simulations
.TP
\fBsimulation::random\fR
\fIfiles/modules/simulation/simulation_random\&.n\fR: Pseudo-random number generators
.TP
\fBsmtp\fR
\fIfiles/modules/mime/smtp\&.n\fR: Client-side tcl implementation of the smtp protocol
.TP
\fBsmtpd\fR
\fIfiles/modules/smtpd/smtpd\&.n\fR: Tcl SMTP server implementation
.TP
\fBsnit\fR
\fIfiles/modules/snit/snit\&.n\fR: Snit's Not Incr Tcl
.TP
\fBsnitfaq\fR
\fIfiles/modules/snit/snitfaq\&.n\fR: Snit Frequently Asked Questions
.TP
\fBsoundex\fR
\fIfiles/modules/soundex/soundex\&.n\fR: Soundex
.TP
\fBstooop\fR
\fIfiles/modules/stooop/stooop\&.n\fR: Object oriented extension\&.
.TP
\fBstring::token\fR
\fIfiles/modules/string/token\&.n\fR: Regex based iterative lexing
.TP
\fBstring::token::shell\fR
\fIfiles/modules/string/token_shell\&.n\fR: Parsing of shell command line
.TP
\fBstringprep\fR
\fIfiles/modules/stringprep/stringprep\&.n\fR: Implementation of stringprep
.TP
\fBstringprep::data\fR
\fIfiles/modules/stringprep/stringprep_data\&.n\fR: stringprep data tables, generated, internal
.TP
\fBstruct::disjointset\fR
\fIfiles/modules/struct/disjointset\&.n\fR: Disjoint set data structure
.TP
\fBstruct::graph\fR
\fIfiles/modules/struct/graph\&.n\fR: Create and manipulate directed graph objects
.TP
\fBstruct::graph::op\fR
\fIfiles/modules/struct/graphops\&.n\fR: Operation for (un)directed graph objects
.TP
\fBstruct::graph_v1\fR
\fIfiles/modules/struct/graph1\&.n\fR: Create and manipulate directed graph objects
.TP
\fBstruct::list\fR
\fIfiles/modules/struct/struct_list\&.n\fR: Procedures for manipulating lists
.TP
\fBstruct::matrix\fR
\fIfiles/modules/struct/matrix\&.n\fR: Create and manipulate matrix objects
.TP
\fBstruct::matrix_v1\fR
\fIfiles/modules/struct/matrix1\&.n\fR: Create and manipulate matrix objects
.TP
\fBstruct::pool\fR
\fIfiles/modules/struct/pool\&.n\fR: Create and manipulate pool objects (of discrete items)
.TP
\fBstruct::prioqueue\fR
\fIfiles/modules/struct/prioqueue\&.n\fR: Create and manipulate prioqueue objects
.TP
\fBstruct::queue\fR
\fIfiles/modules/struct/queue\&.n\fR: Create and manipulate queue objects
.TP
\fBstruct::record\fR
\fIfiles/modules/struct/record\&.n\fR: Define and create records (similar to 'C' structures)
.TP
\fBstruct::set\fR
\fIfiles/modules/struct/struct_set\&.n\fR: Procedures for manipulating sets
.TP
\fBstruct::skiplist\fR
\fIfiles/modules/struct/skiplist\&.n\fR: Create and manipulate skiplists
.TP
\fBstruct::stack\fR
\fIfiles/modules/struct/stack\&.n\fR: Create and manipulate stack objects
.TP
\fBstruct::tree\fR
\fIfiles/modules/struct/struct_tree\&.n\fR: Create and manipulate tree objects
.TP
\fBstruct::tree_v1\fR
\fIfiles/modules/struct/struct_tree1\&.n\fR: Create and manipulate tree objects
.TP
\fBsum\fR
\fIfiles/modules/crc/sum\&.n\fR: Calculate a sum(1) compatible checksum
.TP
\fBswitched\fR
\fIfiles/modules/stooop/switched\&.n\fR: switch/option management\&.
.TP
\fBtar\fR
\fIfiles/modules/tar/tar\&.n\fR: Tar file creation, extraction & manipulation
.TP
\fBtcl::chan::cat\fR
\fIfiles/modules/virtchannel_base/cat\&.n\fR: Concatenation channel
.TP
\fBtcl::chan::core\fR
\fIfiles/modules/virtchannel_core/core\&.n\fR: Basic reflected/virtual channel support
.TP
\fBtcl::chan::events\fR
\fIfiles/modules/virtchannel_core/events\&.n\fR: Event support for reflected/virtual channels
.TP
\fBtcl::chan::facade\fR
\fIfiles/modules/virtchannel_base/facade\&.n\fR: Facade channel
.TP
\fBtcl::chan::fifo\fR
\fIfiles/modules/virtchannel_base/tcllib_fifo\&.n\fR: In-memory fifo channel
.TP
\fBtcl::chan::fifo2\fR
\fIfiles/modules/virtchannel_base/tcllib_fifo2\&.n\fR: In-memory interconnected fifo channels
.TP
\fBtcl::chan::halfpipe\fR
\fIfiles/modules/virtchannel_base/halfpipe\&.n\fR: In-memory channel, half of a fifo2
.TP
\fBtcl::chan::memchan\fR
\fIfiles/modules/virtchannel_base/tcllib_memchan\&.n\fR: In-memory channel
.TP
\fBtcl::chan::null\fR
\fIfiles/modules/virtchannel_base/tcllib_null\&.n\fR: Null channel
.TP
\fBtcl::chan::nullzero\fR
\fIfiles/modules/virtchannel_base/nullzero\&.n\fR: Null/Zero channel combination
.TP
\fBtcl::chan::random\fR
\fIfiles/modules/virtchannel_base/tcllib_random\&.n\fR: Random channel
.TP
\fBtcl::chan::std\fR
\fIfiles/modules/virtchannel_base/std\&.n\fR: Standard I/O, unification of stdin and stdout
.TP
\fBtcl::chan::string\fR
\fIfiles/modules/virtchannel_base/tcllib_string\&.n\fR: Read-only in-memory channel
.TP
\fBtcl::chan::textwindow\fR
\fIfiles/modules/virtchannel_base/textwindow\&.n\fR: Textwindow channel
.TP
\fBtcl::chan::variable\fR
\fIfiles/modules/virtchannel_base/tcllib_variable\&.n\fR: In-memory channel using variable for storage
.TP
\fBtcl::chan::zero\fR
\fIfiles/modules/virtchannel_base/tcllib_zero\&.n\fR: Zero channel
.TP
\fBtcl::randomseed\fR
\fIfiles/modules/virtchannel_base/randseed\&.n\fR: Utilities for random channels
.TP
\fBtcl::transform::adler32\fR
\fIfiles/modules/virtchannel_transform/adler32\&.n\fR: Adler32 transformation
.TP
\fBtcl::transform::base64\fR
\fIfiles/modules/virtchannel_transform/vt_base64\&.n\fR: Base64 encoding transformation
.TP
\fBtcl::transform::core\fR
\fIfiles/modules/virtchannel_core/transformcore\&.n\fR: Basic reflected/virtual channel transform support
.TP
\fBtcl::transform::counter\fR
\fIfiles/modules/virtchannel_transform/vt_counter\&.n\fR: Counter transformation
.TP
\fBtcl::transform::crc32\fR
\fIfiles/modules/virtchannel_transform/vt_crc32\&.n\fR: Crc32 transformation
.TP
\fBtcl::transform::hex\fR
\fIfiles/modules/virtchannel_transform/hex\&.n\fR: Hexadecimal encoding transformation
.TP
\fBtcl::transform::identity\fR
\fIfiles/modules/virtchannel_transform/identity\&.n\fR: Identity transformation
.TP
\fBtcl::transform::limitsize\fR
\fIfiles/modules/virtchannel_transform/limitsize\&.n\fR: limiting input
.TP
\fBtcl::transform::observe\fR
\fIfiles/modules/virtchannel_transform/observe\&.n\fR: Observer transformation, stream copy
.TP
\fBtcl::transform::otp\fR
\fIfiles/modules/virtchannel_transform/vt_otp\&.n\fR: Encryption via one-time pad
.TP
\fBtcl::transform::rot\fR
\fIfiles/modules/virtchannel_transform/rot\&.n\fR: rot-encryption
.TP
\fBtcl::transform::spacer\fR
\fIfiles/modules/virtchannel_transform/spacer\&.n\fR: Space insertation and removal
.TP
\fBtcl::transform::zlib\fR
\fIfiles/modules/virtchannel_transform/tcllib_zlib\&.n\fR: zlib (de)compression
.TP
\fBtcldes\fR
\fIfiles/modules/des/tcldesjr\&.n\fR: Implementation of the DES and triple-DES ciphers
.TP
\fBtcldes\fR
\fIfiles/modules/des/tcldes\&.n\fR: Implementation of the DES and triple-DES ciphers
.TP
\fBtcldocstrip\fR
\fIfiles/apps/tcldocstrip\&.n\fR: Tcl-based Docstrip Processor
.TP
\fBtcllib_ip\fR
\fIfiles/modules/dns/tcllib_ip\&.n\fR: IPv4 and IPv6 address manipulation
.TP
\fBtclrep/machineparameters\fR
\fIfiles/modules/math/machineparameters\&.n\fR: Compute double precision machine parameters\&.
.TP
\fBtepam\fR
\fIfiles/modules/tepam/tepam_introduction\&.n\fR: An introduction into TEPAM, Tcl's Enhanced Procedure and Argument Manager
.TP
\fBtepam::argument_dialogbox\fR
\fIfiles/modules/tepam/tepam_argument_dialogbox\&.n\fR: TEPAM argument_dialogbox, reference manual
.TP
\fBtepam::doc_gen\fR
\fIfiles/modules/tepam/tepam_doc_gen\&.n\fR: TEPAM DOC Generation, reference manual
.TP
\fBtepam::procedure\fR
\fIfiles/modules/tepam/tepam_procedure\&.n\fR: TEPAM procedure, reference manual
.TP
\fBterm\fR
\fIfiles/modules/term/term\&.n\fR: General terminal control
.TP
\fBterm::ansi::code\fR
\fIfiles/modules/term/ansi_code\&.n\fR: Helper for control sequences
.TP
\fBterm::ansi::code::attr\fR
\fIfiles/modules/term/ansi_cattr\&.n\fR: ANSI attribute sequences
.TP
\fBterm::ansi::code::ctrl\fR
\fIfiles/modules/term/ansi_cctrl\&.n\fR: ANSI control sequences
.TP
\fBterm::ansi::code::macros\fR
\fIfiles/modules/term/ansi_cmacros\&.n\fR: Macro sequences
.TP
\fBterm::ansi::ctrl::unix\fR
\fIfiles/modules/term/ansi_ctrlu\&.n\fR: Control operations and queries
.TP
\fBterm::ansi::send\fR
\fIfiles/modules/term/ansi_send\&.n\fR: Output of ANSI control sequences to terminals
.TP
\fBterm::interact::menu\fR
\fIfiles/modules/term/imenu\&.n\fR: Terminal widget, menu
.TP
\fBterm::interact::pager\fR
\fIfiles/modules/term/ipager\&.n\fR: Terminal widget, paging
.TP
\fBterm::receive\fR
\fIfiles/modules/term/receive\&.n\fR: General input from terminals
.TP
\fBterm::receive::bind\fR
\fIfiles/modules/term/term_bind\&.n\fR: Keyboard dispatch from terminals
.TP
\fBterm::send\fR
\fIfiles/modules/term/term_send\&.n\fR: General output to terminals
.TP
\fBtextutil\fR
\fIfiles/modules/textutil/textutil\&.n\fR: Procedures to manipulate texts and strings\&.
.TP
\fBtextutil::adjust\fR
\fIfiles/modules/textutil/adjust\&.n\fR: Procedures to adjust, indent, and undent paragraphs
.TP
\fBtextutil::expander\fR
\fIfiles/modules/textutil/expander\&.n\fR: Procedures to process templates and expand text\&.
.TP
\fBtextutil::repeat\fR
\fIfiles/modules/textutil/repeat\&.n\fR: Procedures to repeat strings\&.
.TP
\fBtextutil::split\fR
\fIfiles/modules/textutil/textutil_split\&.n\fR: Procedures to split texts
.TP
\fBtextutil::string\fR
\fIfiles/modules/textutil/textutil_string\&.n\fR: Procedures to manipulate texts and strings\&.
.TP
\fBtextutil::tabify\fR
\fIfiles/modules/textutil/tabify\&.n\fR: Procedures to (un)tabify strings
.TP
\fBtextutil::trim\fR
\fIfiles/modules/textutil/trim\&.n\fR: Procedures to trim strings
.TP
\fBtie\fR
\fIfiles/modules/tie/tie\&.n\fR: Array persistence
.TP
\fBtie\fR
\fIfiles/modules/tie/tie_std\&.n\fR: Array persistence, standard data sources
.TP
\fBtiff\fR
\fIfiles/modules/tiff/tiff\&.n\fR: TIFF reading, writing, and querying and manipulation of meta data
.TP
\fBtool\fR
\fIfiles/modules/tool/tool\&.n\fR: Dictionary Tools
.TP
\fBtool::dict_ensemble\fR
\fIfiles/modules/tool/tool_dict_ensemble\&.n\fR: Dictionary Tools
.TP
\fBtransfer::connect\fR
\fIfiles/modules/transfer/connect\&.n\fR: Connection setup
.TP
\fBtransfer::copy\fR
\fIfiles/modules/transfer/copyops\&.n\fR: Data transfer foundation
.TP
\fBtransfer::copy::queue\fR
\fIfiles/modules/transfer/tqueue\&.n\fR: Queued transfers
.TP
\fBtransfer::data::destination\fR
\fIfiles/modules/transfer/ddest\&.n\fR: Data destination
.TP
\fBtransfer::data::source\fR
\fIfiles/modules/transfer/dsource\&.n\fR: Data source
.TP
\fBtransfer::receiver\fR
\fIfiles/modules/transfer/receiver\&.n\fR: Data source
.TP
\fBtransfer::transmitter\fR
\fIfiles/modules/transfer/transmitter\&.n\fR: Data source
.TP
\fBtreeql\fR
\fIfiles/modules/treeql/treeql\&.n\fR: Query tree objects
.TP
\fBtry\fR
\fIfiles/modules/try/tcllib_try\&.n\fR: try - Trap and process errors and exceptions
.TP
\fBtry\fR
\fIfiles/modules/try/tcllib_throw\&.n\fR: throw - Throw an error exception with a message
.TP
\fBuevent\fR
\fIfiles/modules/uev/uevent\&.n\fR: User events
.TP
\fBuevent::onidle\fR
\fIfiles/modules/uev/uevent_onidle\&.n\fR: Request merging and deferal to idle time
.TP
\fBunicode\fR
\fIfiles/modules/stringprep/unicode\&.n\fR: Implementation of Unicode normalization
.TP
\fBunicode::data\fR
\fIfiles/modules/stringprep/unicode_data\&.n\fR: unicode data tables, generated, internal
.TP
\fBunits\fR
\fIfiles/modules/units/units\&.n\fR: unit conversion
.TP
\fBuri\fR
\fIfiles/modules/uri/uri\&.n\fR: URI utilities
.TP
\fBuri_urn\fR
\fIfiles/modules/uri/urn-scheme\&.n\fR: URI utilities, URN scheme
.TP
\fBuuencode\fR
\fIfiles/modules/base64/uuencode\&.n\fR: UU-encode/decode binary data
.TP
\fBuuid\fR
\fIfiles/modules/uuid/uuid\&.n\fR: UUID generation and comparison
.TP
\fBvaltype::common\fR
\fIfiles/modules/valtype/valtype_common\&.n\fR: Validation, common code
.TP
\fBvaltype::creditcard::amex\fR
\fIfiles/modules/valtype/cc_amex\&.n\fR: Validation for AMEX creditcard number
.TP
\fBvaltype::creditcard::discover\fR
\fIfiles/modules/valtype/cc_discover\&.n\fR: Validation for Discover creditcard number
.TP
\fBvaltype::creditcard::mastercard\fR
\fIfiles/modules/valtype/cc_mastercard\&.n\fR: Validation for Mastercard creditcard number
.TP
\fBvaltype::creditcard::visa\fR
\fIfiles/modules/valtype/cc_visa\&.n\fR: Validation for VISA creditcard number
.TP
\fBvaltype::gs1::ean13\fR
\fIfiles/modules/valtype/ean13\&.n\fR: Validation for EAN13
.TP
\fBvaltype::iban\fR
\fIfiles/modules/valtype/iban\&.n\fR: Validation for IBAN
.TP
\fBvaltype::imei\fR
\fIfiles/modules/valtype/imei\&.n\fR: Validation for IMEI
.TP
\fBvaltype::isbn\fR
\fIfiles/modules/valtype/isbn\&.n\fR: Validation for ISBN
.TP
\fBvaltype::luhn\fR
\fIfiles/modules/valtype/luhn\&.n\fR: Validation for plain number with a LUHN checkdigit
.TP
\fBvaltype::luhn5\fR
\fIfiles/modules/valtype/luhn5\&.n\fR: Validation for plain number with a LUHN5 checkdigit
.TP
\fBvaltype::usnpi\fR
\fIfiles/modules/valtype/usnpi\&.n\fR: Validation for USNPI
.TP
\fBvaltype::verhoeff\fR
\fIfiles/modules/valtype/verhoeff\&.n\fR: Validation for plain number with a VERHOEFF checkdigit
.TP
\fBwebsocket\fR
\fIfiles/modules/websocket/websocket\&.n\fR: Tcl implementation of the websocket protocol
.TP
\fBwip\fR
\fIfiles/modules/wip/wip\&.n\fR: Word Interpreter
.TP
\fBxsxp\fR
\fIfiles/modules/amazon-s3/xsxp\&.n\fR: eXtremely Simple Xml Parser
.TP
\fByaml\fR
\fIfiles/modules/yaml/yaml\&.n\fR: YAML Format Encoder/Decoder
.TP
\fByencode\fR
\fIfiles/modules/base64/yencode\&.n\fR: Y-encode/decode binary data
.TP
\fBzipfile::decode\fR
\fIfiles/modules/zip/decode\&.n\fR: Access to zip archives
.TP
\fBzipfile::encode\fR
\fIfiles/modules/zip/encode\&.n\fR: Generation of zip archives
.TP
\fBzipfile::mkzip\fR
\fIfiles/modules/zip/mkzip\&.n\fR: Build a zip archive