.\" $Id: comm.n,v 1.4 2002/01/18 20:51:15 andreas_kupries Exp $
.\" %%_OSF_FREE_COPYRIGHT_%%
.\" Copyright (C) 1995-1998 The Open Group.   All Rights Reserved.
.\" (Please see the file "comm.LICENSE" that accompanied this source)
.\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH comm n 3.7 comm "package comm 3.7.1"
.SH NAME
comm.tcl \- A remote communications facility for Tcl (7.6, 8.0, and later)
.SH SYNOPSIS
.nf
\fBpackage require comm ?3.7.1?\fR
.sp
\fIchan \fBnew \fIchan\fR ?\fIname value ...\fR?
\fIchan \fBsend \fR?\fI-async\fR? \fIid cmd \fR?\fIarg arg ...\fR?
\fIchan \fBhook \fIevent\fR ?\fB+\fR??\fIscript\fR?
\fIchan \fIoption\fP ?\fI arg arg ...\fR?
.fi
The package initializes \fB::comm::comm\fR as the default \fIchan\fR.
.SH "INTRODUCTION"
.PP
The
.B comm
command provides an inter-interpreter remote execution facility
much like Tk's
.IR send "(n)",
except that it uses sockets rather than
the X server for the communication path.
As a result,
.B comm
works with multiple interpreters,
works on Windows and Macintosh systems,
and
provides control over the remote execution path.
.LP
These commands work just like
.B send
and
.BR "winfo interps" :
.CS
 \fB::comm::comm send \fR?\fI-async\fR? \fIid cmd \fR?\fIarg arg ...\fR?
 \fB::comm::comm interps\fP
.CE
.PP
This is all that is really needed to know in order to use
.BR comm .
'\"
'\"
'\"
.SH DESCRIPTION
.PP
.B comm
names communication endpoints with an
.I id
unique to each machine.
Before sending commands, the
.I id
of another interpreter is needed.
Unlike Tk's send,
.B comm
doesn't implicitly know the
.IR id 's
of all the interpreters on the system.
.TP
\fB::comm::comm send \fR?\fI-async\fR? \fIid cmd \fR?\fIarg arg ...\fR? 
This invokes the given command in the interpreter named by
.IR id .
The command waits for the result and remote errors are returned
unless the
.B -async
option is given.
.TP
\fB::comm::comm self\fP
Returns the
.I id
for this channel.
.TP
\fB::comm::comm interps\fP
Returns a list of all the remote
.IR id 's
to which this channel is connected.
.B comm
learns a new remote
.I id
when a command is first issued it,
or when a remote
.I id
first issues a command to this comm channel.
\fB::comm::comm ids\fP
is an alias for this method.
.TP
\fB::comm::comm connect \fR?\fIid\fR?
Whereas
.B "::comm::comm send"
will automatically connect to the given
.IR id ,
this forces a connection to a remote
.I id
without sending a command.
After this, the remote
.I id
will appear in
.BR "::comm::comm interps" .
.LP
These four methods make up the basic
.B comm
interface.
'\"
'\"
'\"
.SH "EVAL SEMANTICS"
.PP
The evaluation semantics of
.B "::comm::comm send"
are intended to match Tk's
.B send
.IR exactly .
This means that
.B comm
evaluates arguments on the remote side.
.LP
If you find that
.B "::comm::comm send"
doesn't work for a particular command,
try the same thing with Tk's send and see if the result is different.
If there is a problem, please report it.
For instance, there was had one report that this command produced an error.
Note that the equivalent
.B send
command also produces the same error.
.CS
 % \fB::comm::comm send \fIid\fP llength {a b c}
 \fBwrong # args: should be "llength list"\fR
 % \fBsend \fIname\fP llength {a b c}
 \fBwrong # args: should be "llength list"\fR
.CE
.LP
The
.B eval
hook (described below) can be used to change from
.BR send 's
double eval semantics to single eval semantics.
'\"
'\"
'\"
.SH "MULTIPLE CHANNELS"
.PP
More than one
.B comm
channel (or
.IR listener )
can be created in each Tcl interpeter.
This allows flexibility to create full and restricted channels.
For instance,
.B hook
scripts are specific to the channel they are defined against. 
.TP
\fB::comm::comm new \fIchan\fR ?\fIname value ...\fR?
This creates a new channel and Tcl command with the given channel name.
This new command controls the new channel and takes all the same
arguments as
.BR ::comm::comm .
Any remaining arguments are passed to the
.B config
method.
.TP
\fB::comm::comm channels\fR
This lists all the channels allocated in this Tcl interpreter.
.LP
The default configuration parameters for a new channel are:
.PP
.CS
.B "-port 0 -local 1 -listen 0"
.CE
.PP
The default channel
.B ::comm::comm
is created with:
.PP
.CS
.B "::comm::comm new ::comm::comm -port 0 -local 1 -listen 1"
.CE
'\"
'\"
'\"
.SH "CHANNEL CONFIGURATION"
.PP
The
.B config
method acts similar to
.B fconfigure
in that it sets or queries configuration variables associated with a channel.
.RS
\fB::comm::comm config
.br
\fB::comm::comm config \fIname\fR
.br
\fB::comm::comm config ?\fIname value ...\fR?
.RE
When given no arguments,
.B config
returns a list of all variables and their value
With one argument,
.B config
returns the value of just that argument.
With an even number of arguments, the given variables are set to the
given values.
.PP
These configuration variables can be changed
(descriptions of them are elsewhere in this manual page):
.RS
-\fBlisten \fR?\fI0|1\fR?
-\fBlocal \fR?\fI0|1\fR?
-\fBport \fR?\fIport\fR?
.RE
.sp
These configuration variables are readonly:
.RS
-\fBchan\fR \fIchan\fR
-\fBserial\fR \fIn\fR
-\fBsocket\fR sock\fIn\fR
.RE
.PP
When
.B config
changes the parameters of an existing channel,
it closes and reopens the listening socket.
An automatically assigned channel
.I id
will change when this happens.
Recycling the socket is done by invoking
.BR "::comm::comm abort" ,
which causes all active sends to terminate.
'\"
'\"
'\"
.SH "ID/PORT ASSIGNMENTS"
.PP
.B comm
uses a TCP port for endpoint
.IR id .
The
.B interps
(or
.BR ids )
method merely lists all the TCP ports to which the channel is connected.
By default, each channel's
.I id
is randomly assigned by the operating system
(but usually starts at a low value around 1024 and increases
each time a new socket is opened).
This behavior is accomplished by giving the
.B "-port"
config option a value of 0.
Alternately, a specific TCP port number may be provided for a given channel.
As a special case, comm contains code to allocate a
a high-numbered TCP port (>10000) by using
.BR "-port {}" .
Note that a channel won't be created and initialized
unless the specific port can be allocated.
.PP
As a special case, if the channel is configured with
.BR "-listen 0",
then it will not create a listening socket and will use an id of
.I 0
for itself.
Such a channel is only good for outgoing connections
(although once a connection is established, it can carry send traffic
in both directions).
'\"
'\"
'\"
.SH "REMOTE INTERPRETERS"
.PP
By default, each channel is restricted to accepting connections from the
local system.  This can be overriden by using the
.B "-local 0"
configuration option
For such channels, the
.I id
parameter takes the form
.BI { "id host" }
.BR "" .
.LP
.BR WARNING :
The
.I host
must always be specified in the same form
(e.g., as either a fully qualified domain name,
plain hostname or an IP address).
'\"
'\"
'\"
.SH "CLOSING CONNECTIONS"
.PP
These methods give control over closing connections:
.TP
\fB::comm::comm shutdown \fIid\fR 
This closes the connection to
.IR id ,
aborting all outstanding commands in progress.  Note that nothing
prevents the connection from being immediately reopened by another
incoming or outgoing command.
.TP
\fB::comm::comm abort\fR
This invokes shutdown on all open connections in this comm channel.
.TP
\fB::comm::comm destroy\fR
This aborts all connections and then destroys the this comm channel itself,
including closing the listening socket.
Special code allows the default
.B ::comm::comm
channel to be closed
such that the
.B ::comm::comm
command it is not destroyed.
Doing so closes the listening socket, preventing both
incoming and outgoing commands on the channel.
This sequence reinitializes the default channel:
.CS
.B "::comm::comm destroy; ::comm::comm new ::comm::comm"
.CE
.PP
When a remote connection is lost (because the remote exited or called
.BR shutdown ),
.B comm
can invoke an application callback.
This can be used to cleanup or restart an ancillary process,
for instance.
See the
.B lost
callback below.
'\"
'\"
'\"
.SH CALLBACKS
.PP
This is a mechanism for setting hooks for particular events:
.CS
 \fB::comm::comm hook \fIevent\fR ?\fB+\fR??\fIscript\fR? 
.CE
.LP
This uses a syntax similar to Tk's
.B bind
command.
Prefixing
.I script
with a + causes the new script to be appended.
Without this, a new
.I script
replaces any existing script.
When invoked without a script, no change is made.
In all cases, the new hook script is returned by the command.
.LP
When an
.I event
occurs,
the
.I script
associated with it is evaluated
with the listed variables in scope and available.
The return code
.RB ( not
the return value) of the script
is commonly used decide how to further process after the hook.
.LP
Common variables include:
.RS
.IP \fBchan\fR 5
the name of the comm channel (and command)
.IP \fBid\fR 5
the id of the remote in question
.IP \fBfid\fR 5
the file id for the socket of the connection
.RE
.ta 4i
These are the defined
.IR events :
.TP
\fBconnecting\fR
Variables:
.I "chan id host port"
.br
This hook is invoked before making a connection
to the remote named in
.IR id .
An error return (via
.BR error )
will abort the connection attempt with the error.
Example:
.sp
.CS
 % ::comm::comm hook connecting {
     if [string match {*[02468]} $id] {
         error "Can't connect to even ids" 
     }
 }
 % ::comm::comm send 10000 puts ok
 Connect to remote failed: Can't connect to even ids
 % 
.CE
.\"
.TP
.B connected
Variables:
.I "chan fid id host port"
.br
This hook is invoked immediately after making a remote connection to
.IR id ,
allowing arbitrary authentication over the socket
named by
.IR fid .
An error return (via
.BR error )
will close the connection with the error.
.I host
and
.I port
are merely extracted from the
.IR id ;
changing any of these will have no effect on the connection, however.
It is also possible to substitute and replace \fIfid\fP.
.\"
.TP
\fBincoming\fP
Variables:
.I "chan fid addr remport"
.br
Hook invoked when receiving an incoming connection,
allowing arbitrary authentication over socket
named by
.IR fid .
An error return (via
.BR error )
will close the connection with the error.
Note that the peer is named by
.IR remport " and " addr
but that the remote
.I id
is still unknown.  Example:
.sp
.CS
 ::comm::comm hook incoming {
     if [string match 127.0.0.1 $addr] {
         error "I don't talk to myself"
     }
 }
.CE
.\"
.TP
\fBeval\fP
Variables:
.I "chan id cmd buffer"
.br
This hook is invoked after collecting a complete script from a remote
but
.B before
evalutating it.
This allows complete control over the processing of incoming commands.
.I cmd
contains either
.BR send " or " async .
.I buffer
holds the script to evaluate.
At the time the hook is called,
.B "$chan remoteid"
is identical in value to
.BR id.
.sp
By changing
.IR buffer ,
the hook can change the script to be evaluated.
The hook can short circuit evaluation and cause a
value to be immediately returned by using
.B return
.I result
(or, from within a procedure,
.B "return -code return"
.IR result ).
An error return (via
.BR error )
will return an error result, as is if the script caused the error.
Any other return will evaluate the script in
.I buffer
as normal.
For compatibility with 3.2,
.B break
and
.B "return -code break"
.I result
is supported, acting similarly to
.B "return {}"
and
.B "return -code return" 
.IR result .
.sp
Examples:
.RS
1. augmenting a command
.PP
.CS
 % ::comm::comm send [::comm::comm self] pid
 5013
 % ::comm::comm hook eval {puts "going to execute $buffer"}
 % ::comm::comm send [::comm::comm self] pid
 going to execute pid
 5013
.CE
.PP
2. short circuting a command
.PP
.CS
 % ::comm::comm hook eval {puts "would have executed $buffer"; return 0}
 % ::comm::comm send [::comm::comm self] pid
 would have executed pid
 0
.CE
.PP
3. Replacing double eval semantics
.PP
.CS
 % ::comm::comm send [::comm::comm self] llength {a b c}
 wrong # args: should be "llength list"
 % ::comm::comm hook eval {return [uplevel #0 $buffer]}
 return [uplevel #0 $buffer]
 % ::comm::comm send [::comm::comm self] llength {a b c}
 3
.CE
.PP
4. Using a slave interpreter
.PP
.CS
 % interp create foo
 % ::comm::comm hook eval {return [foo eval $buffer]}
 % ::comm::comm send [::comm::comm self] set myvar 123
 123
 % set myvar
 can't read "myvar": no such variable
 % foo eval set myvar
 123
.CE
.PP
5. Using a slave interpreter (double eval)
.PP
.CS
 % ::comm::comm hook eval {return [eval foo eval $buffer]}
.CE
.PP
6. Subverting the script to execute
.PP
.CS
 % ::comm::comm hook eval {
     switch -- $buffer {
         a {return A-OK} b {return B-OK} default {error "$buffer is a no-no"}
     }
 }
 % ::comm::comm send [::comm::comm self] pid
 pid is a no-no
 % ::comm::comm send [::comm::comm self] a
 A-OK
.CE
.RE

.\"
.TP
\fBreply\fP
Variables:
.I "chan id buffer ret return()"
.br
This hook is invoked after collecting a complete reply script from a remote
but
.B before
evalutating it.
This allows complete control over the processing of replies to sent commands.
The reply
.I buffer
is in one of the following forms
.RS
.CS
 return \fIresult\fP
 return -code \fIcode\fP \fIresult\fP
 return -code \fIcode\fP -errorinfo \fIinfo\fP -errorcode \fIecode\fP \fImsg\fP
.CE
.PP
For safety reasons, this is decomposed.  The return result
is in 
.IR ret ,
and the return switches are in the return array:
.CS
.I return(-code)
.I return(-errorinfo)
.I return(-errordcode)
.CE
.PP
Any of these may be the empty string.
Modifying
these four variables can change the return value, whereas
modifying
.I buffer
has no effect.
.RE
.\"
.TP
\fBlost\fP
Variables:
.I "chan id reason"
.br
This hook is invoked when the connection to
.I id
is lost.
Return value (or thrown error) is ignored.
.I reason
is an explanatory string indicating why the connection was lost.
Example:
.sp
.CS
 ::comm::comm hook lost {
     global myvar
     if {$myvar(id) == $id} {
         myfunc
         return
     }
 }
.CE
.SH UNSUPPORTED
.PP
These interfaces may change or go away in subsequence releases.
.TP
\fB::comm::comm remoteid\fR 
Returns the
.I id
of the sender of the last remote command executed on this channel.
If used by a proc being invoked remotely, it
must be called before any events are processed.
Otherwise, another command may get invoked and change the value.
.TP
.B "::comm::comm_send"
Invoking this procedure will substitute the Tk
.B send
and
.B "winfo interps"
commands with these equivalents that use
.BR ::comm::comm .
.sp
.CS
 proc send {args} {
     eval ::comm::comm send $args
 }
 rename winfo tk_winfo
 proc winfo {cmd args} {
     if ![string match in* $cmd] {return [eval [list tk_winfo $cmd] $args]}
     return [::comm::comm interps]
 }
.CE
'\"
'\"
'\"
.SH SECURITY
.PP
Something here soon.
'\"
'\"
'\"
.SH "BLOCKING SEMANTICS"
.PP
There is one outstanding difference between
.B comm
and
.BR send .
When blocking in a synchronous remote command,
.B send
uses an internal C hook (Tk_RestrictEvents)
to the event loop to look ahead for
send-related events and only process those without processing any other events.
In contrast,
.B comm
uses the
.B vwait
command as a semaphore to indicate the return message has arrived.
The difference is that a synchronous
.B send
will block the application and prevent all events
(including window related ones) from being processed,
while a synchronous
.B comm
will block the application but still allow
other events will still get processed.
In particular,
.B "after idle"
handlers will fire immediately when comm blocks.
.LP
What can be done about this?
First, note that this behavior will come from any code using
.B vwait
to block and wait for an event to occur.
At the cost of multiple channel support,
.B comm
could be changed to do blocking I/O on the socket,
giving send-like blocking semantics.
However, multiple channel support is a very useful feature of comm
that it is deemed too important to lose.
The remaining approaches involve a new loadable module written in C
(which is somewhat against the philosophy of
.BR comm )
One way would be to create a modified version of the
.B vwait
command that allow the event flags passed to Tcl_DoOneEvent to be specified.
For
.BR comm ,
just the TCL_FILE_EVENTS would be processed.
Another way would be to implement a mechanism like Tk_RestrictEvents, but
apply it to the Tcl event loop (since
.B comm
doesn't require Tk).
One of these approaches will be available in a future
.B comm
release as an optional component.
'\"
'\"
'\"
.SH COMPATIBILITY
.PP
.B Comm
exports itself as a package.
The package version number is in the form
.IR major . minor ,
where the major version will only change when
a non-compatible change happens to the API or protocol.
Minor bug fixes and changes will only affect the minor version.
To load
.B comm
this command is usually used:
.PP
.CS
 \fBpackage require comm 3\fR
.CE
.PP
Note that requiring no version (or a specific version) can also be done.
.LP
The revision history of
.B comm
includes these releases:

.IP "3.7" 5
Moved into tcllib and placed in a proper namespace.

.IP "3.6" 5
A bug in the looking up of the remoteid for a executed command
could be triggered when the connection was closed while several
asynchronous sends were queued to be executed.

.IP "3.5" 5
Internal change to how reply messages from a
.B send
are handled.
Reply messages are now decoded into the
.I value
to pass to
.BR return ;
a new return statement is then cons'd up to with this value.
Previously, the return code was passed in from the remote as a
command to evaluate.  Since the wire protocol has not changed,
this is still the case.  Instead, the reply handling code decodes the
.B reply
message.

.IP "3.4" 5
Added more source commentary, as well as documenting config variables
in this man page.
Fixed bug were loss of connection would give error about a variable
named
.B pending
rather than the message about the lost connection.
.B "comm ids"
is now an alias for
.B "comm interps"
(previously, it an alias for
.BR "comm chans" ).
Since the method invocation change of 3.0, break and other exceptional
conditions were not being returned correctly from
.BR "comm send" .
This has been fixed by removing the extra level of indirection into
the internal procedure
.BR commSend .
Also added propogation of the
.I errorCode
variable.
This means that these commands return exactly as they would with
.BR send :
.RS
.CS
 comm send \fIid\fP break
 catch {comm send \fIid\fP break}
 comm send \fIid\fP expr 1 / 0
.CE
.PP
Added a new hook for reply messages.
Reworked method invocation to avoid the use of comm:* procedures;
this also cut the invocation time down by 40%.
Documented
.B "comm config"
(as this manual page still listed the defunct
.BR "comm init" !)
.RE

.IP "3.3" 5
Some minor bugs were corrected and the documentation was cleaned up.
Added some examples for hooks.  The return semantics of the
.B eval
hook were changed.

.IP "3.2" 5
A new wire protocol, version 3, was added.  This is backwards compatible
with version 2 but adds an exchange of supported protocol versions to
allow protocol negotiation in the future.
Several bugs with the hook implementation were fixed.
A new section of the man page on blocking semantics was added.

.IP "3.1" 5
All the documented hooks were implemented.
.B commLostHook
was removed.
A bug in
.B "comm new"
was fixed.

.IP "3.0" 5
This is a new version of
.B comm
with several major changes.
There is a new way of creating the methods available under the
.B comm
command.
The
.B "comm init"
method has been retired and is replaced by
.B "comm configure"
which allows access to many of the well-defined internal variables.
This also generalizes the options available to
.BR "comm new" .
Finally, there is now a protocol version exchanged when a connection
is established.  This will allow for future on-wire protocol changes.
Currently, the protocol version is set to 2.

.IP "2.3" 5
.B "comm ids"
was renamed to
.BR "comm channels" .
General support for
.B "comm hook"
was fully implemented, but
only the
.B lost
hook exists, and it was changed to follow the general hook API.
.B commLostHook
was unsupported (replaced by
.BR "comm hook lost" )
and
.B commLost
was removed.
.IP "2.2" 5
The 
.B died
hook was renamed
.BR lost ,
to be accessed by
.B commLostHook
and an early implementation of
.BR "comm lost hook" .
As such,
.B commDied
is now
.BR commLost .

.IP "2.1" 5
Unsupported method
.B "comm remoteid"
was added.

.IP "2.0" 5
.B comm
has been rewritten from scratch (but is fully compatible with Comm 1.0,
without the requirement to use obTcl).
'\"
.SH AUTHOR
John LoVerso, John@LoVerso.Southborough.MA.US
.PP
.I http://www.opengroup.org/~loverso/tcl-tk/#comm
'\"
.SH COPYRIGHT
Copyright (C) 1995-1998 The Open Group.   All Rights Reserved.
Please see the file
.I comm.LICENSE
that accompanied this source,
or
.IR http://www.opengroup.org/www/dist_client/caubweb/COPYRIGHT.free.html .
.PP
This license for
.BR comm ,
new as of version 3.2,
allows it to be used for free,
without any licensing fee or royalty.
'\"
'\"
'\"
.SH BUGS
.IP \(bu
If there is a failure initializing a channel created with
.BR "::comm::comm new" ,
then the channel should be destroyed.
Currently, it is left in an inconsistent state.
.IP \(bu
There should be a way to force a channel to quiesce when changing the
configuration.
.LP
The following items can be implemented with the existing hooks
and are listed here as a reminder to provide a sample hook in a future version.
.IP \(bu
Allow easier use of a slave interp for actual command execution
(especially when operating in "not local" mode).
.IP \(bu
Add host list (xhost-like) or "magic cookie" (xauth-like)
authentication to initial handshake.
.LP
The following are outstanding todo items.
.IP \(bu
Add an interp discovery and name->port mapping.
This is likely to be in a separate, optional nameserver.
(See also the related work, below.)
.IP \(bu
Fix the
.I "{id host}"
form so as not to be dependent upon canonical hostnames.
This requires fixes to Tcl to resolve hostnames!
.LP
.sp 2
This man page is bigger than the source file.
'\"
'\"
'\"
.SH "ON USING OLD VERSIONS OF TCL"
.PP
Tcl7.5 under Windows contains a bug that causes the interpreter to
hang when EOF is reached on non-blocking sockets.  This can be
triggered with a command such as this:
.CS
.B "comm send $other exit"
.CE
.PP
Always make sure the channel is quiescent before closing/exiting or
use at least Tcl7.6 under Windows.
.LP
Tcl7.6 on the Mac contains several bugs.  It is recommended you use
at least Tcl7.6p2.
.LP
Tcl8.0 on UNIX contains a socket bug that can crash Tcl.  It is recommended
you use Tcl8.0p1 (or Tcl7.6p2).
'\"
'\"
'\"
.SH "RELATED WORK"
.PP
Tcl-DP provides an RPC-based remote execution interface, but is a compiled
Tcl extension.  See
.IR http://www.cs.cornell.edu/Info/Projects/zeno/Projects/Tcl-DP.html .
.PP
Michael Doyle <miked@eolas.com> has code that implements the Tcl-DP RPC
interface using standard Tcl sockets, much like
.BR comm .
.PP
Andreas Kupries <andreas_kupries@users.sourceforge.net> uses
.B comm
and has built a simple nameserver as part of his Pool library.
See
.IR http://www.purl.org/net/akupries/soft/pool/index.htm .
'\"
'\"
'\"
.SH "SEE ALSO"
send(n)
'\"
'\" eof
'\"
