
/***** dependency graph *******/

/**/
struct DEPENDENCY
{
	struct NODE *node;
	struct DEPENDENCY *next;
};

/**/
struct NODE
{
	/* *** */
	struct GRAPH *graph;
	struct NODE *next;
	struct NODE *hashnext;
	struct DEPENDENCY *firstdep; /* list of dependencies */

	/* filename and the tool to build the resource */
	char *filename; /* this contains the filename with the FULLPATH */
	char *tool; /* should be an id or something into an array of tools */

	unsigned int hashid;
	
	unsigned int timestamp;
	unsigned int id; /* is this needed at all? */
	
	/* various flags */
	unsigned int dirty:1; /* set if the node has to be rebuilt */
	unsigned int depchecked:1; /* set if a dependency checker have processed the file */
	unsigned int cached:1;
	
	unsigned int workstatus:2; /* 0 = undone, 1 = in the workings, 2 = done*/
};

struct HEAP;
struct GRAPH;

/* node status */
#define NODESTATUS_UNDONE 0
#define NODESTATUS_WORKING 1
#define NODESTATUS_DONE 2

/* node creation error codes */
#define NODECREATE_OK 0
#define NODECREATE_EXISTS 1
#define NODECREATE_NOTNICE 2

/* node walk flags */
#define NODEWALK_FORCE 1
#define NODEWALK_TOPDOWN 2
#define NODEWALK_BOTTOMUP 4
#define NODEWALK_UNDONE 8
#define NODEWALK_QUICK 16

/* you destroy graphs by destroying the heap */
struct GRAPH *node_create_graph(struct HEAP *heap);

int node_create(struct NODE **node, struct GRAPH *graph, const char *filename, const char *tool);
struct NODE *node_find(struct GRAPH *graph, const char *filename);
struct NODE *node_add_dependency(struct NODE *node, const char *filename);

struct WALKINFO
{
	struct NODE *node;
	void *userdata;
	unsigned depth;
};

int node_walk(
	struct NODE *node,
	int flags,
	int (*callback)(struct NODE*, void *u),
	void *u);

void node_debug_dump(struct GRAPH *graph);

