
COMP_OPTIONS := $(EXTRA_COMP_OPTIONS)
LINK_OPTIONS := $(EXTRA_LINK_OPTIONS)

ifdef PRETTY_PRINT
	COMP_OPTIONS += --pretty-print
	LINK_OPTIONS += --pretty-print
endif

ifdef NO_LINK_OPTIMIZATION
	LINK_OPTIONS += --no-factorization --no-strip
endif

PROGRAMS = run-demo

TARGETS = $(patsubst %,%.go,$(PROGRAMS))

TDC := theme-d-compile
TDL := theme-d-link

.PHONY : all clean

all : $(TARGETS)

clean :
	-rm -f $(TARGETS) $(patsubst %,%.tcp,$(PROGRAMS))
	-rm -f *.tci
	-rm -f *.tcb
	-rm -f *.tcp

$(TARGETS) : %.go : %.tcp
	$(TDL) $(LINK_OPTIONS) -m ../..: -o $@ $<

%.tcp : %.thp
	$(TDC) $(COMP_OPTIONS) -m ../..: -o $@ $<

%.tci : %.thi
	$(TDC) $(COMP_OPTIONS) -m ../..: -o $@ $<

%.tcb : %.thb %.tci
	$(TDC) $(COMP_OPTIONS) -m ../..: -o $@ $<

run-demo.tcp : demo.tci \
	dialog.tci panes.tci sizegroup.tci button-box.tci \
	list-store.tci tree-store.tci \
	appwindow.tci \
	support.tci

run-demo.go : demo.tcb \
	dialog.tcb panes.tcb sizegroup.tcb button-box.tcb \
	list-store.tcb tree-store.tcb \
	appwindow.tcb \
	support.tcb

dialog.tci : demo.tci

dialog.tcb : support.tci

panes.tci : demo.tci

panes.tcb : support.tcb

sizegroup.tci : demo.tci

sizegroup.tcb : support.tcb

button-box.tci : demo.tci

button-box.tcb : support.tcb

list-store.tci : demo.tci

list-store.tcb : support.tcb

tree-store.tci : demo.tci

tree-store.tcb : support.tcb

appwindow.tci : demo.tci

appwindow.tcb : support.tcb
