/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2014 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef EIGEN_SEEN
#define EIGEN_SEEN

void
eigen3(double **z, double *eigenval);

void
eigen4(double **Q, double *eigenval);

void
eigenval4(double **Q, double *eigenval);

double
pythag(double a, double b);

void
tred24(double **a, double *d, double *e);

void
tred24vals(double **a, double *d, double *e);

void
tqli4(double *d, double *e, double **z);

void
tqli4vals(double *d, double *e, double **z);

int
jacobi3(double **a, double *d, double **v, double tol);

int
jacobi3_cyc(double **a, double *d, double **v, double tol);

void
jacobi4(double **a, double *d, double **v);

void
rotate(double **a, double s, double tau,
       int i, int j, int k, int l);

double
InvSymEigenOp(double **invmat, const double **mat, int n,
              double *evals, double **evecs, const double tol);

void
EigenReconSym(double **mat, const double **evecs, const double *evals, const int n);

#endif

