
/*********************************************************************
 *                
 * Filename:      superio.h
 * Description:   header file for the super I/O device
 * Author:        Thomas Hood <jdthood@mail.com>
 * Created:       19 July 1999 
 *
 * Please report bugs to the author ASAP.
 * 
 *     Copyright (c) 1999 J.D. Thomas Hood, All rights reserved
 *     
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 * 
 *     To receive a copy of the GNU General Public License, please write
 *     to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *     Boston, MA 02111-1307 USA
 *     
 ********************************************************************/

#if !defined(__SUPERIO_H__)
#define __SUPERIO_H__

/****** defines ******/

#define SUPERIO_FUNC_LEG_REGS_GET  ((word)0x100)
#define SUPERIO_FUNC_LEG_REGS_SET  ((word)0x101)
#define SUPERIO_FUNC_PNP_REGS_GET  ((word)0x200)
#define SUPERIO_FUNC_FDD_IRQ_GET   ((word)0x310)
#define SUPERIO_FUNC_FDD_BASE_GET  ((word)0x320)
#define SUPERIO_FUNC_PAR_ABLIFY    ((word)0x400)
#define SUPERIO_FUNC_PAR_IRQ_GET   ((word)0x413)
#define SUPERIO_FUNC_PAR_IRQ_SET   ((word)0x411)
#define SUPERIO_FUNC_PAR_BASE_GET  ((word)0x420)
#define SUPERIO_FUNC_PAR_BASE_SET  ((word)0x421)
#define SUPERIO_FUNC_PAR_MODE_GET  ((word)0x430)
#define SUPERIO_FUNC_PAR_MODE_SET  ((word)0x431)
#define SUPERIO_FUNC_SER_ABLIFY    ((word)0x500)
#define SUPERIO_FUNC_SER_IRQ_GET   ((word)0x510)
#define SUPERIO_FUNC_SER_IRQ_SET   ((word)0x511)
#define SUPERIO_FUNC_SER_BASE_GET  ((word)0x520)
#define SUPERIO_FUNC_SER_BASE_SET  ((word)0x521)

/****** typedefs ******/

/*** superio module input parameters ***/
typedef struct _superio_inparm {
	word	wFunc;
	word	wParm0;
	dword	dwParm1;
	dword	dwParm2;
} superio_inparm_t;

/*** superio module output parameters ***/
typedef struct _superio_outparm {
	word	wRc;
	word	wParm0;
	dword	dwParm1;
	dword	dwParm2;
} superio_outparm_t;

typedef union _superio_ioparm_t {
	superio_inparm_t in;
	superio_inparm_t out;
} superio_ioparm_t;

typedef enum _superio_par_mode {
	SUPERIO_PAR_MODE_COMPATIBLE=0,
	SUPERIO_PAR_MODE_EXTENDED,
	SUPERIO_PAR_MODE_EPP_1_7,
	SUPERIO_PAR_MODE_EPP_1_9,
	SUPERIO_PAR_MODE_ECP,
	SUPERIO_PAR_MODE_UNRECOGNIZED
} superio_par_mode_t;

/****** declarations ******/

int superio_do(
	unsigned long ulongIoctlArg,
	flag_t fCallerHasWritePerm
);


#endif
