#! /bin/sh
## /etc/init.d/thy -- init script for thy
## (Generic, used for Debian)

set -e

THY=/usr/sbin/thy
CONFFILE=/etc/default/thy
PIDFILE=/var/run/thy.pid
THY_OPTIONS=

test -x ${THY} || exit 0

[ -e ${CONFFILE} ] && . ${CONFFILE}

case $1 in
	start)
		echo -n "Starting httpd: thy"
		${THY} ${THY_OPTIONS}
		echo ".";;
	stop)
		echo -n "Stopping httpd: "
		if [ -e ${PIDFILE} ]; then
			PID=$(cat ${PIDFILE})
			if [ ! -z "${PID}" ]; then
				if kill -9 ${PID} >/dev/null 2>&1; then
					echo -n "thy"
				else
					echo -n "not running"
				fi
			else
				echo -n "not running"
			fi
		else
			echo -n "not running"
		fi
		rm -f ${PIDFILE}
		echo ".";;
	restart|force-reload)
		$0 stop
		sleep 2
		$0 start;;
	*)
		echo "Usage: /etc/init.d/thy {start|stop|restart|force-reload}"
		exit 1;;
esac

exit 0
