/* -*- mode: c; c-file-style: "gnu" -*-
 * cgi.h -- CGI support function prototypes
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file cgi.h
 * CGI support function protoypes.
 */

#ifndef _THY_CGI_H
#define _THY_CGI_H 1 /**< cgi.h multi-inclusion guard. */

#include "types.h"

int cgi_launch (const char *fn, session_t *session);
void cgi_setup (session_t *session);
void cgi_addenv (request_t *request, const char *name, const char *value);
int cgi_iscgi (const session_t *session, const char *fn);
void cgi_headers_setup (session_t *session);

#endif /* !_THY_CGI_H */
