/* -*- mode: c; c-file-style: "gnu" -*-
 * network.h -- Network related function prototypes
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file network.h
 * Network related function prototypes.
 */

#ifndef _THY_NETWORK_H
#define _THY_NETWORK_H 1 /**< network.h multi-inclusion guard. */

#include <sys/types.h>
#include "options.h"
#include "types.h"

int put_file (int infd, session_t *session, size_t size, off_t *offset);
int put_file_simple (int infd, session_t *session, size_t size,
		     off_t *offset);
int put_buffer (session_t *session, char *buf, size_t size,
		off_t *offset);
void push_buffer (session_t *session, char *buf, size_t size,
		  off_t offset);

int thy_recv (session_t *session, void *buf, size_t size);
int thy_send (session_t *session, void *buf, size_t size);

int thy_addr_get (const char *hostname, struct sockaddr_storage *addr);
int thy_sock_port_get (int fd);

int thy_socket_is_alive (int sock);

#if defined(THY_OPTION_TLS) || defined(THY_OPTION_ZLIB)
int thy_sendfile_simple (session_t *session, int s, off_t *offset,
			 size_t count);
#endif

#endif /* !_THY_NETWORK_H */
