/* -*- mode: c; c-file-style: "gnu" -*-
 * os.h -- OS-dependent wrapper prototypes.
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file os.h
 * OS-dependent wrapper prototypes.
 */

#ifndef _THY_OS_H
#define _THY_OS_H 1 /**< os.h multi-inclusion guard. */

/** Wrapper around OS-specific sendfile() implementations.
 * @param fd is the file descriptor to push data towards.
 * @param s is the input file descriptor.
 * @param offset is the offset to start sending from.
 * @param count is the number of bytes to push at most.
 *
 * @returns The number of bytes sent, or -1 on error.
 */
int thy_sendfile (int fd, int s, off_t *offset, size_t count);

/** Wrapper around OS-specific buffer sending routines.
 * Some OSes (notably Solaris) can use sendfile() to push a buffer
 * into the socket. This function uses any such function, or the
 * simple write() call, if there isn't one.
 *
 * @param fd is the FD to push data towards.
 * @param buffer is the buffer to send.
 * @param size is the size of the buffer.
 *
 * @returns The number of bytes sent, or -1 on error.
 */
int thy_sendbuffer (int fd, void *buffer, size_t size);

#endif /* !_THY_OS_H */
