/* -*- mode: c; c-file-style: "gnu" -*-
 * version.c -- Thy version information
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file version.c
 * Thy version information.
 */

#include "system.h"
#include "options.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/utsname.h>
#if THY_OPTION_ZLIB
#include <zlib.h>
#endif

#include "compat/compat.h"

#include "thy.h"

/** @internal Internal variable holding the server name.
 * This variable is used to hold the name of the server. Various
 * functions use thy_servername() to access it, either retrieving, or
 * setting the value.
 */
static char *servername = NULL;

/** Initialise the servername.
 * Initialises #servername, containing optional library names and
 * versions, operating system, etc.
 */
void
thy_servername_init (void)
{
#if defined (THY_OPTION_UNAME) || defined (THY_OPTION_TLS) || \
    defined(THY_OPTION_ZLIB)
  char *nserver;
#endif
#if THY_OPTION_UNAME
  struct utsname un;
#endif

#ifndef __LCLINT__
  servername = bhc_strdup (__THY__ "/" _THY_VERSION);
#endif

#if THY_OPTION_UNAME
  if (uname (&un) != -1)
    {
      asprintf (&nserver, "%s %s/%s (%s)", servername, un.sysname,
		un.release, un.machine);
      free (servername);
      servername = bhc_strdup (nserver);
      free (nserver);
    }
#endif

#if THY_OPTION_TLS
  asprintf (&nserver, "%s GnuTLS/%s", servername, LIBGNUTLS_VERSION);
  free (servername);
  servername = bhc_strdup (nserver);
  free (nserver);
#endif

#if THY_OPTION_ZLIB
  asprintf (&nserver, "%s zlib/%s", servername, ZLIB_VERSION);
  free (servername);
  servername = bhc_strdup (nserver);
  free (nserver);
#endif
}

/** Get or set the server name to report.
 * @param name is the new value, or NULL if we only want to retrieve
 * the information.
 * @return The server name to report.
 */
const char *
thy_servername (char *name)
{
  if (name)
    {
      free (servername);
      servername = name;
    }
  return servername;
}
