#! /usr/bin/perl -w
## NEWS2html.pl -- Convert a NEWS file to HTML
## (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
##
## This file is part of Thy.
##
## Thy is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; version 2 dated June, 1991.
##
## Thy is distributed in the hope that it will be useful, but WITHOUT
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
## or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
## License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

use strict;

my $seen_head = 0;
my $is_ul = 0;
my $p = "";

sub handle_newp ()
{
	if ($is_ul) {
		$p .= "</ul>\n";
		$is_ul = 0;
	} else {
		$p .= "</p>\n" if ($p);
	}

	$p =~ s/&/&amp;/g;
	$p =~ s/\t\"([^\n]+)/<blockquote>\"$1<br>/g;
	$p =~ s/\t (.*)/\t\&nbsp;$1<br>/g;
	$p =~ s/(\t&nbsp;)([^\n]+")/$1$2<\/blockquote>/g;
	$p =~ s/<(?!(li|\/?ul|\/?p|br|\/?blockquote))/&lt;/g;
	$p =~ s/(\"[^\"]+\")/<i>$1<\/i>/g;
	$p =~ s/(--\w+)/<i>$1<\/i>/g;
	$p =~ s/(\w+\(\))/<i>$1<\/i>/g;

	print "<p>\n$p" if ($p);
	$p = "";
}

print <<EOF
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>User visible changes in Thy</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
  .title { font-size: 14pt;
	   background: #eeeeee;
	   border: 1px #dddddd outset;
	   padding: 2px; }
  body { font-size: 10pt; font-family: verdana, courier; }
  small { font-size: 8pt; }
</style>
</head>
<body>
EOF
;

while (<STDIN>) {
	if (/^\* (\S+) ([\d\.]+) (\[([^\]]*)\])* ?-- (\d{4}-(\d{2}|\?\?)-(\d{2}|\?\?))/) {
		handle_newp();

		print "<br>\n" if ($seen_head);

		$seen_head = 1;
		print "<font class=\"title\"><b>$1 $2</b> <i>$3</i> " .
		      "<small>($5)</small></font><br>\n";
		next;
	}
	if (/^\*\*/) {
		if ($is_ul) {
			s/^\*\*/  <li>/;
		} else {
			s/^\*\*/<\/p>\n<ul>\n  <li>/;
			$is_ul = 1;
		}
	}
	if (/^\s*$/m) {
		handle_newp();
		next;
	}
	$p .= $_ if ($seen_head);
}

handle_newp ();

print <<EOF
</body>
</html>
EOF
;
