package tijmp.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import tijmp.ProfilerHandler;
import tijmp.ui.ShowSimpleFrame;
import tijmp.ui.ThreadInfoPanel;

/** A class that shows thread info.
 */
public class ThreadInfo extends AbstractAction {
    private static int windowId = 1;
    private ProfilerHandler ph;

    public ThreadInfo (ProfilerHandler ph) {
	super ("Thread info");
	this.ph = ph;
    }

    public void actionPerformed (ActionEvent e) {
	ThreadInfoPanel tif = new ThreadInfoPanel (ph);
	ThreadDumper td = new ThreadDumper (tif);
	new ShowSimpleFrame ().showFrame ("Thread info " + + windowId++, 
					  tif, td);
    }    
}
