/******************************************************************************
*   TinTin++                                                                  *
*   Copyright (C) 2004 (See CREDITS file)                                     *
*                                                                             *
*   This program is protected under the GNU GPL (See COPYING)                 *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*******************************************************************************/

/******************************************************************************
*   file: highlight.c - funtions related to the highlight command             *
*           (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t ++ 2.00              *
*                         coded by Bill Reiss 1993                            *
*                   recoded by Igor van den Hoven 2004                        *
******************************************************************************/


#include "tintin.h"


/*
	#substitute is now able to do full color substitutions, but I'll leave
	this for old times sake. Notice it now follows the standard tintin syntax
	because #read is not as flexible as it used to be - Scandum
*/

DO_COMMAND(do_highlight)
{
	char left[BUFFER_SIZE], right[BUFFER_SIZE], pr[BUFFER_SIZE], temp[BUFFER_SIZE];
	struct listroot *root;

	root = ses->list[LIST_HIGHLIGHT];

	arg = get_arg_in_braces(arg, left,  FALSE);
	arg = get_arg_in_braces(arg, right, TRUE);
	arg = get_arg_in_braces(arg, pr,    TRUE);

	if (*pr == 0)
	{
		sprintf(pr, "%s", "5");
	}

	if (*left == 0)
	{
		tintin_header(ses, " HIGHLIGHTS ");
		show_list(ses, root, PRIORITY);
	}
	else if (*left && *right == 0)
	{
		if (show_node_with_wild(ses, root, left, PRIORITY) == FALSE)
		{
			if (show_message(root))
			{
				tintin_puts2("#THAT HIGHLIGHT IS NOT DEFINED.", ses);
			}
		}
	}
	else
	{
		if (get_highlight_codes(right, temp) == FALSE)
		{
			tintin_printf2(ses, "#HIGHLIGHT: VALID COLORS ARE:\n\r");
			tintin_printf2(ses, "reset, light, faint, underscore, blink, reverse, dim, black, red, green, yellow, blue, magenta, cyan, white, b black, b red, b green, b yellow, b blue, b magenta, b cyan, b white");
		}
		else
		{
			updatenode_list(root, left, right, pr, PRIORITY);

			if (show_message(root))
			{
				tintin_printf2(ses, "#OK. {%s} IS NOW HIGHLIGHTED {%s} @ {%s}", left, right, pr);
			}
		}
	}
	return ses;
}


DO_COMMAND(do_unhighlight)
{
	char left[BUFFER_SIZE];
	struct listroot *root;
	struct listnode *node;
	int flag = FALSE;

	root = ses->list[LIST_HIGHLIGHT];

	arg = get_arg_in_braces(arg, left, TRUE);

	while ((node = search_node_with_wild(root, left)))
	{
		if (show_message(root))
		{
			tintin_printf2(ses, "#OK. {%s} IS NO LONGER A HIGHLIGHT.", node->left);
		}
		deletenode_list(root, node);
		flag = TRUE;
	}

	if (flag == FALSE && show_message(root))
	{
		tintin_puts2("#THAT HIGHLIGHT IS NOT DEFINED.", ses);
	}
	return ses;
}


void check_all_highlights(char *original, char *line, struct session *ses)
{
	struct listnode *node;
	char *pt1, *pt2, *pt3;
	char buf1[BUFFER_SIZE], buf2[BUFFER_SIZE], buf3[BUFFER_SIZE], temp[BUFFER_SIZE];

	for (node = ses->list[LIST_HIGHLIGHT]->f_node ; node ; node = node->next)
	{
		if (check_one_action(original, node->left, ses))
		{
			substitute(ses, node->left, buf1, SUB_VAR|SUB_FUN|SUB_ARG|SUB_ANC);

			pt1 = original;
			pt2 = strstr(original, buf1) ? strstr(original, buf1) : buf1;
			*pt2 = 0;
			pt3 = pt2 + strlen(buf1);

			get_highlight_codes(node->right, buf2);

			strip_non_vt102_codes(original, temp);
			strip_vt102_codes_non_graph(temp, buf3);

			sprintf(temp, "%s%s%s\033[0m%s%s", original, buf2, buf1, buf3, pt3);

			strcpy(original, temp);

			break;
		}
	}
}

bool get_highlight_codes(const char *string, char *result)
{
	int cnt;

	sprintf(result, "\033[0");

	while (*string)
	{
		if (isalpha(*string))
		{
			for (cnt = 0 ; *color_table[cnt].name ; cnt++)
			{
				if (is_abbrev(color_table[cnt].name, string))
				{
					strcat(result, ";");
					strcat(result, color_table[cnt].number);
					break;
				}
			}

			if (*color_table[cnt].name == 0)
			{
				return FALSE;
			}

			string += strlen(color_table[cnt].name);
		}
		else if (isdigit(*string))
		{
			strcat(result, ";");

			while (isdigit(*string))
			{
				sprintf(&result[strlen(result)], "%c", *string++);
			}
		}

		switch (*string)
		{
			case ' ':
			case ',':
				string++;
				break;

			case 0:
				break;

			default:
				return FALSE;
		}
	}
	strcat(result, "m");

	return TRUE;
}
