# $Id: autoaway.tcl,v 1.10 2004/04/27 20:35:54 aleksey Exp $

namespace eval autoaway {
    variable options
    variable savestatus ""
    variable savetext   ""
    variable savepriority 0
}


proc autoaway::load {} {
    global tcl_platform
    global idle_command

    switch -- $tcl_platform(platform) {
        macintosh {
	    set idle_command [namespace current]::AquaIdleTime
	}

	unix {
	    if {$::aquaP} {
	        set idle_command [namespace current]::AquaIdleTime
	    } elseif {[catch { package require tkXwin }]} {
		return
	    } else {
	        set idle_command tkXwin::idletime
	    }
	}
	windows {
	    if {[catch { package require tclWinidle }]} {
		return
	    }
	    set idle_command tclWinidle::idletime
	}
	default {
	    return
	}
    }

    custom::defgroup AutoAway \
	[::msgcat::mc "Options for module that automatically marks\
you as away after idle threshold."] \
	-group Tkabber

    custom::defvar options(awaytime) [expr  5*60*1000] \
	[::msgcat::mc "Idle threshold in milliseconds after that\
Tkabber marks you as away."] \
	-group AutoAway -type integer

    custom::defvar options(xatime) [expr 15*60*1000] \
	[::msgcat::mc "Idle threshold in milliseconds after that\
Tkabber marks you as extended away."] \
	-group AutoAway -type integer

    custom::defvar options(status) \
	[::msgcat::mc "Automatically away due to idle"] \
	[::msgcat::mc "Text status, which is set when\
Tkabber is moving in away state."] \
	-group AutoAway -type string

    custom::defvar options(drop_priority) 1 \
	[::msgcat::mc "Tkabber will set priority to 0\
when moving in extended away state."] \
	-group AutoAway -type boolean

    hook::add connected_hook    [namespace current]::after_idle
    hook::add disconnected_hook [namespace current]::after_idle_cancel
}


proc autoaway::after_idle {args} {
    after cancel [namespace current]::after_idle
    after_idle_aux
    if {$::aquaP} {
        set msec 1000
    } else {
        set msec 100
    }
    after $msec [namespace current]::after_idle
}

proc autoaway::after_idle_cancel {args} {
    if {[jlib::connections] == {}} {
	after cancel [namespace current]::after_idle
    }
}

proc autoaway::after_idle_aux {} {
    variable options
    variable savestatus
    variable savetext
    variable savepriority
    global idle_command
    global userstatus textstatus
    global userpriority

    if {($options(awaytime) <= 0) && ($options(xatime) <= 0)} {
        return
    }

    if {[set idletime [$idle_command]] < $options(awaytime)} {
        if {![cequal $savestatus ""]} {
	    if {$options(drop_priority) && ($userpriority >= 0)} {
		set userpriority $savepriority
		set savepriority 0
	    }
	    set textstatus $savetext
	    set savetext ""
            set userstatus $savestatus
            set savestatus ""
            set_status [::msgcat::mc "Returning from auto-away"]
        }

        return
    }

    switch -- $userstatus {
        available
            -
        chat {
            set savestatus $userstatus
	    set savetext $textstatus
            set textstatus $options(status)
            if {$idletime >= $options(xatime)} {
		if {$options(drop_priority) && ($userpriority >= 0)} {
		    set savepriority $userpriority
		    set userpriority 0
		}
                set userstatus xa
                set_status [::msgcat::mc "Moving to extended away"]
            } else {
                set userstatus away
                set_status [::msgcat::mc "Starting auto-away"]
            }
	    update
	    set ::sound::mute 1
            return
        }

        away {
            if {(![cequal $savestatus ""]) \
		    && ($idletime >= $options(xatime))} {
		set textstatus $options(status)
		if {$options(drop_priority) && ($userpriority >= 0)} {
		    set savepriority $userpriority
		    set userpriority 0
		}
                set userstatus xa
                set_status [::msgcat::mc "Moving to extended away"]
		update
		set ::sound::mute 1
                return
            }
        }

        default {
        }
    }

    if {![cequal $savestatus ""]} {
        set_status [format [::msgcat::mc "Idle for %s"] [format_time [expr {$idletime/1000}]]]
    }
}

proc autoaway::AquaIdleTime {} {
    catch { set line [read [set fd [open {|ioreg -x -c IOHIDSystem}]]] }
    close $fd

    expr {"0x[lindex [regexp -inline {"HIDIdleTime" = (?:0x|<)([[:xdigit:]]+)} \
                 $line] 1]"/1000000}
}


autoaway::load

