# $Id: logger.tcl,v 1.29 2006/05/11 22:30:13 aleksey Exp $

option add *highlightSearchBackground        PaleGreen1    widgetDefaul

namespace eval ::logger {
    custom::defgroup Logging [::msgcat::mc "Logging options."] -group Chat

    custom::defvar options(logdir) [file join ~ .tkabber logs] \
	    [::msgcat::mc "Directory to store logs."] \
	-type string -group Logging

    custom::defvar options(log_chat) 1 \
	    [::msgcat::mc "Store private chats logs."] \
	-type boolean -group Logging

    custom::defvar options(log_groupchat) 1 \
	    [::msgcat::mc "Store group chats logs."] \
	-type boolean -group Logging

    custom::defvar options(search_case) 0 \
	    [::msgcat::mc "Match case while searching in log window."] \
	-type boolean -group Logging

    custom::defvar options(search_regexp) 0 \
	    [::msgcat::mc "Use regexp match while searching in log window\
(otherwise substring is searched)."] \
	-type boolean -group Logging

    array set search_mode {}

    if {![file exists $options(logdir)]} {
	file mkdir $options(logdir)
    }
}

proc ::logger::add_menu_item {state cathegory m connid jid} {
    switch -- $cathegory {
	roster {
	    set jid [roster::find_jid $connid $jid]
	}
	chat {
	    set nas [node_and_server_from_jid $jid]
	    if {![chat::is_groupchat [chat::chatid $connid $nas]]} {
		set jid $nas
	    }
	}
    }
    $m add command -label [::msgcat::mc "Show history"] \
	   -state $state \
           -command [list logger::show_log $jid -connection $connid]
}

hook::add chat_create_user_menu_hook [list ::logger::add_menu_item normal chat] 65
hook::add chat_create_conference_menu_hook [list ::logger::add_menu_item normal group] 65
hook::add roster_create_groupchat_user_menu_hook [list ::logger::add_menu_item normal grouproster] 65
hook::add roster_conference_popup_menu_hook [list ::logger::add_menu_item normal roster] 65
hook::add roster_service_popup_menu_hook [list ::logger::add_menu_item disabled roster] 65
hook::add roster_jid_popup_menu_hook [list ::logger::add_menu_item normal roster] 65
hook::add message_dialog_menu_hook [list ::logger::add_menu_item disabled message] 65
hook::add search_popup_menu_hook [list ::logger::add_menu_item disabled search] 65

proc ::logger::log_file {jid} {
    variable options

    regsub -all {[:\\@/|*+?]} $jid _ filename 
    return [file join ${options(logdir)} $filename]
}

proc ::logger::log_message {chatid from type body x} {
    variable options

    if {$type == "chat" && !$options(log_chat)} return
    if {$type == "groupchat" && !$options(log_groupchat)} return

    set connid [chat::get_connid $chatid]
    set jid [chat::get_jid $chatid]
    set nas [node_and_server_from_jid $jid]
    if {$type == "chat" && ![chat::is_groupchat [chat::chatid $connid $nas]]} {
	set jid $nas
    }

    set logfile [log_file $jid]
    set nick [chat::get_nick $connid $from $type]

    set seconds [clock seconds]
    foreach xelem $x {
	jlib::wrapper:splitxml $xelem tag vars isempty chdata children
	
	if {[cequal [jlib::wrapper:getattr $vars xmlns] jabber:x:delay]} {
	    set seconds [clock scan [jlib::wrapper:getattr $vars stamp] -gmt 1]
	}
    }
    set ts [clock format $seconds -format "%Y%m%dT%H%M%S"]

    set fd [open $logfile a]
    fconfigure $fd -encoding utf-8
    puts $fd [list [list timestamp $ts nick ${nick} body $body]]
    close $fd
}

hook::add draw_message_hook ::logger::log_message 15


proc ::logger::winid {name} {
    set allowed_name [jid_to_tag $name]
    return .log_$allowed_name
}


proc ::logger::do_search {txt entr back} {
    variable options
    variable search_mode
	
    set searchpattern [$entr get]
    if ![string length $searchpattern] {return 0}

    if {$back} {
	set search_from sel_start
	set search_to   0.0
	set search_dir  -backwards
    } else {
	set search_from "sel_start +1char"
	set search_to	end
	set search_dir  -forwards
    }

    if {$options(search_case)} {
	set case ""
    } else {
	set case -nocase
    }

    if {$options(search_regexp)} {
	set exact -regexp
    } else {
	set exact -exact
    }

    if {[catch { eval [list $txt] search $search_dir $case $exact -- \
			   [list $searchpattern $search_from] } index]} {
	$entr configure -fg [option get $entr errorForeground Entry]
	set index {}
    } else {
	$entr configure -fg [option get $entr foreground Entry]
    }

    if {![string length $index]} {
 	return 0
    } else {
	$txt tag remove search_highlight 0.0 end
	if {$exact == "-regexp"} {
	    set line [$txt get $index "$index lineend"]
	    eval regexp $case -- [list $searchpattern $line] match
	    $txt tag add search_highlight $index "$index + [string length $match] chars"
	    if {[string length $match] == 0} {
		set nohighlight 1
	    } else {
		set nohighlight 0
	    }
	} else {
	    $txt tag add search_highlight $index "$index + [string length $searchpattern] chars"
	    if {[string length $searchpattern] == 0} {
		set nohighlight 1
	    } else {
		set nohighlight 0
	    }
	}
	if {!$nohighlight} {
	    $txt tag configure search_highlight -background \
		[option get $txt highlightSearchBackground Text]
	    $txt mark set sel_start search_highlight.first
	    $txt mark set sel_end search_highlight.last
	    $txt see $index
	}
    }
}

proc ::logger::show_log {jid args} {
    global font
    global tcl_platform
    global defaultnick

    variable search_mode

    foreach {key val} $args {
	switch -- $key {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	set connid [lindex [jlib::connections] 0]
    }

    set nas [node_and_server_from_jid $jid]
    if {![chat::is_groupchat [chat::chatid $connid $nas]]} {
	set jid $nas
    }

    set logfile [log_file $jid]
    if {[file exists $logfile]} {
	set lw [winid $jid]
	debugmsg plugins "LOGGER: $lw"
	if {[winfo exists $lw]} {
	    focus -force $lw
	    return
	}

	set fd [open $logfile r]
	fconfigure $fd -encoding utf-8
	set hist [read $fd]
	close $fd

	set mynick [get_group_nick $jid ""]


	toplevel $lw -relief $::tk_relief -borderwidth $::tk_borderwidth -class Chat
	wm group $lw .
	wm withdraw $lw
	set title [format [::msgcat::mc "History for %s"] $jid]
	wm title $lw $title
	wm iconname $lw $title

	set lf [ScrolledWindow $lw.sw]
	set l [text $lf.log -font $font -wrap word -takefocus 0]

	set cf [frame $lw.controls]

	#set slabel [label $cf.slabel -text [::msgcat::mc "Search:"]]
	#pack $slabel -side left
	
	set sentry [entry $cf.search]
	pack $sentry -padx 1m -side left

	set sbox [ButtonBox $cf.sbox -spacing 0]
	$sbox add -text [::msgcat::mc "Search up"] \
	    -command [list [namespace current]::do_search $l $sentry 1]
	$sbox add -text [::msgcat::mc "Search down"] \
	    -command [list [namespace current]::do_search $l $sentry 0]
	pack $sbox -side left

	set ebox [ButtonBox $cf.ebox -homogeneous 0 -spacing 0]
	$ebox add -text [::msgcat::mc "Export to XHTML"] \
	    -command [list [namespace current]::export $l $lw.mf.mcombo $logfile $mynick]
	$ebox add -text [::msgcat::mc "Close"] -command [list destroy $lw]
	bind $lw <Escape> "ButtonBox::invoke $ebox 1"
	pack $ebox -side right

	pack $cf -side bottom -anchor w -fill x -expand no -padx 2m -pady 2m

	set mf [frame $lw.mf]
	pack $mf -side top -fill x -expand no -padx 2m -pady 2m
	set mlabel [label $mf.mlabel -text [::msgcat::mc "Select month:"]]
	pack $mlabel -side left

	pack $lf -padx 1m -pady 1m -fill both -expand yes

	$l mark set sel_start end
	$l mark set sel_end 0.0

	$lf setwidget $l
	focus $sentry

	bind $lw <Key-Return> [list $sbox invoke 0]
	bind $lw <Shift-Key-Return> [list $sbox invoke 1]
    
	regsub -all %W [bind Text <Prior>] $l prior_binding
	regsub -all %W [bind Text <Next>] $l next_binding
	bind $lw <Prior> $prior_binding
	bind $lw <Next> $next_binding

	$l tag configure they -foreground [option get $lw theyforeground Chat]
	$l tag configure me -foreground [option get $lw meforeground Chat]
	$l tag configure server_lab \
	    -foreground [option get $lw serverlabelforeground Chat]
	$l tag configure server \
	    -foreground [option get $lw serverforeground Chat]


	if {![lempty $hist]} {
	    set vars [lindex $hist 0]
	    array set tmp $vars
	    if {[info exists tmp(timestamp)]} {
		set seconds [clock scan $tmp(timestamp) -gmt 0]
		set ym [clock format $seconds -format %Y%m]
		set curym [clock format [clock seconds] -format %Y%m]
		if {$ym < $curym} {
		    set hist [filter_old_history $logfile $hist]
		}
	    }
	}

	set subdirs [concat [::msgcat::mc "Current"] \
			    [lsort -decreasing [get_subdirs $logfile]] \
			    [::msgcat::mc "All"]]

	set mcombo [ComboBox $mf.mcombo \
			-editable no \
			-exportselection no \
			-values $subdirs \
			-text [::msgcat::mc "Current"] \
			-modifycmd [list [namespace current]::change_month \
					$mf.mcombo $logfile $l $mynick]]
	pack $mcombo -side left

	draw_messages $l $hist $mynick

	$lf.log see end
	$lf.log configure -state disabled

	wm deiconify $lw
	
    } else {
	
    }
}

proc ::logger::get_subdirs {logfile} {
    set subdirs {}
    foreach subdir [glob -nocomplain -directory [file dirname $logfile] */] {
	if {[file exists [file join $subdir [file tail $logfile]]]} {
	    lappend subdirs [file tail $subdir]
	}
    }
    return $subdirs
}

proc ::logger::draw_messages {l hist mynick} {
    $l configure -state normal
    $l delete 0.0 end

    add_messages $l $hist $mynick
}

proc ::logger::add_messages {l hist mynick} {
    $l configure -state normal

    foreach vars $hist {
	array unset tmp
	array set tmp $vars
	if {[info exists tmp(timestamp)]} {
	    set seconds [clock scan $tmp(timestamp) -gmt 0]
	    $l insert end [clock format $seconds -format {[%Y-%m-%d %X]}]
	}
	if {[info exists tmp(nick)] && $tmp(nick) != ""} {
	    if {[string equal $tmp(nick) $mynick]} {
		set tag me
	    } else {
		set tag they
	    }
	    if {[info exists tmp(body)] && [regsub {^/me } $tmp(body) {} body]} {
		$l insert end "*$tmp(nick) $body" $tag
		unset tmp(body)
	    } else {
		$l insert end "<$tmp(nick)>" $tag
	    }
	    set servertag ""
	} else {
	    $l insert end "---" server_lab
	    set servertag server
	}
	if {[info exists tmp(body)]} {
	    $l insert end " $tmp(body)" $servertag
	}
	if {![$l compare "end -1 chars linestart" == "end -1 chars"]} {
	    $l insert end "\n"
	}
    }
    $l see end
    $l configure -state disabled
}


proc ::logger::change_month {mcombo logfile l mynick} {
    set month [$mcombo cget -text]

    if {$month == [::msgcat::mc "All"]} {
	draw_messages $l {} $mynick
	foreach m [lsort -increasing [get_subdirs $logfile]] {
	    add_messages $l [read_hist_from_file $logfile $m] $mynick
	}
	add_messages $l [read_hist_from_file $logfile [::msgcat::mc "Current"]] $mynick
    } else {
	draw_messages $l [read_hist_from_file $logfile $month] $mynick
    }
}

proc ::logger::read_hist_from_file {logfile month} {
    if {$month == [::msgcat::mc "Current"]} {
	set filename $logfile
    } else {
	set filename [file join \
			  [file dirname $logfile] \
			  $month \
			  [file tail $logfile]]
	if {![file exists $filename]} {
	    unset filename
	}
    }

    if {[info exists filename]} {
	set fd [open $filename r]
	fconfigure $fd -encoding utf-8
	set hist [read $fd]
	close $fd
    } else {
	set hist {}
    }

    return $hist
}

proc ::logger::filter_old_history {logfile hist} {
    set newhist {}
    set curym [clock format [clock seconds] -format %Y-%m]
    foreach vars $hist {
	array unset tmp
	array set tmp $vars
	if {[info exists tmp(timestamp)]} {
	    set seconds [clock scan $tmp(timestamp) -gmt 0]
	    set ym [clock format $seconds -format %Y-%m]
	    if {$ym < $curym} {
		lappend oldhist($ym) $vars
	    } else {
		lappend newhist $vars
	    }
	}
    }

    foreach ym [array names oldhist] {
	set dir [file join [file dirname $logfile] $ym]
	set oldlog [file join $dir [file tail $logfile]]
	file mkdir $dir
	
	set fd [open $oldlog a]
	fconfigure $fd -encoding utf-8
	foreach vars $oldhist($ym) {
	    puts $fd [list $vars]
	}
	close $fd
    }

    set fd [open $logfile w]
    fconfigure $fd -encoding utf-8
    foreach vars $newhist {
	puts $fd [list $vars]
    }
    close $fd

    return $newhist
}


proc ::logger::export {lw mcombo logfile mynick} {
    set month [$mcombo cget -text]

    if {$month == [::msgcat::mc "All"]} {
	set hist {}
	foreach m [lsort -increasing [get_subdirs $logfile]] {
	    set hist [concat $hist [read_hist_from_file $logfile $m]]
	}
	set hist [concat $hist [read_hist_from_file $logfile [::msgcat::mc "Current"]]]
    } else {
	set hist [read_hist_from_file $logfile $month]
    }

    set filename [tk_getSaveFile -defaultextension .html]
    if {$filename == ""} return
    set fd [open $filename w]
    fconfigure $fd -encoding utf-8

    puts $fd {<?xml version="1.0" encoding="UTF-8"?>}
    puts $fd {<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "DTD/xhtml1-strict.dtd">}
    puts $fd {<html xmlns="http://www.w3.org/1999/xhtml">}
    set head [jlib::wrapper:createtag head \
		  -subtags [list [jlib::wrapper:createtag link \
				      -vars {
					  rel stylesheet
					  type text/css
					  href tkabber-logs.css
				      }]]]
    puts $fd [jlib::wrapper:createxml $head]


    foreach vars $hist {
	array unset tmp
	array set tmp $vars
	set subtags {}
	if {[info exists tmp(timestamp)]} {
	    set seconds [clock scan $tmp(timestamp) -gmt 0]
	    set timestamp [clock format $seconds -format {[%Y-%m-%d %X]}]
	    lappend subtags [jlib::wrapper:createtag span \
				 -vars {class timestamp} \
				 -chdata $timestamp]
	}
	if {[info exists tmp(nick)] && $tmp(nick) != ""} {
	    if {$tmp(nick) == $mynick} {
	        set tag me
	    } else {
	        set tag they
	    }
	    if {[info exists tmp(body)] && [regsub {^/me } $tmp(body) {} body]} {
		set nick "*$tmp(nick) $body"
		unset tmp(body)
	    } else {
		set nick "<$tmp(nick)> "
	    }
	    lappend subtags [jlib::wrapper:createtag span \
				 -vars [list class $tag] \
				 -chdata $nick]

	    if {[info exists tmp(body)]} {
		lappend subtags [jlib::wrapper:createtag span \
				     -vars [list class body] \
				     -chdata "$tmp(body)"]
	    }
	} else {
	    if {[info exists tmp(body)]} {
		lappend subtags [jlib::wrapper:createtag span \
				     -vars [list class server] \
				     -chdata "--- $tmp(body)"]
	    }
	}
	#if {![$l compare "end -1 chars linestart" == "end -1 chars"]} {
	#    puts "\n"
	#}
	set msg [jlib::wrapper:createtag div \
		     -vars [list class message] \
		     -subtags $subtags]

	puts $fd [jlib::wrapper:createxml $msg]
    }
    
    puts $fd {</html>}
    close $fd

    write_css $lw [file join [file dirname $filename] tkabber-logs.css]
}

proc ::logger::write_css {lw filename} {
    set fd [open $filename w]

    puts $fd "
html body {
    background-color: white;
    color: black;
}

.me {
    color: blue;
}

.they {
    color: red;
}

.server {
    color: green;
}
"

    close $fd
}


