# $Id: send_message.tcl,v 1.6 2006/01/28 20:45:07 aleksey Exp $

proc send_message {chatid user body type} {
    global chat_msg_id

    if {![info exists chat_msg_id]} {
	set chat_msg_id 1
    } else {
	incr chat_msg_id
    }
    set connid [chat::get_connid $chatid]
    set jid [chat::get_jid $chatid]
    set chatw [chat::chat_win $chatid]

    if {[hook::is_flag chat_send_message_hook send]} {
	set command [list message::send_msg $jid \
			 -id $chat_msg_id \
			 -connection $connid \
			 -type $type \
			 -body $body]
	if {[info exists ::chat::chats(thread,$chatid)]} {
	    lappend command -thread $::chat::chats(thread,$chatid)
	}
	set xlist [hook::foldl chat_send_message_xlist_hook \
			       {} $chatid $user $body $type]
	if {![lempty $xlist]} {
	    lappend command -xlist $xlist
	}
	lassign [eval $command] status x
	if {$status == "error"} {
	    return stop
	}

	set signP 0
	set encryptP 0
	foreach xe $x {
	    jlib::wrapper:splitxml $xe tag vars isempty chdata children

	    switch -- [jlib::wrapper:getattr $vars xmlns] \
		$::NS(signed) {
		    set signP 1
		} \
		$::NS(encrypted) {
		    set encryptP 1
		}
	}

	if {![cequal $type groupchat]} {
	    if {$encryptP} {
		$chatw image create start_message -image gpg/encrypted
	    }
	    if {$signP} {
		$chatw image create start_message -image gpg/signed
	    }
	}
    }
    hook::unset_flag chat_send_message_hook send
}

hook::add chat_send_message_hook [namespace current]::send_message 90

