/*
 * dviGet.c --
 *
 *      This file implements functions that access various quantities
 *      within a DVI file.
 *
 * Copyright  1999 Anselm Lingnau <lingnau@tm.informatik.uni-frankfurt.de>
 * See file COPYING for conditions on use and distribution.
 */

#include "dviInt.h"

#ifndef lint
static char rcsid[] VAR_UNUSED = "$Id: dviGet.c,v 1.1.1.1 1999/06/10 12:36:50 lingnau Exp $";
#endif /* lint */


U8
DviGetU8(p)
    U8 *p;
{
    return *p;
}

U16
DviGetU16(p)
    U8 *p;
{
    return (p[0]<<8) | p[1];
}

U32
DviGetU24(p)
    U8 *p;
{
    return (p[0]<<16) | (p[1]<<8) | p[2];
}

U32
DviGetU32(p)
    U8 *p;
{
    return (p[0]<<24) | (p[1]<<16) | (p[2]<<8) | p[3];
}

S8  DviGetS8(U8 *p) { return (S8)*p; }
S16 DviGetS16(U8 *p) { return (S16)DviGetU16(p); }
S32 DviGetS24(U8 *p) { return ((S8)p[0]<<16) | (p[1]<<8) | p[2]; }
S32 DviGetS32(U8 *p) { return (S32)DviGetU32(p); }

