/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
//
// SystemBus.c -- definition of the  SystemBus  class
//

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: sys_bus.cpp 1.2 Sat, 13 Sep 1997 12:04:11 -0600 maccabe $";

#include <stdio.h>

#include "Assert.h"
#include "sizedefs.h"
#include "Config.h"

#include "sys_bus.h"
#include "st_dev.h"


//
// public Constructors / Destructors
//
SystemBus::SystemBus() : memoryException(0) {
    unsigned i;
    for( i = 1 ; i <= max_interrupt ; i++ ) {
	uplevel[i] = 0;
    }

    // calculate number of last table entry
    //
    lastDevice = 1 << (Config::ADDR_BITS - Config::ISEM_PAGE_BITS);

    // allocate appropriate size table
    //
    device = new StorageDevice*[ lastDevice + 1 ];

    // initialize device table to known state
    //
    for (i = 0; i <= lastDevice; i++) {
	device[i] = 0;
    }
}


//
// public Member functions
//
void SystemBus::install(StorageDevice* dev) {
    UInt32 firstPage = dev->lowAddress() >> Config::ISEM_PAGE_BITS;
    UInt32 lastPage =  dev->highAddress() >> Config::ISEM_PAGE_BITS;
    for (unsigned p = firstPage; p <= lastPage; p++) {
	Assert (device[p] == 0, "attempting to install second device");
	device[p] = dev;
    }
}


UInt32 SystemBus::read(UInt32 addr) {
    UInt32 page = addr >> Config::ISEM_PAGE_BITS;

    if ((page > lastDevice) || (device[page] == 0)) {

	// This should actually be data_access_MMU_miss, but as of
	//   now, we don't have any mechanism to do that

	bp_memory_exception(1);
	return 0;
    }

    return device[page]->read(addr);
}


void SystemBus::write(UInt32 addr, int byteMask, UInt32 value) {
    UInt32 page = addr >> Config::ISEM_PAGE_BITS;

    if ((page > lastDevice) || (device[page] == 0)) {

	// This should actually be data_access_MMU_miss, but as of
	//   now, we don't have any mechanism to do that

        bp_memory_exception(1);
	return;
    }
    device[page]->write(addr, byteMask, value);
}


//
// public Methods for read only bus signals
//
int SystemBus::bp_FPU_present() {
    return 1;
}

int SystemBus::bp_CP_present() {
    return 0;
}

int SystemBus::bp_I_cache_present() {
    return 0;
}

int SystemBus::bp_CP_exception() {
    return 0;
}

int SystemBus::bp_CP_cc() {
    return 0;
}

void SystemBus::pb_retain_bus(int) {
   Assert(0, "SystemBus::pb_retain_bus NOT SUPPORTED");
}


// read/write bus signals
//
int SystemBus::bp_IRL() {
    for( int i = max_interrupt ; i > 0 ; i-- ) {
	if( uplevel[i] > 0 ) return i;
    }
    return 0;
}

void SystemBus::bp_IRL_raise(int level) {
    Assert(level > 0,  "interrupt level out of range");
    Assert(level <= 15, "interrupt level out of range");

    uplevel[level] = 1;
}

void SystemBus::bp_IRL_lower(int level) {
    Assert(level > 0,  "interrupt level out of range");
    Assert(level <= 15, "interrupt level out of range");

    uplevel[level] = 0;
}

int SystemBus::bp_memory_exception() {
    return memoryException;
}

void SystemBus::bp_memory_exception(int err) {
    memoryException = err;
}
