/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// $Id: sys_bus.h 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $
//

//
// SystemBus.h -- declaration of the  SystemBus  class
//

#ifndef _SystemBus_h
#define _SystemBus_h

class StorageDevice;

class SystemBus {
public:
    // public Constructors / Destructors
    //
    SystemBus();

    // public Member functions
    //
    void	install(StorageDevice*);

    UInt32	read(UInt32);
    void	write(UInt32, int, UInt32);

    // read only bus signals
    //
    int		bp_FPU_present();
    int		bp_CP_present();
    int		bp_I_cache_present();
    int		bp_CP_exception();
    int		bp_CP_cc();

    // write only bus signals
    //
    void	pb_retain_bus(int);

    // read/write bus signals
    //
    int		bp_IRL();
    void	bp_IRL_raise(int);
    void	bp_IRL_lower(int);

    int		bp_memory_exception();
    void	bp_memory_exception(int);

private:
    enum { max_interrupt = 16 };
    SystemBus(const SystemBus&);	 // Declare away
    void operator = (const SystemBus&);	 // Decalre away

    StorageDevice**	device;
    UInt32		lastDevice;

    int uplevel[max_interrupt+1];
    int		memoryException;
};

#endif /* _SystemBus_h */
