/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: store.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

//-----------------------------------------------------------------------
// Store Instructions - see p165 of SPARC Architecture Manual, Version 8
//-----------------------------------------------------------------------

#include "sizedefs.h"
#include "globals.h"
#include "Instruct.h"
#include "MMU.h"
#include "sys_bus.h"
#include "RegBlock.h"
#include "IU.h"
#include "FPU.h"


void IntegerUnit::store(const Instruction& inst) {

    switch (inst.op3()) {
    case Instruction::STDA:
    case Instruction::STA:
    case Instruction::STHA:
    case Instruction::STBA:
	if (IU_S == 0) {
	    trap = 1;
	    trapFlag[privileged_instruction] = 1;
	}
	else if (inst.i() == 1) {
	    trap = 1;
	    trapFlag[illegal_instruction] = 1;
	}
	break;

    case Instruction::STDFQ:
    case Instruction::STDCQ:
	if (IU_S == 0) {
	    trap = 1;
	    trapFlag[privileged_instruction] = 1;
	}
	break;

      // Sun Jan 14 02:22:19 2001 Ackley: This was:
      //     default:
      //       Assert(1, "Bad Store");
      //  which is a no-op, since asserting 1 never fails.
      //  I changed it to:
      //     default:
      //       Assert(0, "Bad Store");
      //  thinking that's what it must want to be.  
      //  But in fact this switch does not cover 
      //  all the possible store instructions --
      //  e.g., Instruction::ST does not appear.
      //  So for now I'm leaving this default case
      //  as a fall-through, which reproduces the
      //  Assert(1,..) behavior..

    default:
      //Assert(0, "Bad Store");
      break;
    }
    // next


    UInt32 address = 0, addr_space = 0;

    if (trap == 0) {
	switch (inst.op3()) {
	case Instruction::STD:
	case Instruction::ST:
	case Instruction::STH:
	case Instruction::STB:
	case Instruction::STF:
	case Instruction::STDF:
	case Instruction::STFSR:
	case Instruction::STDFQ:
	    address = reg[inst.rs1()] +
		      ((inst.i() == 0) ? reg[inst.rs2()] : inst.simm13());
	    addr_space = (IU_S == 0) ? USER_DATA : SUPERVISOR_DATA;
	    break;

	case Instruction::STDA:
	case Instruction::STA:
	case Instruction::STHA:
	case Instruction::STBA:
	    address = reg[inst.rs1()] + reg[inst.rs2()];
	    addr_space = inst.asi();
	    break;
	default:
	    Assert(0, "Bad Store: PLEASE EMAIL isem@cs.unm.edu with this error!");
	}

	switch (inst.op3()) {
	case Instruction::STF:
	case Instruction::STDF:
	case Instruction::STFSR:
	case Instruction::STDFQ:
	    if ( sbus.bp_FPU_present() == 0 ) {
		trap = 1;
		trapFlag[fp_disabled] = 1;
	    }
	    break;

	case Instruction::STC:
	case Instruction::STDC:
	case Instruction::STCSR:
	case Instruction::STDCQ:
	    trap = 1;                   // no coprocessor support
	    trapFlag[cp_disabled] = 1;
	    break;
	default:
          // See 'Sun Jan 14 02:22:19 2001 Ackley' note, above 
          // Assert(0, "Bad Store");
          break;
	}
    }
    // next


    if (trap == 0) {
	switch (inst.op3()) {
	case Instruction::STH:
	case Instruction::STHA:
	    if (address & 1) {
		trap = 1;
		trapFlag[mem_address_not_aligned] = 1;
	    }
	    break;

	case Instruction::ST:
	case Instruction::STA:
	case Instruction::STF:
	case Instruction::STFSR:
	    if (address & 3) {
		trap = 1;
		trapFlag[mem_address_not_aligned] = 1;
	    }
	    break;

	case Instruction::STD:
	case Instruction::STDA:
	case Instruction::STDF:
	case Instruction::STDFQ:
	    if (address & 7) {
		trap = 1;
		trapFlag[mem_address_not_aligned] = 1;
	    }
	    break;
	default:
          // See 'Sun Jan 14 02:22:19 2001 Ackley' note, above 
          // Assert(0, "Bad Store");
          break;
	}
    }
    // next


    UInt32 byte_mask = 0, data0 = 0;
    
    if (trap == 0) {
	switch (inst.op3()) {
	case Instruction::STF:
	    byte_mask = 0xf;
	    data0 = fpu->ireg( inst.rd() );
	    break;

	case Instruction::STDF:
	    byte_mask = 0xf;
	    data0 = fpu->ireg( inst.rd() & 0x1e );
	    break;

	case Instruction::STD:
	case Instruction::STDA:
	    byte_mask = 0xf;
	    data0 = reg[inst.rd() & 0x1e];
	    break;

	case Instruction::STFSR:
	    byte_mask = 0xf;
	    data0 = fpu->FSR();
	    break;

	case Instruction::ST:
	case Instruction::STA:
	    byte_mask = 0xf;
	    data0 = reg[inst.rd()];
	    break;

	case Instruction::STH:
	case Instruction::STHA:
	    byte_mask = 3 << (2 - (address & 2));
	    data0 = reg[inst.rd()] << (16 - ((address & 2) << 3));
	    break;

	case Instruction::STB:
	case Instruction::STBA:
	    byte_mask = 1 << (3 - (address & 3));
	    data0 = reg[inst.rd()] << (24 - ((address & 3) << 3));
	    break;

	default:
          // See 'Sun Jan 14 02:22:19 2001 Ackley' note, above 
          // Assert(0, "Bad Store");
          break;
	}
    }
    // next


    if (trap == 0) {
	mmu.write(addr_space, address, byte_mask, data0);
	// next

	if (sbus.bp_memory_exception()) {
	    trap = 1;
	    trapFlag[data_access_exception] = 1;
	}
    }
    // next


    if ( trap == 0 && ( inst.op3() == Instruction::STD ||
			inst.op3() == Instruction::STDA ||
			inst.op3() == Instruction::STDF )) {

	UInt32 data1;

	if ( inst.op3() == Instruction::STDF )
	    data1 = fpu->ireg( inst.rd() | 0x01 );
	else
	    data1 = reg[inst.rd() | 0x01];
	// next

	mmu.write(addr_space, address + 4, 0xf, data1);
	// next

	if (sbus.bp_memory_exception()) {
	    trap = 1;
	    trapFlag[data_access_exception] = 1;
	}
    }
}
