/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// TK_dev.c -- an interface for devices written in Tcl/Tk
//

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: TK_dev.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <tk.h>

#include "sizedefs.h"
#include "Config.h"

#include "config.h"

#include "TK_dev.h"

extern Tcl_Interp *Interp;

//
// public Constructors / Destructors
//
//     There can be more than one TK style device -- each device gets
//          a page in the memory space
//
TK_dev::TK_dev(SystemBus& sb, char *name, int start_addr) :
    StorageDevice(sb, start_addr, (start_addr + Config::ISEM_PAGE_SIZE - 1) )
{ 
    base_addr = start_addr;

    dev_name = new char[strlen(name)+1];
    strcpy( dev_name, name );
}

//
// public Member functions
//
void TK_dev::reset() {
}


void TK_dev::run() {
}


UInt32 TK_dev::read(UInt32 addr) {
    char buf[256];
    UInt32 res;
    sprintf( buf, "%s read %d 0 0", dev_name, addr-base_addr );
    Tcl_Eval( Interp, buf );
    // sscanf( Interp->result, "%u", &res );
    res = strtoul( Interp->result, NULL, 0 );
    return res;
}


void TK_dev::write(UInt32 addr, int byteMask, UInt32 value) {
    char buf[256];
    sprintf( buf, "%s write %d %d %d", dev_name, addr-base_addr,
	    byteMask, value );
    Tcl_Eval( Interp, buf );
}
