set share_counter 0
set share_locked 0
set share_id "none"


proc open_share { host share } {
	global USERNAME PASSWORD
	global H_${host}_IP C_SHARE C_GROUP
	global sh_request sh_data share_passwd share_user

	global share_counter share_locked share_id

	if { $C_SHARE == $share && $share_passwd == $PASSWORD && $share_user == $USERNAME } {return {} }
	set_current C_SHARE .shares $share
	set share_passwd [makepasswd $host $share 2]
	set share_user	$USERNAME

	set share_counter [expr {$share_counter + 1}]
	puts $share_counter

	set counter $share_counter
	if { $share_locked == 0 } {
   		if { $share_id != "none" } {
      			catch { close -i $share_id }
      			wait -i $share_id
   			}
   		} 
	set share_locked 1
	SetStatus "+BUSY"
	.remote configure -state normal
	.remote delete 1.1 end
	.remote configure -state disabled
	.trbltr configure -text ""
	set ip [ nmblookup $host ]
	if { $counter != $share_counter } {
   		set share_id "none"
   		return {}
		}
	if { $ip!="" } {
		spawn smbclient //$host/$share -U $share_user -I $ip -W $C_GROUP
		} else {
		spawn smbclient //$host/$share -U $share_user -W $C_GROUP
		}
	set id $spawn_id
	set share_id $id
	set trigger 0
	expect {
		-i $id assword: {
			#password "Enter Password:"
			exp_send "$share_passwd\r"
			exp_continue
			}
		-i $id -re $sh_request {
			if { $trigger == 0 } {
				exp_send "ls\r"
				set trigger 1
				exp_continue
				}
			}
		-i $id -re $sh_data {
        		.remote configure -state normal
			if { $expect_out(3,string) == "D" } {
        			.remote insert end $expect_out(1,string) {dir}
				} {
				.remote insert end $expect_out(1,string) {file}
				}
        		.remote insert end " \n "
        		.remote configure -state disabled
			exp_continue
			}
		}
	.trbltr configure -text "\\"
	SetStatus "-BUSY"
	set share_locked 0
	if { $counter != $share_counter } {
   		puts "COLLISION in Open_Share"
		catch { close -i $id }
   		wait -i $id
		}
	}

proc dl_exp { comm id } {
	global sh_request
	exp_send -i $id $comm
	expect {
		-i $id -re $sh_request { }
   		}
	}


proc cd_share { dir } {
	global sh_request sh_data
	global share_locked share_id share_counter
	if { $share_locked == 1 } {
		.status.lbl configure -text "< !Downloading! >"
		return {}
		}
	SetStatus "+BUSY"
	set id $share_id
	set share_locked 1
	set counter $share_counter

	.remote configure -state normal
	.remote delete 1.1 end
	.remote configure -state disabled

	set spawn_id $id
	set trigger 0
	#set updir {<UP>}
	#if { $dir == "\"$updir\"" } { set dir .. }
	dl_exp "cd $dir\r" $id

	exp_send "ls\r"
	expect {
		-i $id -re $sh_data {
			set name $expect_out(1,string)
			if { $name != "." } {
				.remote configure -state normal
				if { $expect_out(3,string) == "D" } {
				#if { $name == ".." } { set name $updir }
					.remote insert end $name {dir}
					} {
					.remote insert end $name {file}
					}
				.remote insert end " \n "
				.remote configure -state disabled
				}
			exp_continue
			}
		-i $id -re $sh_request {
	   		set path $expect_out(1,string)
			.trbltr configure -text "$path"
			}
		}
	set share_locked 0
	SetStatus "-BUSY"
	if { $counter != $share_counter } {
   		puts "COLLISION in cd_share"
   		wait -i $id
		}
	}


   



proc download_file { savelocation file dir_flag} {
	global sh_request
	global DOWNLOAD share_id share_counter share_locked
	set counter $share_counter
	set id $share_id
	if { $share_locked != "0" } {
		.status.lbl configure -text "< !Already Downloading! >"
   		return {}
		}
	SetStatus "+DL"
	regexp {(.*)/([^/]+)} $savelocation none savedir savefile
	set DOWNLOAD $savedir
	set share_locked 1
	set spawn_id $id
	dl_exp "lcd $savedir/\r" $id
	if { $dir_flag == 1 } {
		dl_exp "recurs\r" $id
		dl_exp "prompt\r" $id
		exp_send "mget \"$file\"\r"
		} {
		exp_send "get \"$file\" \"$savefile\"\r"
		}

	expect {
		-i $id -re $sh_request { }
		timeout { exp_continue }
		}

	if { $dir_flag == 1 } {
		dl_exp "recurs\r" $id
   		dl_exp "prompt\r" $id
		}
	if { $counter != $share_counter } {
		catch {close -i $id}
		wait -i $id
		} {
		set share_locked 0
		}
	SetStatus "-DL"
	view \"$DOWNLOAD/$file\"
	}

