/* Tower Toppler - Nebulus
 * Copyright (C) 2000-2006  Andreas Rver
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef EVENT_H
#define EVENT_H

#include "decl.h"
#include <stdint.h>
#include <SDL.h>

typedef enum {
  no_key       =  0x0000,
  up_key       =  0x0001,
  down_key     =  0x0002,
  left_key     =  0x0004,
  right_key    =  0x0008,
  fire_key     =  0x0010,
  break_key    =  0x0020,
  pause_key    =  0x0040,
  any_key      =  0xFFFF
} ttkey;

typedef enum {
    null_ev,input_ev,mouse_ev,key_ev,fire_ev,left_ev,right_ev,up_ev,down_ev,pause_ev,break_ev,debug_ev 
	// you must always end with debug_ev
} event_t;

typedef void FDECL((*keyb_wait_proc), (void));

class Event {
    private:
	event_t type;
    public:
	virtual SDLKey get_keysym() {return SDLK_UNKNOWN;}
	Event(event_t t) : type(t) {};
	Event() : type(null_ev) {};
	virtual ~Event() {};
	const event_t get_type() const {return type;}
};

class JoyEvent : public Event {
    public:
	JoyEvent(event_t ntype) : Event(ntype) {};
};

class MouseButtonEvent : public Event {
    private:
	SDL_MouseButtonEvent ev;
    public:
	MouseButtonEvent(SDL_MouseButtonEvent e) : Event(mouse_ev), ev(e) {};
};

class KeyEvent : public Event {
    private:
	SDL_keysym ksym;
    public:
	virtual SDLKey get_keysym() {return ksym.sym;}
	KeyEvent(event_t ntype,SDL_keysym key) : Event(ntype), ksym(key) {};

};

class EventHandler {
    public:
	EventHandler() : joy(0), joy_tolerance(5000) {};
	void init();
	void done();
	bool check_for(event_t event);
	void update();
	void wait_event();
	bool has_focus()  { return(SDL_GetAppState() & SDL_APPINPUTFOCUS); } 
	void wait_focus(); 
	Event *get_input();
	SDLKey get_nextkey(char *c=0);
	const char *get_keydef(const event_t event);
	SDLKey get_keydef_sdl(const event_t event);
	void set_keydef(const event_t event, SDLKey key);
	void wait_nokey(keyb_wait_proc bg);
	void set_tolerance(int _t) { joy_tolerance=_t; } 
    private:
	void process_event(SDL_Event &e);
	SDL_Joystick *joy;
	int joy_tolerance;
        SDLKey keymap[debug_ev+1];
// in order to mimic the behaviour of the old event system, we have a "backup"
// keymap that keymap overrides but is always constant.
        SDLKey altkeymap[debug_ev+1]; 
};


extern EventHandler events; // event hander 

#endif

