// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SPARSE_DATA_SET_INC
#define SPARSE_DATA_SET_INC

#include "EuclideanDataSet.h"
#include "normalize.h"

namespace Torch {

/** Sparse Data Set.

    DataSet with a vector of #sreals# for inputs,
    and a vector of real for targets.
    
    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class SparseDataSet : public EuclideanDataSet
{
  public:
    /// The inputs table.
    sreal **all_inputs;

    /// The targets table.
    real **all_targets;

    //-----

    ///
    SparseDataSet();

    /** Set the inputs and the targets to a user tabular
        #n_dim# is the dimension of inputs vectors
        #n_targets_# is the dimension of targets vectors.

        Call them BEFORE #init()#.
    */
    void setInputs(sreal **data_, int n_dim, int n_examples_);
    ///
    void setTargets(real **y_, int n_targets_);

    //-----

    virtual void setRealExample(int t);
    virtual real realRealDotProduct(int i, int j);
    virtual real realDotProduct(int i, List *y);
    virtual real dotProduct(List *x, List *y);

    //-----

    virtual void init();

    virtual ~SparseDataSet();
};


}

#endif
