// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef STOCHASTIC_GRADIENT_INC
#define STOCHASTIC_GRADIENT_INC

#include "Optimizer.h"
#include "random.h"

namespace Torch {

/** Stochastic Gradient Optimizer for GMTrainer

    Options:
    \begin{tabular}{lcll}
      "end accuracy"         & real  &  end accuracy                   & [0.0001]\\
      "learning rate"        & real  &  learning rate                  & [0.01]\\
      "learning rate decay"  & real  &  learning rate decay            & [0]\\
      "max iter"             & int   &  maximum number of iterations   & [-1]
    \end{tabular}

    @see GMTrainer
    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class StochasticGradient : public Optimizer
{
  public:
    
    real learning_rate;
    real learning_rate_decay;
    real end_accuracy;
    int max_iter;

    //-----

    ///
    StochasticGradient();
    virtual void train(List *measurers);

    //-----

    virtual ~StochasticGradient();
};


}

#endif
