/* Test harness for stack-copying conext switching.
 * Assumes stack grows toward lower addresses.
 */
#include "tra.h"

Label mainlabel;

static void swtch0(Ctxt*, Ctxt*);
static void swtch1(Ctxt*);
static void swtch2(Ctxt*);

/* the abort() calls keep smart compilers from optimizing the tail recursion */

static void
switchctxt(Ctxt *cur, Ctxt *nxt)
{
	/*
	 * save the current stack position and registers
	 * the first time through.  swtch0 won't return.
	 */
	if(setlabel(&cur->label)==0){
		swtch0(cur, nxt);
		abort();
	}
}

static void
swtch0(Ctxt *cur, Ctxt *nxt)
{
	uchar *lo, *hi;
	int n;

	/* save the stack for the current thread */
	lo = (uchar*)cur->label.sp;
	hi = (uchar*)mainlabel.sp;
	n = hi-lo;
	cur->stk = emalloc(n);
	memmove(cur->stk, lo, n);

	/* switch to the next thread */
	swtch1(nxt);
	abort();
}

static void
swtch1(Ctxt *nxt)
{
	uchar buf[64];	/* take up stack space */

	/* recurse until we're out of the area the new stack will occupy. */
	if(nxt->label.sp < (ulong)buf)
		swtch1(nxt);

	/* do the copy */
	swtch2(nxt);
	abort();
}

static void
swtch2(Ctxt *nxt)
{
	uchar *lo, *hi;
	int n;

	/* put the next stack in place */
	lo = (uchar*)nxt->label.sp;
	hi = (uchar*)mainlabel.sp;
	n = hi-lo;
	memmove(lo, nxt->stk, n);

	free(nxt->stk);
	nxt->stk = nil;

	/* hop to it */
	gotolabel(&nxt->label);
	abort();
}

Ctxt ml, pl;

void
printthread(void *a)
{
	printf("printthread runs, arg is %d\n", (int)a);
	switchctxt(&pl, &ml);
}

int
main(int argc, char **argv)
{
	setlabel(&mainlabel);
	
	initctxt(&pl, printthread, (void*)12345);
	printf("main runs\n");
	switchctxt(&ml, &pl);
	printf("main runs again\n");
	return 0;
}
