<?cs set:html.stylesheet = 'css/search.css' ?>
<?cs include "header.cs"?>
<script type="text/javascript">
addEvent(window, 'load', function() { document.getElementById('q').focus()}); 
</script>

<div id="ctxtnav" class="nav">
 <h2>検索ナビゲーション</h2>
 <ul><?cs
  if:len(links.prev) ?>
   <li class="first<?cs if:!len(links.next) ?> last<?cs /if ?>">
    <a href="<?cs var:links.prev.0.href ?>" title="<?cs
      var:links.prev.0.title ?>">前のページ</a>
   </li><?cs
  /if ?><?cs
  if:len(links.next) ?>
   <li class="<?cs if:len(links.prev) ?>first <?cs /if ?>last">
    <a href="<?cs var:links.next.0.href ?>" title="<?cs
      var:links.next.0.title ?>">次のページ</a>
   </li><?cs
  /if ?>
 </ul>
</div>

<div id="content" class="search">

<h1><label for="q">検索</label></h1>
<form action="<?cs var:trac.href.search ?>" method="get">
 <p>
  <input type="text" id="q" name="q" size="40" value="<?cs var:search.q ?>" />
  <input type="submit" value="Search" />
 </p>
 <p><?cs
  if:trac.acl.WIKI_VIEW ?>
   <input type="checkbox" id="wiki" name="wiki" <?cs
     if:search.wiki ?>checked="checked"<?cs /if ?> />
   <label for="wiki">Wikiページ</label><?cs
  /if ?><?cs
  if:trac.acl.TICKET_VIEW ?>
   <input type="checkbox" id="ticket" name="ticket" <?cs
     if:search.ticket ?>checked="checked"<?cs /if ?> />
   <label for="ticket">チケット</label><?cs
  /if ?><?cs
  if:trac.acl.CHANGESET_VIEW ?>
   <input type="checkbox" id="changeset" name="changeset" <?cs
     if:search.changeset ?>checked="checked"<?cs /if ?> />
   <label for="changeset">チェンジセット</label><?cs
  /if ?>
 </p>
</form>

<?cs def result(title, keywords, body, link) ?>
 <dt><a href="<?cs var:link ?>"><?cs var:title ?></a></dt>
 <dd><?cs var:body ?></dd>
 <dd>
  <span class="author">更新者: <?cs var:item.author ?></span>,
  <span class="date">更新日時: <?cs var:item.datetime ?></span><?cs
  if:item.keywords ?> ,
   <span class="keywords">キーワード: <em><?cs var:item.keywords ?></em></span><?cs
  /if ?>
 </dd>
<?cs /def ?>

<?cs if:len(search.result) ?>
 <hr />
 <h2>検索結果 <?cs
  if:len(links.prev) || len(links.next) ?>(<?cs
   var:search.result_page * search.results_per_page + 1 ?> - <?cs
   var:search.result_page * search.results_per_page + len(search.result) ?>)<?cs
  /if ?></h2>
 <div id="searchable">
  <dl id="results"><?cs
   each item=search.result ?><?cs
    if:item.type == 1 ?><?cs
     call:result('[' + item.data + ']: ' + item.shortmsg, item.keywords,
                 item.message, item.changeset_href) ?><?cs
    elif:item.type == 2 ?><?cs
     call:result('#' + item.data + ': ' + item.title, item.keywords,
                 item.message, item.ticket_href) ?><?cs
    elif:item.type == 3 ?><?cs
     call:result(item.data + ': ' + item.shortmsg, item.keywords,
                 item.message, item.wiki_href) ?><?cs
    /if ?><?cs
   /each ?>
  </dl>
  <hr />
 </div>
 <?cs if:len(links.prev) || len(links.next) ?>
  <div id="paging" class="nav">
   <ul><?cs
    if:len(links.prev) ?>
     <li class="first<?cs if:!len(links.next) ?> last<?cs /if ?>">
      <a href="<?cs var:links.prev.0.href ?>" title="<?cs
        var:links.prev.0.title ?>">前のページ</a>
     </li><?cs
    /if ?><?cs
    if:len(links.next) ?>
     <li class="<?cs if:len(links.prev) ?>first <?cs /if ?>last">
      <a href="<?cs var:links.next.0.href ?>" title="<?cs
        var:links.next.0.title ?>">次のページ</a>
     </li><?cs
    /if ?>
   </ul>
  </div>
 <?cs /if ?>

<?cs elif $search.q ?>
 <div id="notfound">検索条件にマッチするWikiページ、チケット、チェンジセットが見つかりません。</div>
<?cs /if ?>

 <div id="help">
  <strong>Note:</strong> 検索についてのヘルプは <a href="<?cs var:$trac.href.wiki ?>/TracSearch">TracSearch</a> を参照してください。
 </div>

</div>
<?cs include "footer.cs"?>
