/* mainMode.cc
   The main operation mode of the game.

   Copyright (C) 2000  Mathias Broxvall
		       Yannick Perret

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "general.h"
#include "gameMode.h"
#include "mainMode.h"
#include "glHelp.h"
#include "map.h"
#include "player.h"
#include "game.h"
#include "sound.h"
#include "flag.h"
#include "menuMode.h"
#include "enterHighScoreMode.h"
#include "sign.h"
#include "SDL_image.h"
#include "forcefield.h"
#include "scoreSign.h"
#include "settings.h"
#include "gamer.h"
#include "font.h"

using namespace std;

const int MainMode::statusBeforeGame=0,MainMode::statusGameOver=1,MainMode::statusInGame=2;
const int MainMode::statusRestartPlayer=3,MainMode::statusNextLevel=4, MainMode::statusVictory=5;
const int MainMode::statusLevelComplete=6,MainMode::statusBonusLevelComplete=7;
const int MainMode::statusPaused=8;
SDL_Surface *MainMode::panel,*MainMode::life,*MainMode::nolife;

MainMode *MainMode::mainMode=NULL;

void MainMode::init() { 
  char str[256];

  mainMode = new MainMode(); 

  sprintf(str,"%s/images/left_panel.png",SHARE_DIR);
  panel = IMG_Load(str);
  if(!panel) { printf("Error: Failed to load %s\n",str); exit(0); }  

  sprintf(str,"%s/images/life.png",SHARE_DIR);
  life = IMG_Load(str);
  if(!life) { printf("Error: Failed to load %s\n",str); exit(0); }  

  sprintf(str,"%s/images/nolife.png",SHARE_DIR);
  nolife = IMG_Load(str);
  if(!nolife) { printf("Error: Failed to load %s\n",str); exit(0); }  
}
MainMode::MainMode() {
  this->go_to_pause = 0;
  this->pause_time = 0.;
}
MainMode::~MainMode() { }

void MainMode::display() {
  char str[256];
  int birdsEye=0;

  Map *map = Game::current?Game::current->map:NULL;
  Player *player1 = Game::current?Game::current->player1:NULL;
  
  glPushAttrib(GL_ENABLE_BIT);
  
  if(Game::current->fogThickness)
	glClearColor(Game::current->fogColor[0],Game::current->fogColor[1],Game::current->fogColor[2],Game::current->fogColor[3]);
  else
	glClearColor(0.0,0.0,0.0,0.0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  if(Game::current->fogThickness && Settings::settings->gfx_details != GFX_DETAILS_NONE) {
	glEnable(GL_FOG);
	glFogi(GL_FOG_MODE,GL_LINEAR);
	glFogf(GL_FOG_START,max(0.0,14.0-7.0*Game::current->fogThickness));
	glFogf(GL_FOG_END,26.0-4.0*Game::current->fogThickness);
	glFogfv(GL_FOG_COLOR,Game::current->fogColor);
  } else
	glDisable(GL_FOG);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(40,640.0/480.0,1.0,1e20);

  /* Setup openGL matrixes for the camera perspective */
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  if(gameStatus == statusBeforeGame) {	
	gluLookAt(map->startPosition[0]-12*sin(time),map->startPosition[1]-12*cos(time),10.0+map->startPosition[2],
			  map->startPosition[0],map->startPosition[1],map->startPosition[2],
			  0.0, 0.0, 1.0);
	birdsEye=1;
  } else {
	birdsEye=0;
	if(zAngle > 0.25 || xyAngle > 0.3 || xyAngle < -.3) birdsEye=1;

	double angle=xyAngle*M_PI/2. + M_PI/4.;
	Coord3d up; up[0]=sin(angle)*zAngle; up[1]=cos(angle)*zAngle; up[2]=1.0-zAngle; normalize(up);
	gluLookAt(camFocus[0]-10.*sin(angle)*cos(zAngle*M_PI/2.), camFocus[1]-10.*cos(angle)*cos(zAngle*M_PI/2.), 
			  10.0+camFocus[2]*0.5+(10.0+camFocus[2])*sin(zAngle*M_PI/2.),
			  camFocus[0], camFocus[1], camFocus[2],
			  up[0],up[1],up[2]); //0.0, 0.0, 1.0);
	/*
	gluLookAt(camFocus[0]-6.5, camFocus[1]-6.5, 10.0+camFocus[2]*0.5,
			  camFocus[0], camFocus[1], camFocus[2],
			  0.0, 0.0, 1.0);*/
  }

  /* Some standard GL settings needed */
  glEnable(GL_CULL_FACE);
  glEnable(GL_DEPTH_TEST);
  glDepthFunc(GL_LEQUAL);

  GLfloat lightDiffuse[] = { 0.9, 0.9, 0.9, 1.0 };
  GLfloat lightPosition[] = { -100.0, -50.0, 150.0, 0.0 };
  glLightfv(GL_LIGHT0, GL_DIFFUSE, lightDiffuse);
  glLightfv(GL_LIGHT0, GL_POSITION, lightPosition);
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  GLfloat ambient[] = { 0.2, 0.2, 0.2, 1.0 };
  glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient);

  if(Game::current && Game::current->isNight) {
    GLfloat lightDiffuse2[] = { 0.9, 0.9, 0.9, 1.0 };
    GLfloat lightPosition2[4] = {252.0,252.0,10.0,1.0};
    lightPosition2[0] = Game::current->player1->position[0];
    lightPosition2[1] = Game::current->player1->position[1];
    lightPosition2[2] = Game::current->player1->position[2] + 2.0;
    GLfloat black[] = { 0.0,0.0,0.0,1.0 };
    glLightModelfv(GL_LIGHT_MODEL_AMBIENT, black);
    glLightfv(GL_LIGHT0, GL_AMBIENT, black);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, lightDiffuse2);
    glLightfv(GL_LIGHT0, GL_SPECULAR, lightDiffuse2);
    glLightfv(GL_LIGHT0, GL_POSITION, lightPosition2);
    glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, 0.25);
  }

  glShadeModel(GL_SMOOTH);

  /* Setup how we handle textures based on gfx_details */
  if(Settings::settings->gfx_details == 5) {
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glHint(GL_FOG_HINT,GL_NICEST);
  } else {
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
  	glHint(GL_FOG_HINT,GL_FASTEST);
  }


  switch(gameStatus) {
  case statusBeforeGame:
    if(map) map->draw(1,0,(int) map->startPosition[0],(int) map->startPosition[1]);
    Game::current->draw();
    if(map) map->draw(1,1,(int) map->startPosition[0],(int) map->startPosition[1]);
    { 
      char *lp[3], *rp[3];
      lp[0] = "Track:"; rp[0] = Game::current->map->mapname;
      lp[1] = "Author:"; rp[1] = Game::current->map->author;
      lp[2] = "Press spacebar to begin"; rp[2] = " ";
      multiMessage(3,lp,rp);
    }
    break;
  case statusGameOver:
    map->draw(birdsEye,0, (int) camFocus[0],(int) camFocus[1]);
    Game::current->draw();
    map->draw(birdsEye,1, (int) camFocus[0],(int) camFocus[1]);
    showInfo();
	{ 
	  char str[256];
	  /*	  int buyCost;
	  buyCost=(Game::current->player1->score/200)*100+500;
	  if(Game::current->player1->score >= buyCost) 
		sprintf(str,"Buy continue (%d points)?",buyCost);
		else*/
		sprintf(str,"Press spacebar to continue");
	  message("Game over",str);
	}
    break;
  case statusRestartPlayer:
    map->draw(birdsEye,0, (int) camFocus[0],(int) camFocus[1]);
    Game::current->draw();
    map->draw(birdsEye,1, (int) camFocus[0],(int) camFocus[1]);
    showInfo();
    message("Oops","Press spacebar to continue");
    break;
  case statusInGame:
    map->draw(birdsEye,0, (int) camFocus[0],(int) camFocus[1]);
    Game::current->draw();
    map->draw(birdsEye,1, (int) camFocus[0],(int) camFocus[1]);
    showInfo();
    break;
  case statusPaused:
    map->draw(birdsEye,0, (int) camFocus[0],(int) camFocus[1]);
    Game::current->draw();
    map->draw(birdsEye,1, (int) camFocus[0],(int) camFocus[1]);
    showInfo();
    // darken the display
    Enter2DMode();	
    glEnable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    glColor4f(0., 0., 0., pause_time);
    glBegin(GL_TRIANGLE_STRIP);
    glVertex2i(0, 0);
    glVertex2i(screenWidth, 0);
    glVertex2i(0, screenHeight);
    glVertex2i(screenWidth, screenHeight);
    glEnd();
    glDisable(GL_BLEND);
    Leave2DMode();
    // print 'paused'
    glColor4f(1., 1., 1., 1.);
	Font::drawCenterSimpleText(0,"Paused",screenWidth/2,screenHeight/2-16,16.,16.,1.0,1.0,1.0,0.75);
    //draw2DString(menuFont, "Paused", screenWidth/2-32, screenHeight/2-10,
	//               255,255,255);
    break;
  case statusBonusLevelComplete:
	map->draw(birdsEye,0, (int) camFocus[0],(int) camFocus[1]);
	Game::current->draw();
	map->draw(birdsEye,1, (int) camFocus[0],(int) camFocus[1]);
	showInfo();
	message("Bonus level complete","Press spacebar to continue");
	break;
  case statusLevelComplete:
	map->draw(birdsEye,0, (int) camFocus[0],(int) camFocus[1]);
	Game::current->draw();
	map->draw(birdsEye,1, (int) camFocus[0],(int) camFocus[1]);
	showInfo();
	showBonus();	
	break;
  case statusNextLevel:
	map->draw(birdsEye,0, (int) camFocus[0],(int) camFocus[1]);
	Game::current->draw();
	map->draw(birdsEye,1, (int) camFocus[0],(int) camFocus[1]);
	showInfo();
	message("Level complete","Press spacebar to continue");
	break;
  case statusVictory:
	map->draw(birdsEye,0, (int) camFocus[0],(int) camFocus[1]);
	Game::current->draw();
	map->draw(birdsEye,1, (int) camFocus[0],(int) camFocus[1]);
	showInfo();
	message("Congratulations","You have completed the game!");
	break;
  }

  if(player1->modTimeLeft[MOD_FROZEN]) {
	Enter2DMode();
	glColor4f(0.5,0.5,1.0,0.5*min(1.0,(double)player1->modTimeLeft[MOD_FROZEN]));;
	glBegin(GL_TRIANGLE_STRIP); 
	glVertex2i(0,0); glVertex2i(screenWidth,0); glVertex2i(0,screenHeight); glVertex2i(screenWidth,screenHeight);
	glEnd();
	Leave2DMode();
  }

  displayFrameRate();
  /* Print joystick debugging information */
  if(debug_joystick && Settings::settings->hasJoystick()) {
	Enter2DMode();
	snprintf(str,255,"Joy: %d, %d -> %.1f, %.1f",Settings::settings->joystickRawX(),Settings::settings->joystickRawY(),
			 Settings::settings->joystickX(),Settings::settings->joystickY());
	Font::drawCenterSimpleText(0,str,screenWidth/2,screenHeight-16, 8., 8., 0.6, 0.6, 0.6, 0.6);
	Leave2DMode();
  }
  glPopAttrib();
}
void MainMode::key(int key) {  
  Player *player1 = Game::current?Game::current->player1:NULL;
  
  switch(gameStatus) {
  case statusBeforeGame:
    if(key == ' ') startGame();
    break;
  case statusRestartPlayer:
    if(key == ' ') {
	  restartPlayer();
	  player1->timeLeft += (int) Game::current->restartBonusTime;
	  gameStatus=statusInGame;
	}
    break;
  case statusPaused:
    go_to_pause = 0;
    //gameStatus = statusInGame;
    break;
  case statusInGame:
        if ((key == 'p')||(key == 'P'))
          {
	  go_to_pause = 1;
	  pause_time = 0.;
          gameStatus = statusPaused;
          break;
          }
	if (key == SDLK_PRINT)
	  {
	  createSnapshot();
	  break;
	  }
	player1->key(key); 
	break;
  case statusBonusLevelComplete:
  case statusNextLevel:
	if(key == ' ') {
	  if(!Game::current->nextLevel[0]) { gameStatus = statusVictory; break; }
	  xyAngle=wantedXYAngle=zAngle=wantedZAngle=0.0;
	  Game::current->fogThickness = Game::current->wantedFogThickness;
	  Game::current->clearLevel();
	  Game::current->loadLevel(Game::current->nextLevel);
	  Game::current->player1->newLevel();
	  restartPlayer();
	  gameStatus = statusBeforeGame;
	}
	break;
  case statusGameOver: 
	{
	  /*	  int buyCost;
	  buyCost=(Game::current->player1->score/200)*100+500;
	  if(Game::current->player1->score >= buyCost && key == 'y') {
		restartPlayer();
		player1->lives++;
		player1->timeLeft += 30;
		gameStatus=statusInGame;
		new ScoreSign(-buyCost,player1->position);
		} else  */
		if(key == ' ' || key == 'n')
		GameMode::activate(EnterHighScoreMode::enterHighScoreMode);
	}
	break;
  case statusVictory:
	if(key == ' ') {
	  GameMode::activate(EnterHighScoreMode::enterHighScoreMode);
	  Game::current->gamer->playerLoose();
	}
	break;
  }
}
void MainMode::special(int key,int x,int y) {
}
void MainMode::idle(Real td) {
  Player *player1 = Game::current?Game::current->player1:NULL;
  Map *map = Game::current?Game::current->map:NULL;
  double t;
  int i;
  
  time += td;
  flash -= td;
  if(flash < 0.0) flash = 0.0;

  if(Settings::settings->hasJoystick()) {
	if(Settings::settings->joystickButton(0)) key(' ');
  }

  switch(gameStatus) {
  case statusBeforeGame: 
    break;
  case statusGameOver: /* rotate view? */ 
    Game::current->tick(td);
    break;
  case statusLevelComplete:
	{
	  int old_status = (int) statusCount;
	  statusCount += 0.8 * td;
	  Player *player = Game::current->player1;
	  if((int) statusCount != old_status) {
		if((int) statusCount <= 3)
		  playEffect(SFX_GOT_FLAG);
		switch((int) statusCount) {
		case 1: player->score += player->lives * 100; break;
		case 2: player->score += (player->timeLeft/60) * 250; break;
		case 3: player->score += Settings::settings->difficulty * 500; break;
		}
	  }
	  if(statusCount > 5.0) {
		playEffect(SFX_LV_COMPLETE);
		if(Game::current->nextLevel[0])
		  gameStatus = statusNextLevel;    
		else
		  gameStatus = statusVictory;		  
	  }
	}
	// note. No break here!
  case statusNextLevel:
  case statusInGame:
	if(wantedZAngle > zAngle) zAngle += min(0.4*td,wantedZAngle-zAngle);
	else if(wantedZAngle < zAngle) zAngle -= min(0.4*td,zAngle-wantedZAngle);
	if(wantedXYAngle > xyAngle) xyAngle += min(0.4*td,wantedXYAngle-xyAngle);
	else if(wantedXYAngle < xyAngle) xyAngle -= min(0.4*td,xyAngle-wantedXYAngle);

    Game::current->tick(td);
    for(t=td;t>=0.0;t-=0.01)
      for(i=0;i<3;i++) {
		camDelta[i] = camDelta[i] * 0.9 + 0.002 * (player1->position[i] - camFocus[i]);
		camFocus[i] += camDelta[i];
      }
    break;
  case statusPaused:
    if (go_to_pause) {
    	if (pause_time > 0.5) {
	  pause_time = 0.5;
	  break;
	  }
	pause_time += td;
    }
    else {
    	if (pause_time <= 0.) {
		pause_time = 0.;
		gameStatus = statusInGame;
		break;
	}
	pause_time -= td;
	
    }
    break;
  case statusRestartPlayer: 
    Game::current->tick(td);
    //    assign(map->startPosition,camFocus); zero(camDelta); 
    break;
  }
}
void MainMode::activated() {
  zAngle=wantedZAngle=0.0;
  xyAngle=wantedXYAngle=0.0;
  zero(camFocus);
  zero(camDelta);
  gameStatus=statusBeforeGame;
  SDL_WarpMouse(screenWidth/2,screenHeight/2);

  camFocus[0] = Game::current->map->startPosition[0] - 5;
  camFocus[1] = Game::current->map->startPosition[1] - 5;
  time = 0.0;
  flash = 0.0;
}
void MainMode::deactivated() {  }
void MainMode::playerLoose() { Game::current->gamer->playerLoose(); gameStatus=statusGameOver; }
void MainMode::playerDie() { gameStatus=statusRestartPlayer; }

/* Pass along, nothing to see here... */
void MainMode::mouse(int state,int x,int y) { 
  if(Game::current) Game::current->player1->mouse(state,x,y); 
}
void MainMode::mouseDown(int button,int x,int y) { key(' '); } // if(button && gameStatus != statusInGame) key(' '); }

/* Starts the current game */
void MainMode::startGame() {
  gameStatus = statusInGame;
  Game::current->player1->hasWon = 0;
  playEffect(SFX_START);	
  Coord3d pos;
  assign(Game::current->map->startPosition,pos);
  pos[2] += 2.0;
  new Sign("Good luck!",7,1.0,60.0,pos);
  Game::current->player1->position[2] += 1.0;
}

/* (Re)starts the current player */
void MainMode::restartPlayer() {
  Player *player1 = Game::current?Game::current->player1:NULL;
  player1->restart(Game::current->map->startPosition);
  camFocus[0] = Game::current->map->startPosition[0];
  camFocus[1] = Game::current->map->startPosition[1];
  Game::current->gamer->levelStarted();

  Coord3d pos;
  assign(Game::current->map->startPosition,pos);
  pos[2] += 2.0;
  new Sign("Good luck!",7,1.0,60.0,pos);
}

/* Shows various information on screen */
void MainMode::showInfo() {
  if(!Game::current) return;
  char str[256];
  Player *player = Game::current->player1;
  int i,w,h;

  glColor3f(1.0,1.0,1.0);

  // the panel
  drawSurface(panel,0,0,panel->w,panel->h);

  // lives
  for(i=0;i<4;i++)
	drawSurface(i<player->lives?life:nolife,63+i*20,7,life->w,life->h);

  // Score
  sprintf(str,"%d",player->score);
  //TTF_SizeText(infoFont,str,&w,&h);
  //draw2DString(infoFont,str,148-w,65,0,0,0);
  Font::drawRightSimpleText(0,str,152,52,8.,8.,0.0,0.0,0.0,1.0);

  // Time left
  sprintf(str,"%2.2d:%2.2d",player->timeLeft/60,player->timeLeft%60);
  //  TTF_SizeText(infoFont,str,&w,&h);
  if(player->timeLeft < 15 && player->timeLeft % 2)
	//draw2DString(infoFont,str,148-w,94,255,255,255);
	Font::drawRightSimpleText(0,str,152,81,8.,8.,1.0,1.0,1.0,1.0);
  else
	//draw2DString(infoFont,str,148-w,94,0,0,0);
	Font::drawRightSimpleText(0,str,152,81,8.,8.,0.0,0.0,0.0,1.0);
  
	//	draw2DString(infoFont,str,10,20+1*18,255,255,64); 

  Enter2DMode(); 

  // Health
  glDisable(GL_TEXTURE_2D);
  glColor4f(0.5,0.1,0.1,1.0);
  glBegin(GL_POLYGON);
  glVertex2i(8, 3);
  glVertex2i(8+144, 3);
  glVertex2i(8+144, 8);
  glVertex2i(8, 8);
  glEnd();
  glBegin(GL_POLYGON);
  glColor4f(0.8,0.8,0.1,1.0);
  glVertex2i(8, 3);
  glColor4f(0.8,0.1,0.1,1.0);
  glVertex2i(8 + (int) (144.0*player->health), 3);
  glVertex2i(8 + (int) (144.0*player->health), 8);
  glColor4f(0.8,0.8,0.1,1.0);
  glVertex2i(8, 8);
  glEnd();

  // Oxygen
  glEnable(GL_BLEND);
  glColor4f(0.2,0.2,0.7,0.8);
  glBegin(GL_POLYGON);
  glVertex2i(8, 3);
  glVertex2i(8 + (int) (144.0*(1.-player->oxygen)), 3);
  glVertex2i(8 + (int) (144.0*(1.-player->oxygen)), 8);
  glVertex2i(8, 8);  
  glEnd(),

  Leave2DMode();

  /*
  for(i=0;i<3;i++)
	drawSurface(player->modTimeLeft[i]?hasmod:nomod,(screenWidth-panel->w)/2+320,5+24*i,hasmod->w,hasmod->h);
  for(i=0;i<3;i++)
	drawSurface(player->modTimeLeft[i+3]?hasmod:nomod,(screenWidth-panel->w)/2+447,5+24*i,hasmod->w,hasmod->h);
  */

  /*
  int nMods=0;
  if(player->modTimeLeft[MOD_SPEED]) {
	sprintf(str,"Speedball %d sec",(int)player->modTimeLeft[MOD_SPEED]);
	draw2DString(infoFont,str,screenWidth-120,20+nMods*18,64,64,255); 
	nMods++;
  }
  if(player->modTimeLeft[MOD_JUMP]) {
	sprintf(str,"Jumpjets %d sec",(int)player->modTimeLeft[MOD_JUMP]);
	draw2DString(infoFont,str,screenWidth-120,20+nMods*18,64,64,255); 
	nMods++;
  }
  if(player->modTimeLeft[MOD_SPIKE]) {
	sprintf(str,"Spikes %d sec",(int)player->modTimeLeft[MOD_SPIKE]);
	draw2DString(infoFont,str,screenWidth-120,20+nMods*18,64,64,255); 
	nMods++;
  }
  if(player->modTimeLeft[MOD_GLASS]) {
	sprintf(str,"Glassball %d sec",(int)player->modTimeLeft[MOD_GLASS]);
	draw2DString(infoFont,str,screenWidth-120,20+nMods*18,255,64,64); 
	nMods++;
  }
  if(player->modTimeLeft[MOD_DIZZY]) {
	sprintf(str,"Dizzy %d sec",(int)player->modTimeLeft[MOD_DIZZY]);
	draw2DString(infoFont,str,screenWidth-120,20+nMods*18,255,64,64); 
	nMods++;
  }
  if(player->modTimeLeft[MOD_FROZEN]) {
	sprintf(str,"Frozen %d sec",(int)player->modTimeLeft[MOD_FROZEN]);
	draw2DString(infoFont,str,screenWidth-120,20+nMods*18,255,64,64); 
	nMods++;
	}*/


  /*
  sprintf(str,"In the air: %d",player->inTheAir);
  draw2DString(infoFont,str,screenWidth-120,20,64,255,255); 
  sprintf(str,"velocity[2]=%f",player->velocity[2]);
  draw2DString(infoFont,str,screenWidth-120,20+1*18,64,255,255); 
  sprintf(str,"gametime=%f",Game::current->gameTime);
  draw2DString(infoFont,str,screenWidth-120,20+2*18,64,255,255); 
  */



}
void MainMode::levelComplete() {
  Game::current->player1->hasWon = 1;
  gameStatus = statusLevelComplete;
  statusCount = 0.0;
}
void MainMode::showBonus() {
  char left[16][256];
  char right[16][256];
  char *left_pointers[16];
  char *right_pointers[16];
  int i,difficulty = Settings::settings->difficulty;
  Player *player=Game::current->player1;

  for(i=0;i<16;i++) {
	left_pointers[i] = &left[i][0];
	right_pointers[i] = &right[i][0];
  }

  sprintf(left[0],"Level bonuses"); sprintf(right[0]," ");
  sprintf(left[1],"Lives left:"); sprintf(right[1],"%d x 100 = %d points",player->lives,player->lives*100);
  sprintf(left[2],"Time left:"); sprintf(right[2],"%d minutes = %d points",player->timeLeft/60,(player->timeLeft/60)*250);
  sprintf(left[3],"Difficulty:");
  sprintf(right[3],"%s = %d points",difficulty == 0 ? "easy" : (difficulty == 1 ? "normal" : "hard"),difficulty * 500);

  multiMessage(min((int)statusCount+1,4),left_pointers,right_pointers);
}
void MainMode::bonusLevelComplete() {
  gameStatus = statusBonusLevelComplete;
  strcpy(Game::current->nextLevel,Game::current->returnLevel);
}
