
/*
 * Licensed Materials - Property of IBM
 *
 * trousers - An open source TCG Software Stack
 *
 * (C) Copyright International Business Machines Corp. 2004
 *
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <string.h>

#include <gtk/gtk.h>

#undef TRUE
#undef FALSE

#include "trousers/tss.h"
#include "tsplog.h"

#include "interface.h"
#include "support.h"

/*
 * DisplayPINWindow()
 *
 * Popup the dialog to collect an existing password.
 *
 * string - buffer that the password will be passed back to caller in
 * popup - UTF-8 string to be displayed in the title bar of the dialog box
 *
 */
TSS_RESULT
DisplayPINWindow(BYTE *string, UINT32 *string_len, BYTE *popup)
{
  GtkWidget *dialog1;
  struct userdata ud;

  ud.string_len = 0;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale();
  gtk_init_check((int *)NULL, (char ***)NULL);

  LogDebug("address of string_len: %p", &ud.string_len);
  dialog1 = create_password_dialog(&ud, (char *)popup);
  gtk_widget_show(dialog1);

  gtk_main();

  if (ud.string_len) {
	  memcpy(string, ud.string, ud.string_len);
	  memset(ud.string, 0, ud.string_len);
	  free(ud.string);
  }
  *string_len = ud.string_len;

  return TSS_SUCCESS;
}

/*
 * DisplayNewPINWindow()
 *
 * Popup the dialog to collect a new password.
 *
 * string - buffer that the password will be passed back to caller in
 * popup - UTF-8 string to be displayed in the title bar of the dialog box
 *
 */
TSS_RESULT
DisplayNewPINWindow(BYTE *string, UINT32 *string_len, BYTE *popup)
{
  GtkWidget *dialog1;
  struct userdata ud;

  ud.string_len = 0;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale();
  gtk_init_check((int *)NULL, (char ***)NULL);

  LogDebug("address of string_len: %p", &ud.string_len);
  dialog1 = create_new_password_dialog(&ud, (char *)popup);
  gtk_widget_show(dialog1);

  gtk_main();

  if (ud.string_len) {
	  memcpy(string, ud.string, ud.string_len);
	  memset(ud.string, 0, ud.string_len);
	  free(ud.string);
  }
  *string_len = ud.string_len;

  return TSS_SUCCESS;
}

