/*********************************************************************************
 *  TTCN-3 Parser - A Java based TTCN-3 Parser using ANTLR
 *  Copyright (C) 2000, 2001 Testing Technologies IST GmbH
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *********************************************************************************/
/* -----------------------------------------------------------------------------
 *
 *  AUTHOR:      Theofanis Vassiliou-Gioles
 *  DATE:        August, 2000
 *
 *  REVISION INFO:
 *	$Revision: 1.10 $ $Date: 2000/12/24 12:49:48 $
 *
 * -----------------------------------------------------------------------------
 */
import antlr.collections.AST;
import antlr.*;
import java.io.IOException;
import java.io.PrintWriter;

/** ColumnAST node implementation */
public class ColumnAST extends CommonAST {

    protected 		int 	_col;
    protected 		int 	_endCol;
    protected 		int	 _line;
    protected 		int 	_endLine;

    public ColumnAST() {
	super();
	_line = 0;
	_col = 0;
    }

    public ColumnAST(Token tok) {
	super(tok);
	initialize(tok);
    }
    
    public void initialize(int t, String txt) {
	setType(t);
	setText(txt);
	_line = 0;
	_col = 0; 
   }

    public void initialize(AST t) {
	setText(t.getText());
	setType(t.getType());
	if( (t instanceof ColumnAST))
	{
	    ColumnAST cAst = (ColumnAST) t;
	    _line = cAst._line;
	    _col  = cAst._col; 
	    _endCol  = cAst._endCol; 
	}
	else
	{
	    _line = 0;
	    _col = 0;
	    _endCol = 0;
	}
	return;
    }

    public void initialize(Token tok) {
	setText(tok.getText());	
	setType(tok.getType());
	_line = tok.getLine();
	_col = tok.getColumn();
	_endCol = tok.getColumn() + tok.getText().length();
    }


    public int getColumn() {
	return _col; 
    }

    public int getEndColumn() {
	return _endCol; 
    }

    public int getEndLine() {
	return _endLine; 
    }
  
    public int getLine() { 
	return _line; 
    }

    public void setColumn(int c) { 
	_col=c; 
    }

    public void setLine(int l) { 
	_line=l; 
    }

    public void setLocation(int l, int c)
    {
	_line=l; 
	_col=c; 
    }

    public void setLocation(ColumnAST mtok)
    {
	try {
	    _line = mtok.getLine();
	    _col  = mtok.getColumn();
	    _endCol = mtok.getColumn();
	    _endLine = mtok.getLine();
	} catch (NullPointerException nex)
	{
	    // sometimes it may happen, that mtok is null. Handling
	    // this in the grammer creates a lot of overhead
	    return;
	}
    }

    public void setEndLocation(ColumnAST tok)
    {
	try {
	    _endCol = tok.getColumn() + tok.getText().length();
	    _endLine = tok.getLine();
	} catch (NullPointerException nex)
	{
	    // sometimes it may happen, that mtok is null. Handling
	    // this in the grammer creates a lot of overhead
	    return;
	}
	
    }

    public void setLocationEnd(ColumnAST tok)
    {
	try {
	    _endCol = tok.getEndColumn();
	    _endLine = tok.getEndLine();
	} catch (NullPointerException nex)
	{
	    // sometimes it may happen, that mtok is null. Handling
	    // this in the grammer creates a lot of overhead
	    return;
	}
	
    }

    public void setLocation(ColumnAST startTok, ColumnAST endTok)
    {
	try {
	    _line = startTok.getLine();
	    _col  = startTok.getColumn();
	    _endCol = endTok.getEndColumn();
	    _endLine = endTok.getLine();
	} catch (NullPointerException nex)
	{
	    // sometimes it may happen, that mtok is null. Handling
	    // this in the grammer creates a lot of overhead
	    return;
	}
    }

     public String toString()
     {
 	return "["+getText() + "," + getText().length() + ":" + getLine() + "."+ getColumn() + "]";
     }


}
