/*********************************************************************************
 *  TTCN-3 Parser - A Java based TTCN-3 Parser using ANTLR
 *  Copyright (C) 2000, 2001 Testing Technologies IST GmbH
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *********************************************************************************/
/* -----------------------------------------------------------------------------
 *  DESCRIPTION: A Parser for pretty printing (emacs-form) errors
 *
 *  AUTHOR:      Theofanis Vassiliou-Gioles
 *  DATE:        October, 2000
 *
 *  REVISION INFO:
 *      $Revision: 1.5 $ $Date: 2001/06/22 17:05:31 $
 *
 * -----------------------------------------------------------------------------
 */

import antlr.TokenBuffer;
import antlr.RecognitionException;
import antlr.TokenStream;

public class P extends TTCN3Parser
{
    protected boolean errorOccured = false;

    protected P(TokenBuffer tokenBuf, int k) {
	super(tokenBuf,k);
    }

    public P(TokenBuffer tokenBuf) {
	this(tokenBuf,3);
    }

    protected P(TokenStream lexer, int k) {
	super(lexer,k);
    }

    public P(TokenStream lexer) {
	this(lexer,3);
    }

    
    public void reportError(RecognitionException ex)
    {
	if(ex != null)
	{
	    System.out.println(ex.getFilename()+ ":" + ex.getLine()+":"+ ex.getColumn()+":" + (ex.getMessage().equals("null")?"EOF":ex.getMessage()));
	}
	errorOccured = true;
    }

    /** Parser error-reporting function ---- by elt  */
    public void reportError(String s)
    {
        System.out.println("HOHOHOHOHO");

    }           
}
