<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_show
 * @package bug
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'bug.pinc';
 include_once 'timetrack.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bugtracking","show");
 loadmodule("bugtracking");

 /**
  * display a bug
  */
 class bug_show extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $tutos,$lang;

     $base = $tutos[base].'/php/';

     $this->assign('title',
		   sprintf($lang['Showing'],
			   $lang['Bug']." ".$this->obj->getFullName()));

     $this->assign('creator',
		   array('label' => $lang['createdby'],
			 'link'  => $base.$this->obj->creator->getUrl(),
			 'value' => $this->obj->creator->getFullName(),
			 'title' => $this->obj->creator->getFullName()));

     $this->assign('creation',
		   array('label' => $lang['atDateTime'],
			 'value' => $this->obj->creation->getDateTime()));

     $this->assign('id',
		   array('label' => $lang['BugID'],
			 'value' => $this->obj->name));

     /**
      * Bug Solver
      *
      * If the bug state is SOLVED or CLOSED, the real solver is not
      * the current one but the one responsible for the last status
      * change.
      *
      * Please see bug.pinc::getSolver() function.
      */
     if( $this->obj->state == BUG_STATE_SOLVED) {
       $label  = $lang['BugSolvedBy'];
       $solver = $this->obj->getSolver();

       $this->assign('solver',
		     array('label' => $label,
			   'link'  => $base.$solver->getUrl(),
			   'title' => $solver->getFullName(),
			   'value' => $solver->getFullName()));
     }
     else if($this->obj->state == BUG_STATE_CLOSED) {
       $label = $lang['BugClosedBy'];
       $solver = $this->obj->getSolver(BUG_STATE_CLOSED);

       $this->assign('solver',
		     array('label' => $label,
			   'link'  => $base.$solver->getUrl(),
			   'title' => $solver->getFullName(),
			   'value' => $solver->getFullName()));
     }
     else {
       $label = $lang['BugAssignedTo'];

       if( $this->obj->solver->id > 0 )
	 $this->assign('solver',
		       array('label' => $label,
			     'link'  => $base.$this->obj->solver->getUrl(),
			     'title' => $this->obj->solver->getFullName(),
			     'value' => $this->obj->solver->getFullName()));
       else
	 $this->assign('solver',
		       array('label' => $label, 'value' => 'not solved'));
     }

     $this->assign('solved', 
		   array('label' => $lang['atDateTime'],
			 'value' => $this->obj->solvedate->getDateTime()));

     if ( $this->obj->parent->id > 0 )
       $this->assign('parent',
		     array('label' => $lang[$this->obj->parent->getType()],
			   'link'  => $base.$this->obj->parent->getUrl(),
			   'title' => $this->obj->parent->getFullName(),
			   'value' => $this->obj->parent->getFullName()));
     else
       $this->assign('parent',
		     array('label' => $lang['ProductP'],
			   'value' => $lang['HistoryDeleted']));

     $this->assign('state',
		   array('label' => $lang['BugState'],
			 'value' => 
			 array('label' => $this->obj->state,
			       'value' =>
			       $lang['BugStates'][$this->obj->state])));

     $this->assign('class',
		   array('label' => $lang['BugClass'],
			 'value' =>
			 array('label' => $this->obj->class,
			       'value' => 
			       $lang['BugClasses'][$this->obj->class])));

     $this->assign('desc',
		   array('label' => $lang['BugShort'],
			 'value' => $this->obj->short));

     if( $this->user->feature_ok(usetimetrack, PERM_SEE) ) {
       $this->obj->readTimetrackSum();
       if ( $this->obj->timetracksum > 0) {
	 $this->assign('timetrack', 
		       array('label' => $lang['Timetrack'],
			     'link'  => $base."timetrack_overview.php?link_id=". $this->obj->id,
			     'title' => $lang['TimetrackOverview'],
			     'value' =>
			     number_format($this->obj->timetracksum, 2)
			     ."&nbsp;".$lang['hours']));
			     
       }
     }

     // Bug History
     $history = $this->obj->prepare_history($this->order == "reverse");

     // $this->debug($history);
     $this->assign('history',
		   array('label' => $lang['BugHistory'],
			 'value' => $history));

     $this->assign('BugClass',      $lang['BugClass']);
     $this->assign('BugState',      $lang['BugState']);
     $this->assign('BugAssignedTo', $lang['BugAssignedTo']);
     $this->assign('BugCreator',    $lang['BugCreator']);
     $this->assign('Date',          $lang['Date']);
     $this->assign('hours',         $lang['hours']);

     $this->template('bugtracking/bug_show');

     /**
      * TODO
      show_module_infolists($this->user,$this->obj,4,$this->format);
     */
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$current_user;

     $this->name = $lang['BugsDetail'];
     $this->obj = new bug($this->dbconn);

     $this->order = "reverse";
     if( isset($_GET['order']) && $_GET['order'] == "chrono" )
       $this->order = $_GET['order'];
     $this->assign('order', $this->order);

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->obj->read_bughistory();

       $this->assign('bid', $_GET['id']);
     }
     else {
       $msg .= $lang['Err0048'] ."<br>";
       $this->stop = true;
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     else {
       $this->name .=": ". $this->obj->getFullName();
     }

     // menu
     $x = bug::getSelectLink($this->user, $lang['Search']);
     // $x['image'] = 'search';
     $this->addmenu($x);

     $x = array('url'   =>
		"bugtracking/bug_overview.php?pid=".$this->obj->parent->id,
		'text'  => $lang['BugsOverview'],
		'image' => 'bugs',
		'info'  => $lang['BugsOverview'],
		'category' => array("bug","new","obj")
		);
     $this->addMenu($x);


     if ( $this->user->feature_ok(usebugtracking,PERM_NEW) ) {
       // Pre select the same project as the one of the current bug
       $x = array('url'   =>
		  "bugtracking/bug_new.php?pid=".$this->obj->parent->id,
                  'text'  => $lang['NewEntry'],
		  'image' => 'new',
                  'info'  => $lang['CreateNewBug'],
                  'category' => array("bug","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array('url'   => $this->obj->getModURL(),
                  'text'  => $lang['Modify'],
		  'image' => 'modify',
                  'info'  => sprintf($lang['BugModifyI'],
				     $this->obj->getFullname()),
                  'category' => array("bug","mod","obj")
                 );
       $this->addMenu($x);

       $x = array( 'url'   => "acl_show.php?id=".$this->obj->id,
                   'text'  => $lang['AclDetail'],
		   'image' => 'acls',
                   'info'  => sprintf($lang['AclDetailI'],
				      $this->obj->getFullname()),
                   'category' => array("acl","obj")
                 );
       $this->addMenu($x);
     }

     $x = timetrack::getaddlink($this->user,$this->obj);
     $this->addMenu($x);

     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     // $this->addtohistory();
     web_StackStartLayoutObj($this);
   }
 }

 $l = new bug_show($current_user);
 $l->display();

 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: bug_show.php,v 1.4.2.10 2005/02/08 15:21:13 tapoueh Exp $
    $Author: tapoueh $
-->