<!--
  Stylesheet to convert Pump.io activity streams to RSS.

  Copyright (C) 2013-2014  Antonio Ospite <ao2@ao2.it>

  This file is part of tweeper.

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<!-- To Evan, please reconsider publishing RSS ouput for _public_ contents -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:php="http://php.net/xsl"
    xsl:extension-element-prefixes="php">

    <xsl:output method="xml" indent="yes"/>

    <xsl:variable name="domain-name" select="substring-after(//div[@id='profile-block']/@data-profile-id, '@')"/>
    <xsl:variable name="BaseURL" select="concat('https://', $domain-name)"/>

    <xsl:variable name="user-name" select="substring-after(//div[@id='profile-block']/@data-profile-id, ':')"/>

    <xsl:template match="//div[@id='user-content-activities']//ul[@id='major-stream']/li">
        <xsl:variable name="activity-text" select=".//div[@class='activity-content']"/>
        <item>
            <title>
                <xsl:value-of select="concat($user-name, ': ', normalize-space($activity-text))"/>
            </title>
            <link>
                <xsl:value-of select=".//p[@class='muted']/small/a/@href"/>
            </link>
            <pubDate>
                <xsl:value-of select="php:functionString('Tweeper::str_to_gmdate', .//abbr[@class='easydate']/@title)"/>
            </pubDate>
            <description>
                <xsl:value-of select="concat($user-name, ': ')"/>
                <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                <xsl:copy-of select="$activity-text/node()"/>
                <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
            </description>
        </item>
    </xsl:template>

    <xsl:template match="/">

        <rss version="2.0">
            <xsl:attribute name="xml:base"><xsl:value-of select="$BaseURL" /></xsl:attribute>
            <channel>
                <generator>Tweeper</generator>
                <title>
                    <xsl:value-of select="concat(substring-after($user-name, '@'), ' / ', substring-before($user-name, '@'))"/>
                </title>
                <link>
                    <xsl:value-of select="concat('https://', substring-after($user-name, '@'), '/', substring-before($user-name, '@'))"/>
                </link>
                <description>
                    <xsl:value-of select="normalize-space(//h1[@class='media-header'])"/>
                </description>
                <image>
                    <url>
                        <xsl:value-of select="//div[@id='profile-block']/span/img[@class='img-rounded media-object']/@src"/>
                    </url>
                </image>
                <xsl:apply-templates select="//div[@id='user-content-activities']//ul[@id='major-stream']/li"/>
            </channel>
        </rss>
    </xsl:template>
</xsl:stylesheet>
