<?php
 // 
 //  filename:	oracle.db.inc.php3
 //  author:	christoph klein - christoph.klein@ucpag.com
 //  comment:	database layer twig -> oracle
 //

 // start class db_oracle
 class db_oracle
	{
    	var $ResultSet; 	// stores the whole result set in an array 
    	var $NumRows; 		// number of rows in the array
    
    	// constructor
    	Function db_oracle( $ResultSetI, $NumRowsI )
    		{
		$this->ResultSet = $ResultSetI;
		$this->NumRows = $NumRowsI;
		}
    
    	// returns one specific field ($Field, name or number) from row $RowNum
    	Function ORA_Result( $RowNum, $Field )
    		{
		reset( $this->ResultSet );

		$j = 0;			// column counter
	
		while( list( $key, $value ) = each( $this->ResultSet ) ) 
    			{
    	    		$j++;

			// if the column number or the fieldname is right...
		   	if( ( $j == $Field ) || ( strtolower( $key ) == strtolower( $Field ) ) )		
		   		{
				// ... and there's a reasonable value for the row number...
		       		if( $RowNum <= $this->NumRows )
		        		{
    			    		return $value[$RowNum];
					// ...return the content of the field 
    					}
	        		}
			}
		}
    
    	// returns the number of rows in the resultset
    	Function ORA_NumRows()
    		{
    		return $this->NumRows;
    		}
    
	// returns a speciffic ($RowNum) row of the resultset as an array 
	Function ORA_ResultArray( $RowNum )
    		{
		$j = 0;
		reset( $this->ResultSet );

		while( list( $key, $value ) = each( $this->ResultSet ) ) 
    			{
			// 	as oracle returns all fieldnames uppercase, we have to do this
			//	little strtolower-hack to ensure that everyone can read out the
			//	values.	
			$ret[$key] = $value[$RowNum];
			$ret[strtolower( $key )] = $value[$RowNum];
			$ret[$j] = $value[$RowNum];

			$j++;
  			}

	   	return $ret;
		}
	}
 // end class db_oracle

 Function TWIGProcessSQLString( $string )
	{
	global $config;

	if( !$config["GMQRUN"] ) { $config["GMQRUN"] = get_magic_quotes_runtime() + 1; }

	if( $config["GMQRUN"] == 2 )
		{
		return stripslashes( $string );
		}
	else
		{
		return $string;
		}
	}

 Function SQLString( $string ) 
	{
	$string = addslashes( $string );

  	return $string;
 	}

 Function createSqlDate( $year, $month, $day ) 
	{
   	return sprintf( "%04d%02d%02d", $year, $month, $day );
 	}

 Function createSqlDateTime( $year, $month, $day, $hour, $min, $sec ) 
	{
   	return sprintf( "%04d%02d%02d%02d%02d%02d", $year, $month, $day, $hour, $min, $sec );
 	}

 Function convertUTimetoSQLTime( $utime )
	{
	$fields = explode( " ", date( "Y m d H i s", $utime ) );

   	return createSqlDateTime( $fields[0], $fields[1], $fields[2], $fields[3], $fields[4], $fields[5] );
	}

 Function convertSQLTimetoUTime( $sqldate ) 
	{
   	return( mktime( substr( $sqldate, 8, 2 ), substr( $sqldate, 10, 2 ), substr( $sqldate, 12, 2 ), substr( $sqldate, 4, 2 ), substr( $sqldate, 6, 2 ), substr( $sqldate, 0, 4 ) ) );
 	}

 Function MakeInsertString( $data ) 
	{
  	while( list( $key, $val ) = each( $data ) ) 
		{
    		if( $val != "--remove" ) 
			{
      			$fields[] = $key;
	  		$values[] = "'" . SQLString( $val ) . "'";
			}
  		}

  	$string["fields"] .= implode( ", ", $fields );
  	$string["values"] .= implode( ", ", $values );

  	return $string;
 	} 

 Function MakeUpdateString ($data) 
	{
  	while( list( $key, $val ) = each( $data ) ) 
		{
	    	$temp[] = $key . " = '". SQLString( $val ) . "'";
   		}
  	
	$strings .= implode( ", ", $temp );

  	return $strings;
 	}

 Function dbQuery( $statement ) 
	{
	GLOBAL $dbconfig;
	
	$conn = OCILogon( $dbconfig["sqlusername"], $dbconfig["sqlpassword"], $dbconfig["defaultdb"] );
	$stmt = OCIParse( $conn, $statement );

	OCIExecute( $stmt );
	
	// if it's a 'select' statement, we must not fetch the result set
	if( strpos( strtolower( $statement ), "elect", 1) > 0 )
		{
    		$nrows = OCIFetchStatement( $stmt, $results );
		}

	// create _new_ db_oracle object
	$ret = new db_oracle( $results, $nrows );
  
 	OCIFreeStatement( $stmt );
 	OCILogoff( $conn );
	
	return $ret;
	}

 Function dbResult( $result, $i, $field ) 
	{
	return $result->ORA_Result( $i, $field );
	}

 Function dbNumRows( $result ) 
	{
	return $result->ORA_NumRows();
	}

 Function dbResultArray( $result, $i ) 
	{
	return $result->ORA_ResultArray( $i );
	}

 Function dbLastInsertID( $result, $table )
 	{
	if( !$table ) { return ""; }

	$sql = "SELECT ROWIDTOCHAR(ROWID) FROM $table";
	$res = dbQuery( $sql );
	$ret = dbResultArray( $res, 0 );
	return $ret[0];
	}

 Function dbStoreBLOB( $table, $id, $field, $blob )
 	{
	$sql = "UPDATE $table SET $field = '" . addslashes( $blob ) . "' WHERE id = '$id'";
	$res = dbQuery( $sql );
	return $res;
	}

 Function dbRetrieveBLOB( $table, $id, $field, $blob = "" )
 	{
	$sql = "SELECT $field FROM $table WHERE id = '$id'";
	$res = dbQuery( $sql );
	if( dbNumRows( $res ) == 1 )
		{
		$ret = dbResultArray( $res, 0 );
		return $ret[$field];
		}
	elseif( dbNumRows( $res ) < 1 )
		{
   		TWIGPrintError( "dbRetrieveBLOB: no rows found matching id '$id' in table '$table'" );
		}
	elseif( dbNumrows( $res ) > 1 )
		{
   		TWIGPrintError( "dbRetrieveBLOB: id '$id' was not unique in table '$table'" );
		}
	return FALSE;
	}

?>
