<?php

Function SQLTXTParseUpdate( $string )
	{
	$string = str_replace( "(", "", $string );
	$string = str_replace( ")", "", $string );
	$string = str_replace( "'", "", $string );

	$mtemp = split( ",", $string );

	$j = count( $mtemp );

	for( $i = 0; $i < $j; $i++ )
		{
		$stemp = split( "=", $mtemp[$i] );
	
		$ret[0][$i] = trim( $stemp[0] );
		$ret[1][$i] = trim( $stemp[1] );
		}

	return $ret;
	}

Function SQLTXTParseFields( $string, $fnames )
	{
	$string = str_replace( "(", "", $string );
	$string = str_replace( ")", "", $string );
	$string = str_replace( "'", "", $string );

	$new = trim( $string );

	if( $new == "*" )
		{
		return $fnames;
		}
	
	$breakout = split( ",", $new );

	$j = count( $breakout );
	
	for( $i = 0; $i < $j; $i++ )
		{
		$new = trim( $breakout[$i] );

		if( $new ) { $ret[] .= $new; }
		}

	return $ret;
	}

Function SQLTXTParseValues( $string )
	{
	$string = str_replace( "(", "", $string );
	$string = str_replace( ")", "", $string );
	$string = str_replace( "'", "", $string );

	$new = trim( $string );

	$breakout = split( ",", $new );

	$j = count( $breakout );

	for( $i = 0; $i < $j; $i++ )
		{
		$new = trim( $breakout[$i] );

		$ret[$i] = $new; 
		}

	return $ret;
	}

Function SQLTXTCheckConditions( $dbname, $dbrec, $conditions, $dbfieldnames )
	{
	$connum = count( $conditions );
		
	$results = array();
	$delit = 0;
	$stop = 0;

	for( $j = 0; $j < $connum; $j++ )
		{
		if( $conditions[$j][0] != "AND" && $conditions[$j][0] != "OR" )
			{
			$stop = 0;
			$x = trim( $dbrec[$dbfieldnames[$dbname][2][$conditions[$j][0]] - 1] );
			$y = $conditions[$j][2];

			switch( $conditions[$j][1] )
				{
				case "=":
					if( $x != $y )
						{
						$stop = 1;
						}
					break;
				case "<":
					if( $x > $y )
						{
						$stop = 1;
						}
					break;
				case ">":
					if( $x < $y )
						{
						$stop = 1;
						}
					break;
				}

				if( !$stop ) { $results[$j] = 0; } else { $results[$j] = 1; }
			}
		else
			{
			$results[$j] = $conditions[$j][0];
			}
		}

	$l = count( $results );

	for( $k = 0; $k < $l; $k++ )
		{
		$results[$k] = trim( str_replace( "\n", "", $results[$k] ) );
		}

	$delit = 0;
	if( $l > 2 )
		{
		for( $k = 0; $k < $l; $k++ )
			{
			if( $results[$k] == "OR" )
				{
				if( $results[$k-1] == 0 || $results[$k+1] == 0 )
					$delit = 1;
				}
				
			if( $results[$k] == "AND" )
				{
				if( $results[$k-1] == 0 && $results[$k+1] == 0 )
					$delit = 1;
				}
			}
		}
	else
		{
		$delit = !$results[0];
		}

	return $delit;
	}

Function SQLTXTParseEQ( $string )
	{
	if( !$string ) { return FALSE; }
		
	$breakdown = split( " ", $string );

	$j = count( $breakdown );

	$x = "";
	$con = "";
	$y = "";

	for( $i = 0; $i < $j; $i++ )
		{
		if( $breakdown[$i] )
			{
			if( !$x ) 
				{ 
				$x = trim( $breakdown[$i] ); 
				}
			elseif( !$con && ( $x != "AND" && $x != "OR" ) )
				{
				$con = trim( $breakdown[$i] );
				}
			elseif( !$y && ( $x != "AND" && $x != "OR" ) )
				{
				$y = str_replace( "\'", "", $breakdown[$i] );
				}
			else
				{
				$ret[] = array( $x, $con, $y );
	
				$x = trim( $breakdown[$i] );
				$con = "";
				$y = "";
				}
			}	

		}

	if( $x && $con && $y ) 
		{
		$ret[] = array( $x, $con, $y );
		}

	return $ret;
	}

Function SQLTXTParse( $SQLList )
	{
	$SQLArgs = array( "FROM"=>"1", "WHERE"=>"1", "ORDER"=>"1", "DESC"=>"0", "SELECT"=>"1", "INSERT"=>"0", "UPDATE"=>"1", "DELETE"=>"0", "VALUES"=>"1", "SET"=>"1", "INTO"=>"1", "ORDER"=>"1" );
	$SQLC = array( "FROM"=>"1", "WHERE"=>"1", "ORDER"=>"1", "DESC"=>"1", "SELECT"=>"1", "INSERT"=>"1", "UPDATE"=>"1", "DELETE"=>"1", "VALUES"=>"1", "SET"=>"1", "INTO"=>"1" );

	$SQLBreakOut = array( "SELECT" => " ", "FROM" => " ", "WHERE" => " ", "AND" => " ", "OR" => " ", "ORDER" => " " );

	$temp = "";

	for( $i = 0; $i < count( $SQLList ); $i ++ )
		{
		$next = trim( $SQLList[$i] );

		if( $SQLC[strtoupper($next)] )
			{
			$temp = "";
			$CurrentCMD = strtoupper($next);

			if( $SQLArgs[strtoupper($next)] == "0" )
				{
				$SQLBreakOut[$CurrentCMD] = $next;
				}
			}
		else
			{
			$SQLBreakOut[$CurrentCMD] .= " " . $next;
			}
		}

	return $SQLBreakOut;
	}

Function SQLTXTInsert( $dbpath, $SQLList )
	{
	$key = SQLTXTParse( $SQLList );

	return( SQLTXTDBInsert( $dbpath, $key ) );
	}

Function SQLTXTDelete( $dbpath, $SQLList )
	{
	$key = SQLTXTParse( $SQLList );

	return( SQLTXTDBDelete( $dbpath, $key ) );
	}

Function SQLTXTUpdate( $dbpath, $SQLList )
	{
	$key = SQLTXTParse( $SQLList );

	return( SQLTXTDBUpdate( $dbpath, $key ) );
	}

Function SQLTXTSelect( $dbpath, $SQLList )
	{
	$key = SQLTXTParse( $SQLList );

	return( SQLTXTDBSelect( $dbpath, $key ) );
	}

Function SQLTXTQuery( $dbpath, $SQLCommand )
	{
	$sqlsplit = split( " ", $SQLCommand );

	$thisitem = current( $sqlsplit );

	switch( strtoupper( $sqlsplit[0] ) )
		{
		case "INSERT":
			$ret = SQLTXTInsert( $dbpath, $sqlsplit );
			break;
		case "DELETE":
			$ret = SQLTXTDelete( $dbpath, $sqlsplit );
			break;
		case "UPDATE":
			$ret = SQLTXTUpdate( $dbpath, $sqlsplit );
			break;
		case "SELECT":
			$ret = SQLTXTSelect( $dbpath, $sqlsplit );
			break;
		}

	return $ret;
	}

Function SQLTXTFetchArray( $result, $row )
	{
	$j = count( $result[0]["fieldnames"] );
	
	$row++;

	for( $i = 0; $i < $j; $i++ )
		{
		$ret[$result[0]["fieldnames"][$i]] = trim($result[$row][$result[0]["fieldnames"][$i]]);
		$ret[$i] = trim($result[$row][$result[0]["fieldnames"][$i]]);
		}

	return $ret;
	}

Function SQLTXTResult( $result, $row, $field )
	{
	$row++;
	return trim($result[$row][$field]);
	}

Function SQLTXTNumRows( $result )
	{
	return $result[0]["numrecs"];
	}
?>
