<?php
 	/*
     	Name: securecookie.php4session.login.php3
     	Type: One time pad login handler for TWIG
     	Desc: Securely stores the login/password informations on both sides through OTP
     	Originally by: Xavier Roche/Serianet, Oct/2000

     	KNOWN PROBLEMS: There seems to be strange session problems (session disconnection) when 
     	using session_set_cookie_params, or other time/path related session functions
     	These problems might be related to some PHP4 old versions (to check)
     	If these problems occurs, define $use_session_settings to false
 	*/

 	$use_session_settings = true;	/* Use session timeout/path */
	$global_secure_key = "";

 	if( !session_name() )
		{
	  	/* Start the session */
  		if( $use_session_settings ) { session_set_cookie_params( $config["auth_timeout"], $config["basedir"], $config["fromdomain"] ); }

	  	session_start();
		}

	/* Some useful functions */

  	/* XOR between two strings - $b is the key */
  	Function strxor( $a, $b ) 
		{
	    	$c = ""; 
		$alen = strlen( $a ); 
		$blen = strlen( $b );

    		for( $i = 0; $i < $alen; $i++ )
			{
			$c .= chr( ( ord( $a[$i] ) ) ^ ( ord( $b[$i % $blen] ) ) );
			}
	
		return $c;
  		}
  	
  	/* generate a random string (length $len) */
  	Function randomstr( $len ) 
		{
	    	$c = "";

    		for( $i = 0; $i < $len; $i++ )
			{
	      		$c .= chr( rand( 0, 255 ) );
			}

		return $c;
  		}

	/* A random key */
  	Function randomkey( $len ) 
		{
    		srand( ( double )microtime() * 1000000 );

    		return randomstr( $len );
  		}

  	/* cypher (otpcrypt) / decypher (otpdecrypt) */
  	Function otpcrypt( $data, $key ) 
		{
	    	/* First add noise so that the len can not be determined precisely */
    		$data .= chr( 0 );
	        $data .= randomstr( rand( 1, 8 ) );

    		/* Then xor */
	    	return strxor( $data, $key );
  		}

  	Function otpdecrypt( $data, $key ) 
		{
	    	/* Decypher */
    		$data = strxor( $data, $key );

	    	/* Denoise */
    		$data = substr( $data, 0, strpos( $data, chr( 0 ) ) );

	    	return $data;
  		}
  
	/* encode (convbinarytoascii) / decode (convasciitobinary) binary content */
  	Function convbinarytoascii( $data ) 
		{
    		return base64_encode($data);
  		}

  	Function convasciitobinary( $data ) 
		{
    		return base64_decode( $data );
	  	}

	/* Now the TWIG Login handler itself */

	/* Retreive login informations */
	Function TWIGGetLogin() 
		{
    		GLOBAL $twig_cookieauth, $config, $twig_serverauth, $global_secure_key;

	    	$login = array();
    		$login["username"] = "";
	    	$login["password"] = "";

    		if( strlen( $twig_serverauth ) > 0 ) 
			{
	      		if( strlen( $twig_cookieauth ) > 0 ) 
				{
        			$key = convasciitobinary( stripslashes( $twig_cookieauth ) );

        			if( strlen( $key ) > 0 ) 
					{
	          			$edata = convasciitobinary( stripslashes( $twig_serverauth ) );
        	  			$data = otpdecrypt( $edata, $key );
					$global_secure_key = $key; 

          				if( strlen( $data ) > 0 ) 
						{
            					$chr1pos = strpos( $data, chr( 1 ) );

            					if( $chr1pos > 0 ) 
							{
        	      					$login["username"] = substr( $data, 0, $chr1pos );
	              					$login["password"] = substr( $data, $chr1pos + 1 );
            						}
          					}
        				}
	      			}
    			}

	    	return $login;
  		}

	/* Store login informations */
	Function TWIGStoreLogin( $username, $password, $expire, $delete = 0 ) 
		{
    		GLOBAL $config, $dbconfig, $disabled, $twig_serverauth, $use_session_settings, $global_secure_key, $config_dir, $vhosts, $SERVER_NAME;

	    	$dir = $config["basedir"];
    		if( $dir == "" ) { $dir = "/"; }

	    	if( !$use_session_settings )
			{
			$dir="/";  // debug -xxc-
			}

    		if( $delete ) 
			{
	      		SetCookie( "twig_cookieauth", "", 0, $dir );
      			session_unregister( "twig_serverauth" );
    			} 
		else 
			{
      			$query = "SELECT laston FROM " . $dbconfig["accounts_table"] . " WHERE username='" . $username . "'";
	      		$result = dbquery( $query );

      			if( dbnumrows( $result ) > 0 ) 
				{
        			$query = "UPDATE " . $dbconfig["accounts_table"] . " SET laston='" . time() . "' WHERE username='" . $username . "'";
	        		$result = dbquery( $query );
      				} 
			else 
				{
	        		if( !$disabled["autoaccounts"] ) 
					{
          				$query = "INSERT INTO " . $dbconfig["accounts_table"] . " (username,laston) VALUES ('" . $username . "','" . time() . "')";
          				$result = dbquery( $query );
 
          				$TWIGNewUserGroups = array();

					if( $vhosts[$SERVER_NAME] && is_readable($vhosts[$SERVER_NAME] . "newusergroups.inc.php3") ) {include($vhosts[$SERVER_NAME] . "newusergroups.inc.php3");}
					else {include($config_dir . "newusergroups.inc.php3");}
 
        	  			for( $i = 0, $j = count( $TWIGNewUserGroups ); $i < $j; $i++ ) 
						{
            					TWIGSYSAddACLGroupMember( $username, $TWIGNewUserGroups[$i] );
          					}
	        			}
      				}

      			/* Generate a mask and store the result */
	      		$data = $username . chr(1) . $password;

			if( !$global_secure_key )
				{
        			$key = randomkey( strlen( $data ) );
				}
			else
				{
			        $key = $global_secure_key;
				}

      			$twig_serverauth = convbinarytoascii( otpcrypt( $data, $key ) );

	      		Session_register( "twig_serverauth" );

      			/* Store the mask */
      			if( $expire <= 0 ) 
				{
        			SetCookie( "twig_cookieauth", convbinarytoascii( $key ), 0 , $dir );
      				} 
			else 
				{   
        			if( $use_session_settings )
					{
          				SetCookie( "twig_cookieauth", convbinarytoascii($key), time() + $expire, $dir );
					}
				else
					{
					SetCookie( "twig_cookieauth", convbinarytoascii($key), 0, $dir );
      					}
	    			}
			}
	  	}	
?>
