#ifndef OBJECTBASE_HH
#define OBJECTBASE_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------

#include "VHDLData.hh"
#include "Types.hh"
#include "iostream.h"
#include <fstream.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

class VHDLType;
class VHDLKernelBase;

// The following class is the base class for the Signal and Variables.
// Any Type is going to have a pointer to this, so that a Type can have any
// object
//
class ObjectBase {
public:
  //Enum types to specify the type of object being instantiated
  enum ObjectType {SIGNAL, IMPLICIT_SIGNAL, VARIABLE, SIGNAL_NETINFO};

  ObjectBase() {
    parentCompositeType = NULL;
  }
  virtual ~ObjectBase(){}
  //Any object of the ObjectType has to override the following functions
  virtual const VHDLData& readVal() const = 0;
  virtual void updateVal(const VHDLData&) = 0;
  virtual ObjectBase& operator=(const ObjectBase&) {
    cerr << " ERROR  ObjectBase::operator=(const ObjectBase&) called" << endl;
    abort();
    return *this;
  }
  
  virtual void print(ostream&) const = 0;
  virtual ObjectType getKind() const = 0;
  virtual ObjectBase& operator=(VHDLData&) {
    return *this;
  }
  // This method creates another object of the same type as itself.
  virtual ObjectBase* clone() const = 0;

  virtual void setResolutionFunctionId(int) {
    cerr << " ERROR  ObjectBase::setResolutionFunctionId(int) called" << endl;
    abort();
  }

  virtual void setTypeConversionFunctionId(int) {
    cerr << " ERROR  ObjectBase::setTypeConversionFunctionId(int) called" << endl;
    abort();
  }

  virtual void setElaborationInfo(ObjectBase&) {
    cerr << "ERROR ObjectBase::setElaborationInfo(ObjectBase&) called" << endl;
    abort();
  }

  virtual void setNumAttributes(int ) {
    cerr << "ERROR ObjectBase::setNumAttributes(int) called" << endl;
    abort();
  }

  virtual void setAttrib(AttribType ,VHDLType& ) {
    cerr << "ERROR ObjectBase::setAttrib(AttribType, VHDLType&) called" << endl;
    abort();
  }

  virtual bool _is_signal() const { return false; }
  virtual void setBusKind() { 
    cerr << "ERROR ObjectBase::setBusKind() called" << endl;
  }

  VHDLType* parentCompositeType;

  virtual VHDLType* resolve(VHDLKernelBase*) { return NULL; }

  virtual VHDLType* getParentCompositeType() {
    return parentCompositeType;
  }

  virtual void setParentCompositeType(VHDLType* ptr) {
    parentCompositeType = ptr;
  }

  virtual void setCompositeResolvedSignal(bool) {
    cerr << "ERROR: ObjectBase:: setCompositeResolvedSignal(bool) called " << endl;
  }

  virtual void dump_connectivity_info(ofstream&) {
    cerr << "ERROR: ObjectBase:: dump_connectivity_info(ifstream&) called" << endl;
  }

};

#endif
