#ifndef StringBase_CC
#define StringBase_CC
//---------------------------------------------------------------------------
// Copyright (c) 1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//// $Id: StringBase.cc,v 1.4 1999/03/09 22:52:16 dmartin Exp $
//---------------------------------------------------------------------------

#include "StringBase.hh"

char& StringBase::operator[](const int pos) {
#ifdef DEVELOPER_ASSERTIONS
  if (!bounds.contains(pos)) {
    cerr << "_savant_string::operator[]: bit specifier (" << pos 
	 << ") out of range--my bounds are " << bounds << endl;
    abort();
    }
#endif
  register int i = bounds.storageIndex(pos);
  return val[i];
}


/*int StringBase::getSize() const {
  return sizeof(*this);
}*/

bool StringBase:: operator!=(const VHDLData& d) const {
    StringBase bvb = *(StringBase*)&d;
    if (length() != bvb.length()) {
      return true;
    }
    else {
      for (register int i = 0; i < length(); i++) {
	if (val[i] != bvb.val[i]) {
	  return true;
	}
      }
      return false;
    }
}



// StringBase& StringBase::savantConcatenation( StringBase& lhs,  _savant_character& rhs) {
//     int length = lhs.length();
//     StringBase  *tempStr = new StringBase(0, lhs.bounds.dirn(), length);
//     int i;
  
//     int lhsLeft = lhs.bounds.left();
//     if (lhs.bounds.dirn() >  0) {
//       for (  i = 0; i < length-1; i++) {
// 	tempStr->val[i] = lhs[lhsLeft++];
//       }
//       tempStr->val[i] = rhs.val;
//     }
//     else {
//       for (  i = length; i > 0; i --) {
//      tempStr->val[i] = lhs[lhsLeft--];
//       }
//       tempStr->val[i] = rhs.val;
//   }
//     return *tempStr;
// }


// StringBase& StringBase::savantConcatenation(_savant_character& lhs,  StringBase& rhs) {
//   int length = rhs.length();
//   StringBase  *tempStr = new StringBase(0, rhs.bounds.dirn(), length);

// int rhsLeft = rhs.bounds.left();
// if (rhs.bounds.dirn() >  0) {
//   tempStr->val[0] = lhs.val;
//   for ( register int i = 1; i < length; i++) {
//     tempStr->val[i] = rhs[rhsLeft++];
//   }
// }

// else {
//   tempStr->val[length] = lhs.val;
//   for ( register int i = length-1; i >=0; i --) {
//       tempStr->val[i] = rhs[rhsLeft--];
//     }
// }

// return *tempStr;
// }


// StringBase& StringBase::savantConcatenation( _savant_character& lhs,  _savant_character& rhs) {
// StringBase *tempStr = new StringBase(0, to, 1);
// tempStr->val[0] = lhs.val;
// tempStr->val[1] = rhs.val;
// return *tempStr;
// }

//  StringBase& StringBase::savantConcatenation( StringBase& lhs,  StringBase& rhs) {
//   int lhsLeft = lhs.bounds.left();
//   int rhsLeft = rhs.bounds.left();
//   int lhsRight = lhs.bounds.right();
//   //  int rhsRight = rhs.bounds.right();
//   int lhsLength = lhs.bounds.length();
//   int rhsLength = rhs.bounds.length();
//   int totalLength = rhsLength + lhsLength;

//   register int temp1;
//   register int temp2;

//   register int i;

//   if (lhs.bounds.dirn() != rhs.bounds.dirn()) {
//     cerr << "Strings are not legal to concatenate" << endl;
//     abort();
//   }

//   //check whether left operand is a null array
//   if ((lhsLeft > lhsRight) && (lhs.bounds.dirn() > 0)
//       || (lhsLeft < lhsRight) && (lhs.bounds.dirn() < 0)) {
//     return rhs;
//     }
//     else {
//       //change rightbound
// 	StringBase *tempStr = new StringBase(0, lhs.bounds.dirn(), totalLength - 1);
//       if(lhs.bounds.dirn() >  0) {
// 	temp1 = lhsLeft;
// 	temp2 = rhsLeft;
// 	for (  i = 0; i < totalLength; i++) {
// 	  if ( i < lhsLength) tempStr->val[i] = lhs[temp1++];
// 	  else tempStr->val[i] = rhs[temp2++];
// 				}
//       }

//       else { // The value of ArrayDirn_t is -1
// 	temp1 = lhsLeft;
// 	temp2 = rhsLeft;
// 	for (i = totalLength-1; i >=0; i--)
// 	  if ( i >= rhsLength)  {
// 	    tempStr->val[i] = lhs[temp1--];
// 	  }
// 	  else { 
// 	    tempStr->val[i] = rhs[temp2--];
// 	}
//       }
//       return *tempStr;
//     }
//   }
  
#endif
