#include <iostream.h>
#include "ArrayInfo.hh"
#include "VHDLData.hh"
#include "Types.hh"
#include "STDTypes.hh"

void 
VHDLData::assignSlice(const VHDLData* D, const ArrayInfo* a1, const ArrayInfo *a2) {
  cerr << "Error: Default assignSlice called! Arguments: ";
  D->print(cerr);
  cerr << " " << a1 << endl;
  cerr << " " << a2 << endl;
  abort();
} 

void 
VHDLData::assignSlice(const VHDLData* D, const ArrayInfo* a1) {
  cerr << "Error: Default assignSlice called! Arguments: ";
  D->print(cerr);
  cerr << " " << a1 << endl;
  abort();
} 
  
VHDLData& 
VHDLData::operator=(const VHDLData& data) {
  cerr << "Error: VHDLData::operator = called!! continuing anyway" 
       << endl;
  return (VHDLData &) data;
}

int
VHDLData::savantwrite(ostrstream &) const
{
  // Control will drop here only if the type is OTHER_TYPE
  // Don't know what to do with data of that type of as of now
  // do nothing. But display a message saying that this function
  // is begin called just as a reminder.

  cerr << "WARNING:savantwrite of VHDLData called" << endl;

  return NORMAL_RETURN;
}

int
VHDLData::savantwrite(SavantlineType &) const
{
  cerr << "WARNING:savantwrite of VHDLData called" << endl;

  return NORMAL_RETURN;
}

int
VHDLData::savantread(SavantlineType &)
{
  cerr << "WARNING:savantread of VHDLData called" << endl;

  return NORMAL_RETURN;
}

int
VHDLData::savantread(char *)
{
  cerr << "WARNING:savantread of VHDLData called" << endl;

  return NORMAL_RETURN;
}
  
VHDLData*
VHDLData::clone() const
{
  // Control normally will not drop here.
  // Display warning and get out doing nothing.

  cerr << "WARNING:clone of VHDLData called" << endl;

  return NULL; // Make compiler happy
}

ostream &
operator << (ostream &os, const VHDLData &data) {
  data.print(os);
  return os;
}

bool
VHDLData::operator > (const VHDLData &data) const{
  switch(this->get_universal_kind()){
  case UNIVERSAL_INTEGER:
    return savantGreaterThan((UniversalInteger &)*this, 
			     (UniversalInteger &)data);
    break;
  case UNIVERSAL_REAL:
    return savantGreaterThan((UniversalReal &)*this, (UniversalReal &)data);
    break;
  case UNIVERSAL_LONG_LONG_INTEGER:
     return savantGreaterThan((UniversalLongLongInteger &)*this, 
			      (UniversalLongLongInteger &)data);
    break;
  case UNIVERSAL_BOOLEAN:
    return savantGreaterThan((UniversalBoolean &)*this, 
			     (UniversalBoolean &)data);
    break;
  case UNIVERSAL_CHARACTER:
    return savantGreaterThan((UniversalCharacter &)*this, 
			     (UniversalCharacter &)data);
    break;
  default:
    cerr << "operator > called with unknown VHDLData type !! " << endl;
    abort();
    return false;
    break;
  }
  
}

bool
VHDLData::operator >= (const VHDLData &data) const {
  switch(this->get_universal_kind()){
  case UNIVERSAL_INTEGER:
    return savantGreaterThanOrEqual((UniversalInteger &)*this, 
				    (UniversalInteger &)data);
    break;
  case UNIVERSAL_REAL:
    return savantGreaterThanOrEqual((UniversalReal &)*this, 
				    (UniversalReal &)data);
    break;
  case UNIVERSAL_LONG_LONG_INTEGER:
     return savantGreaterThanOrEqual((UniversalLongLongInteger &)*this, 
				     (UniversalLongLongInteger &)data);
    break;
  case UNIVERSAL_BOOLEAN:
    return savantGreaterThanOrEqual((UniversalBoolean &)*this, 
				    (UniversalBoolean &)data);
    break;
  case UNIVERSAL_CHARACTER:
    return savantGreaterThanOrEqual((UniversalCharacter &)*this, 
				    (UniversalCharacter &)data);
    break;
  default:
    cerr << "operator >= called with unknown VHDLData type !! " << endl;
    abort();
    return false;
    break;
  }
}

bool
VHDLData::operator < (const VHDLData &data) const {
  switch(this->get_universal_kind()){
  case UNIVERSAL_INTEGER:
    return savantLessThan((UniversalInteger &)*this, 
			  (UniversalInteger &)data);
    break;
  case UNIVERSAL_REAL:
    return savantLessThan((UniversalReal &)*this, 
			  (UniversalReal &)data);
    break;
  case UNIVERSAL_LONG_LONG_INTEGER:
     return savantLessThan((UniversalLongLongInteger &)*this, 
			   (UniversalLongLongInteger &)data);
    break;
  case UNIVERSAL_BOOLEAN:
    return savantLessThan((UniversalBoolean &)*this, 
			  (UniversalBoolean &)data);
    break;
  case UNIVERSAL_CHARACTER:
    return savantLessThan((UniversalCharacter &)*this, 
			  (UniversalCharacter &)data);
    break;
  default:
    cerr << "operator < called with unknown VHDLData type !! " << endl;
    abort();
    return false;
    break;
  }
}

bool
VHDLData::operator <= (const VHDLData &data) const {
  switch(this->get_universal_kind()){
  case UNIVERSAL_INTEGER:
    return savantLessThanOrEqual((UniversalInteger &)*this, 
				 (UniversalInteger &)data);
    break;
  case UNIVERSAL_REAL:
    return savantLessThanOrEqual((UniversalReal &)*this, 
				 (UniversalReal &)data);
    break;
  case UNIVERSAL_LONG_LONG_INTEGER:
     return savantLessThanOrEqual((UniversalLongLongInteger &)*this, 
				  (UniversalLongLongInteger &)data);
    break;
  case UNIVERSAL_BOOLEAN:
    return savantLessThanOrEqual((UniversalBoolean &)*this, 
				 (UniversalBoolean &)data);
    break;
  case UNIVERSAL_CHARACTER:
    return savantLessThanOrEqual((UniversalCharacter &)*this, 
				 (UniversalCharacter &)data);
    break;
  default:
    cerr << "operator <= called with unknown VHDLData type !! " << endl;
    abort();
    return false;
    break;
  }

}

VHDLData*
savantUnaryPlus(const VHDLData& lhs) {
  switch(lhs.get_universal_kind()) {
  case VHDLData::UNIVERSAL_INTEGER:
    return  new UniversalInteger(savantUnaryPlus((UniversalInteger &) lhs));
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    return new UniversalLongLongInteger(savantUnaryPlus((UniversalLongLongInteger &) lhs));
  case VHDLData::UNIVERSAL_REAL:
    return new UniversalReal(savantUnaryPlus((UniversalReal &) lhs));
  default:
    cerr << "savantUnaryPlus(const VHDLData &) called.\n";
    abort();
    // This will never be executed. Just to keep the Compiler from complaining
  }
  
  return NULL;
}

VHDLData*
savantUnaryMinus(const VHDLData& lhs) {
  switch(lhs.get_universal_kind()) {
  case VHDLData::UNIVERSAL_INTEGER:
    return new UniversalInteger(savantUnaryMinus((UniversalInteger &) lhs));
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    return new UniversalLongLongInteger(savantUnaryMinus((UniversalLongLongInteger &) lhs));
  case VHDLData::UNIVERSAL_REAL:
    return new UniversalReal(savantUnaryMinus((UniversalReal &) lhs));
    break;
  default:
    cerr << "savantUnaryMinus(const VHDLData &) called.\n";
    abort();
    // This will never be executed. Just to keep the Compiler from complaining
  }

  return NULL;
}

VHDLData*
savantPlus(const VHDLData& lhs, const VHDLData &rhs) {
  switch(lhs.get_universal_kind()) {
  case VHDLData::UNIVERSAL_INTEGER:
    return new UniversalInteger(savantPlus(UniversalInteger(lhs), UniversalInteger(rhs)));
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    return new UniversalLongLongInteger(savantPlus(UniversalLongLongInteger(lhs), UniversalLongLongInteger(rhs)));
  case VHDLData::UNIVERSAL_REAL:
    return new UniversalReal(savantPlus(UniversalReal(lhs), UniversalReal(rhs)));
  default:
    cerr << "savantPlus(const VHDLData &, const VHDLData &) called.\n";
    abort();
    // This will never be executed. Just to keep the Compiler from complaining
  }
  
  return NULL;
}

VHDLData*
savantMinus(const VHDLData& lhs, const VHDLData &rhs) {
  switch(lhs.get_universal_kind()) {
  case VHDLData::UNIVERSAL_INTEGER:
    return new UniversalInteger(savantMinus(UniversalInteger(lhs), UniversalInteger(rhs)));
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    return new UniversalLongLongInteger(savantMinus(UniversalLongLongInteger(lhs), UniversalLongLongInteger(rhs)));
  case VHDLData::UNIVERSAL_REAL:
    return new UniversalReal(savantMinus(UniversalReal(lhs), UniversalReal(rhs)));
  default:
    cerr << "savantMinus(const VHDLData &, const VHDLData &) called.\n";
    abort();
    // This will never be executed. Just to keep the Compiler from complaining
  }

  return NULL;
}

VHDLData*
savantMultiply(const VHDLData& lhs, const VHDLData &rhs) {
  switch(lhs.get_universal_kind()) {
  case VHDLData::UNIVERSAL_INTEGER:
    return new UniversalInteger(savantPlus(UniversalInteger(lhs), UniversalInteger(rhs)));
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    return new UniversalLongLongInteger(savantMultiply(UniversalLongLongInteger(lhs), UniversalLongLongInteger(rhs)));
  case VHDLData::UNIVERSAL_REAL:
    return new UniversalReal(savantMultiply(UniversalReal(lhs), UniversalReal(rhs)));
  default:
    cerr << "savantMultiply(const VHDLData &, const VHDLData &) called.\n";
    abort();
    // This will never be executed. Just to keep the Compiler from complaining
  }

  return NULL;
}

VHDLData*
savantDivide(const VHDLData& lhs, const VHDLData &rhs) {
  switch(lhs.get_universal_kind()) {
  case VHDLData::UNIVERSAL_INTEGER:
    return new UniversalInteger(savantDivide(UniversalInteger(lhs), UniversalInteger(rhs)));
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    return new UniversalLongLongInteger(savantDivide(UniversalLongLongInteger(lhs), UniversalLongLongInteger(rhs)));
  default:
    cerr << "savantDivide(const VHDLData &, const VHDLData &) called.\n";
    abort();
    // This will never be executed. Just to keep the Compiler from complaining
  }

  return NULL;
}

ostream&
operator<<(ostream &os, const VHDLData::UniversalType type) {
  os << " ";
  switch(type) {
  case VHDLData::UNIVERSAL_INTEGER:
    os << "UniversalInteger";
    break;
  case VHDLData::UNIVERSAL_REAL:
    os << "UniversalReal";
    break;
  case VHDLData::UNIVERSAL_CHARACTER:
    os << "UniversalCharacter";
    break;
  case VHDLData::UNIVERSAL_BOOLEAN:
    os << "UniversalBoolean";
    break;
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    os << "UniversalLongLongInteger";
    break;
  case VHDLData::SEVERITY_LEVEL:
    os << "SeverityLevel";
    break;
  case VHDLData::FILE_OPEN_KIND:
    os << "FileOpenKind";
    break;
  case VHDLData::FILE_OPEN_STATUS:
    os << "FileOpenStatus";
    break;
  case VHDLData::ACCESS_VARIABLE:
    os << "AccessVariable";
    break;
  case VHDLData::STRING_BASE:
    os << "StringBase";
    break;
  case VHDLData::OTHER_TYPE:
    os << "OtherType";
    break;
  default:
    os << " [ERROR TYPE!!] ";
    break;
  }

  return os;
}
      
