#ifndef VECTOR_CC
#define VECTOR_CC
#include "ElementAssociation.hh"

//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All rights Reserved.
//
//---------------------------------------------------------------------------

#include <new.h>
#include "ScalarType.hh"

template <class type>
inline
Vector<type>::Vector(ObjectBase::ObjectType, char *str) 
  : VectorBase(1 , to, strlen(str)) {
//   int offset = sizeof(type);
//   vec = (type *) new char[offset * numElems];
//   for(int i = 0; i < numElems; i++) {
//     new(&vec[i]) type(obj);
//   }

    //vec = new type[numElems](obj);
    vec = NULL;
}

template <class type>
inline
Vector<type>::Vector(ObjectBase::ObjectType obj, int left, ArrayDirn_t dirn,
		     int right, int noofElmntAssns, ...):
  VectorBase(left, dirn, right) {

  int i=0;
  
  vec = new type[numElems];
  for(i = 0; (i < numElems); i++) {
    new (&vec[i]) type(obj);
  }
  
  //    vec = new type[numElems](obj);
    
    va_list ap;
    ElementAssociation* elmtptr;
    ElementAssociation* othersAssociation;
    ElementAssociation** elmtAssocArray;
    char* charptr = NULL;
    int j = 0;
    
    charptr = new char[this->numElems];
    elmtAssocArray = new ElementAssociation*[noofElmntAssns];
    for (i = 0; (i < this->numElems); i++) {
      charptr[i] = 'U';
    }
    
    va_start(ap, noofElmntAssns);
    for(i =0; i < noofElmntAssns; i++) {
      elmtAssocArray[i] = va_arg(ap, ElementAssociation*);
    }
    va_end(ap);
    
    for(i = 0; (i < noofElmntAssns); i++) {
      elmtptr = elmtAssocArray[i];
      othersAssociation = elmtptr;
      if(elmtptr->choice.left() == elmtptr->choice.right()) {
	(*this)[elmtptr->choice.left()].assignVal(*elmtptr->value);
	charptr[this->bounds.storageIndex(elmtptr->choice.left())]
	  = 'I';
	
      }
      else {
	if(elmtptr->choice.dirn() == to) {
	  for(j=elmtptr->choice.left(); j < elmtptr->choice.right(); j++) {
	    (*this)[j].assignVal(*elmtptr->value);
	    charptr[this->bounds.storageIndex(j)] = 'I';
	  }
	}
	else {
	  for(j=elmtptr->choice.left(); j > elmtptr->choice.right(); j--) {
	    (*this)[j].assignVal(*elmtptr->value);
	    charptr[this->bounds.storageIndex(j)] = 'I';
	  }
	}
      }
    }
    
    for(i=0; i < this->numElems; i++) {
      if(charptr[i] == 'U') {
	this->get_element(i) = *othersAssociation->value;
      }
    }
    
    for(i =0; i < noofElmntAssns; i++) {
      delete  elmtAssocArray[i]->value;
      delete  elmtAssocArray[i];
    }
    
    if(elmtAssocArray != NULL) {
      delete [] (char*)elmtAssocArray;
    }
    
    delete [] charptr;
}

template <class type>
inline
Vector<type>::Vector(ObjectBase::ObjectType objType, int left, ArrayDirn_t dirn, int right, char *value) : VectorBase(left, dirn, right)  {
  int counter;

  vec = new type[numElems];

  for(counter = 0; (counter < numElems); counter++) {
    new (&vec[counter]) type(objType);
  }

  for(counter = 0; (counter < numElems); counter++) {
    (vec + counter)->getObject()->updateVal(UniversalInteger((int) value[counter]));
  }
}

template <class type>
inline
Vector<type>::~Vector()
{
  if ((is_alias == false) && (vec != NULL)) {
    delete [] vec;
    vec = NULL;
  }
}

template <class type> 
inline void 
Vector<type>::setRange(ObjectBase::ObjectType obj, ArrayInfo *aInfo,
		       int dimension, const TypeInfo &typeInfo) {
  
  if (vec != NULL) {
    return;
  }
  
  const ArrayInfo tempInfo(aInfo->left(), aInfo->dirn(), aInfo->right());
  bounds = tempInfo;
  numElems = bounds.length();
  int i;

  vec = new type[numElems];
  
  for(i = 0; i < numElems; i++) {
    if ((dimension == 1) && (&typeInfo != &TypeInfo::NULL_TYPE_INFO)) {
      new(&vec[i]) type(obj, typeInfo);
    }
    else {
      new (&vec[i]) type(obj);
    }
  }
  
  // vec = new type[numElems](obj);
  
  if(dimension > 1) {
    dimension--;
    for(i = 0; i < numElems; i++) {
      (vec[i]).setRange(obj, &(aInfo[1]), dimension, typeInfo);
    }
  }
}

template <class type> 
inline void 
Vector<type>::setRange(ObjectBase::ObjectType obj, VectorBase* value) {
  bounds = value->bounds;
  numElems = value->numElems;
  int i;
  
  vec = new type[numElems];
  for(i = 0; i < numElems; i++) {
    new(&vec[i]) type(obj);
  }
  
  // vec = new type[numElems](obj);
  
  if(vec[0].get_kind() == VECTOR_BASE) {
    for(i = 0; i < numElems; i++) {
      ((VectorBase &)(vec[i])).setRange(obj, (VectorBase*)(&(value->get_element(0))));
    }
  }
}

// Returns a new array with modified bounds.
//   newBounds   : Bounds of the new array created.
//   actualBounds: Bounds of this array that get mapped on to the new bounds.
template <class type> 
inline VectorBase*
Vector<type>::getNewArray(const ArrayInfo& newBounds, 
			  const ArrayInfo& actualBounds) const {
  VectorBase* newArray = new Vector<type>;

  newArray->bounds = newBounds;
  newArray->numElems = newBounds.length();
  
  // regardless of direction, we pass in left() 
  if(newArray->numElems != 0) {
    ((Vector<type> *) newArray)->setVec((type *) &((*this)[actualBounds.left()]));
  } else {
    ((Vector<type> *) newArray)->setVec(NULL);
  }    

  return newArray;
}

template <class type>
inline VHDLType& 
Vector<type>::operator=(const VHDLType& rhs) {
   Vector<type>& val = *((Vector<type>*)&rhs);
  for (register int i = 0; i < numElems; i++) {
    this->get_element(i) = val.get_element(i);
    // ((type &) this->get_element(i)) = ((const type &) val.get_element(i));
  }
  return *this;
}

template <class type>
inline bool
Vector<type>::operator==(const VHDLType& val) const {
  ASSERT(val.get_kind() == VECTOR_BASE);
  int lhs_length = bounds.length();
  int rhs_length = ((VectorBase&)val).length();

  if(lhs_length != rhs_length) {
    return false;
  }
  for(int i = 0; i < lhs_length; i++) {
    if(!(this->get_element(i) == val.get_element(i))) {
      return false;
    }
  }
  return true;
}

template <class type> 
inline char* 
Vector<type>::getString() const {
  int i=0;
  char* retval = new char[numElems+1];
  char* ptr =NULL;
  memset(retval, 0, numElems+1);
  //### Assumes the vector to have only scalar type elements
  for(i=0; i < numElems; i++) {
    ptr = get_element(i).getString();
    strcat(retval, ptr);
    delete []ptr;
  }
  retval[numElems] = '\0';
  return retval;
}

template <class type>
inline void 
Vector<type>::assignSlice(VHDLType* data, const ArrayInfo* sInfo, 
			  const ArrayInfo *dInfo) {
  int destidx, srcidx;
  VectorBase* srcvec = (VectorBase *) data;

  destidx = dInfo->left();
  srcidx = sInfo->left(); 
  if (dInfo->length() < sInfo->length()) {
    cerr << "Vector::assignSlice ERROR--" << *sInfo
         << " is too long to fit into me." << endl;
    cerr << *this << endl;
    abort();
  }
  else { // data is equal or shorter in length than me
    while (srcidx != sInfo->right()) {
      vec[destidx] = *(type *)(&(*srcvec)[srcidx]);
      destidx = dInfo->rightof(destidx);
      srcidx = sInfo->rightof(srcidx);
    }
    // have to do this to do the last one
    vec[destidx] = *(type *)(&(*srcvec)[srcidx]); 
  }
}


template <class type>
inline void 
Vector<type>::assignSlice(VHDLType* data, const ArrayInfo* dInfo) {
  int destidx, srcidx;
  VectorBase* srcvec = (VectorBase *) data;

  destidx = dInfo->left();
  srcidx = srcvec->bounds.left(); 
  if (bounds.length() < dInfo->length()) {
    cerr << "Vector::assignSlice ERROR--" << *dInfo
         << " is too long to fit into me." << endl;
    cerr << *this << endl;
    abort();
  }
  else { // data is equal or shorter in length than me
    while (destidx != dInfo->right()) {
      vec[destidx] = *(type *)(&(*srcvec)[srcidx]);
      destidx = dInfo->rightof(destidx);
      srcidx = srcvec->bounds.rightof(srcidx);
    }
    // have to do this to do the last one
    vec[destidx] = *(type *)(&(*srcvec)[srcidx]); 
  }
}


template <class type>
inline VHDLType&
Vector<type>::operator[](const int pos) const {
#ifdef DEVELOPER_ASSERTIONS
  if (!bounds.contains(pos)) {
    cerr << "Vector::operator[]: bit specifier (" << pos 
	 << ") out of range--my bounds are " << bounds << endl;
    abort();
  }
#endif
  register int i = bounds.storageIndex(pos);
  return vec[i];
}

template <class type>
inline type&
Vector<type>::operator[](const ScalarType& pos) const {
  register int i = int((UniversalInteger &) pos.object->readVal());
  register int j = bounds.storageIndex(i);
  return vec[j];
}


template <class type>
inline void 
Vector<type>::print(ostream& os) const {
  os << "(";
  for (register int i = 0; i < numElems-1; i++) {
    //    os << vec[i] << ", ";
    vec[i].print(os);
    os << ", ";
  }
  //  os << vec[numElems-1] << ")";
  vec[numElems-1].print(os);
  os << ")";
}

template <class type>
inline VHDLType*
Vector<type>::clone() const {
  VHDLType *retval = new Vector<type>;
  ((Vector<type> *) retval)->setRange(vec->getKind(), (VectorBase *)this);
  *retval = *this;
  return retval;
}

template<class type>
inline void
Vector<type>::setResolutionFunctionId(int resolutionFnId) {
  for(register int i=0; (i < this->numElems); i++) {
    ((type&)(this->get_element(i))).setResolutionFunctionId(resolutionFnId);
  }
}

template<class type>
inline void
Vector<type>::setTypeConversionFunctionId(int typeConversionFnId) {
  for(register int i=0; (i < this->numElems); i++) {
    ((type&)(this->get_element(i))).setTypeConversionFunctionId(typeConversionFnId);
  }
}


template<class type>
inline int
Vector<type>::savantwrite(SavantlineType &line) {
  for(register int i=0; (i < this->numElems); i++) {
    ((type&)(this->get_element(i))).savantwrite(line);
  }

  return NORMAL_RETURN;
}

template <class type>
inline int
Vector<type>::savantread(SavantlineType &line) {
  for(register int i=0; (i < this->numElems); i++) {
    ((type&)(this->get_element(i))).savantread(line);
  };

  return NORMAL_RETURN;
}

template<class type>
inline void
Vector<type>::setElaborationInfo(const VHDLType &obj_info){
  ASSERT(_is_signal() == true);
  ASSERT(obj_info.get_kind() == VECTOR_BASE);
  for ( int index = 0; index < numElems ; index++){
    this->get_element(index).setElaborationInfo(((VectorBase &)obj_info).get_element(index));
  }
}

#endif
