#ifndef _STANDARD_CC_
#define _STANDARD_CC_

#include "standard.hh"

static char* SavantbitType_info_imageMap[] = {"'0'", "'1'"};
enumInfo SavantbitType_info(2, SavantbitType_info_imageMap, 0, to);

static char* SavantcharacterType_info_imageMap[] =
{"nul", "soh", "stx", "etx", "eot", "enq", "ack", "bel", "bs", "ht", "lf",
 "vt", "ff", "cr", "so", "si", "dle", "dc1", "dc2", "dc3", "dc4", "nak",
 "syn", "etb", "can", "em", "sub", "esc", "fsp", "gsp", "rsp", "usp",
 "' '", "'!'", "'\"'", "'#'", "'$'", "'%'", "'&'", "'''", "'('", "')'", "'*'",
 "'+'", "','", "'-'", "'.'", "'/'", "'0'", "'1'", "'2'", "'3'", "'4'", "'5'",
 "'6'", "'7'", "'8'", "'9'", "':'", "';'", "'<'", "'='", "'>'", "'?'", "'@'",
 "'A'", "'B'", "'C'", "'D'", "'E'", "'F'", "'G'", "'H'", "'I'", "'J'", "'K'",
 "'L'", "'M'", "'N'", "'O'", "'P'", "'Q'", "'R'", "'S'", "'T'", "'U'", "'V'",
 "'W'", "'X'", "'Y'", "'Z'", "'['", "'\'", "']'", "'^'", "'_'", "'`'", "'a'",
 "'b'", "'c'", "'d'", "'e'", "'f'", "'g'", "'h'", "'i'", "'j'", "'k'", "'l'",
 "'m'", "'n'", "'o'", "'p'", "'q'", "'r'", "'s'", "'t'", "'u'", "'v'", "'w'",
 "'x'", "'y'", "'z'", "'{'", "'|'", "'}'", "'~'", "del", "c128", "c129",
 "c130", "c131", "c132", "c133", "c134", "c135", "c136", "c137", "c138",
 "c139", "c140", "c141", "c142", "c143", "c144", "c145", "c146", "c147",
 "c148", "c149", "c150", "c151", "c152", "c153", "c154", "c155", "c156",
 "c157", "c158", "c159", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''",
 "''", "''", "''", "''", "''", "''", "''"};
enumInfo SavantcharacterType_info(256, SavantcharacterType_info_imageMap, 0, to);

static char *SavantbooleanType_info_imageMap[] = {"FALSE", "TRUE"};
enumInfo SavantbooleanType_info(2, SavantbooleanType_info_imageMap, 0,
to);

static char *Savantseverity_levelType_info_imageMap[] =
{"NOTE", "WARNING", "ERROR", "FAILURE"};
enumInfo Savantseverity_levelType_info(4, Savantseverity_levelType_info_imageMap, 0, to);

static char *Savantfile_open_kindType_info_imageMap[] =
{"read_mode", "write_mode", "append_mode"};
enumInfo Savantfile_open_kindType_info(3, Savantfile_open_kindType_info_imageMap, 0, to);

static char *Savantfile_open_statusType_info_imageMap[] =
{"open_kind", "status_error", "name_error", "mode_error"};
enumInfo Savantfile_open_statusType_info(4, Savantfile_open_statusType_info_imageMap, 0, to);

rangeInfo SavantintegerType_info(INT_MIN, to, INT_MAX);
rangeInfo SavantnaturalType_info(0, to, INT_MAX);
rangeInfo SavantpositiveType_info(1, to, INT_MAX);
rangeInfo SavantwidthType_info(0, to, INT_MAX);

realInfo SavantrealType_info(-1.0E38, to, 1.0E38);

static LONG SavanttimeType_info_scale[] =
{1, 1000, 1000000, 1000000000LL, 1000000000000LL, 1000000000000000LL, 60000000000000000LL, 3600000000000000000LL};
static char* SavanttimeType_info_unit[] =
{"fs","ps","ns","us","ms","sec","min","hr"};
phyInfo SavanttimeType_info(8, 0L, to, LLONG_MAX, SavanttimeType_info_scale, SavanttimeType_info_unit);

phyInfo Savantdelay_lengthType_info(8, 0L, to, LLONG_MAX, SavanttimeType_info_scale, SavanttimeType_info_unit);

// Default global constants

const EnumerationType SAVANT_BOOLEAN_TRUE(ObjectBase::VARIABLE, 1, SavantbooleanType_info);
const EnumerationType SAVANT_BOOLEAN_FALSE(ObjectBase::VARIABLE, 0, SavantbooleanType_info);

const PhysicalType SAVANT_ZERO_TIME(ObjectBase::VARIABLE, 0, SavanttimeType_info);
const PhysicalType SAVANT_INFINITY_TIME(ObjectBase::VARIABLE, VTime::getMax().time, SavanttimeType_info);

const enumInfo NULL_ENUM_INFO (0, NULL, 0, to);

#endif
