#include "AccessVariable.hh"
#include "textio.hh"
#include "VHDLKernel.hh"

static char *SavantsideType_info_imageMap[] = {"right", "left"};
enumInfo SavantsideType_info(2, SavantsideType_info_imageMap, 0, to);

int savantread(VHDLKernelBase*, AccessVariable<char*>& line, 
		const PhysicalType& var) {
  int startPos = line.curPos;
  LONG timeval = 0LL;
  char *endptr;

  if (eatwhite(line) == false) {
    abort();
  }
  
  // extract decimal value
  timeval = (LONG) strtol((const char*)&(line.val[line.curPos]), &endptr, 10);
  if (endptr == &(line.val[line.curPos]) && timeval == 0) {
    // strtod failed to make a number out of the string
    cout << " read(int time) failed to find a number for time" << endl;
    abort();
  }
  else {
    // now get the units
    line.curPos += (endptr - &(line.val[line.curPos]));
    if (eatwhite(line) == false) {
      line.curPos = startPos;
      abort();
    }
    // handle times with units fs, ps, ns, us, ms
    if (toupper(line.val[line.curPos + 1]) == 'S') {
      UniversalLongLongInteger tempTimeval = timeval;
      switch (toupper(line.val[line.curPos])) {
      case 'F':
	var.object->updateVal(tempTimeval);
	break;
      case 'P':
	tempTimeval.val *= 1000;
	var.object->updateVal(tempTimeval);
	break;   
      case 'N':
	tempTimeval.val *= 1000000;
	var.object->updateVal(tempTimeval);
	break;
      case 'U':
	tempTimeval.val *= 1000000000;
	var.object->updateVal(tempTimeval);
	break;
      case 'M':
	tempTimeval.val *= 1000000000000LL;
	var.object->updateVal(tempTimeval);
	break;
      default:
	cout << " read(int time) warning: bad units! ("
	     << line.val[line.curPos] << line.val[line.curPos + 1]
	     << ")" << endl;
	line.curPos = startPos;
	abort();
      }
      line.curPos +=2;
    } else {
      UniversalLongLongInteger tempTimeval = timeval;
      // handle times with units sec, min, hr
      if (toupper(line.val[line.curPos]) == 'S' &&
	  toupper(line.val[line.curPos + 1]) == 'E' &&
	  toupper(line.val[line.curPos + 2]) == 'C') {
	tempTimeval.val *= 1000000000000000LL;
	var.object->updateVal(tempTimeval);
	line.curPos +=3;
      } else if (toupper(line.val[line.curPos]) == 'M' &&
		 toupper(line.val[line.curPos + 1]) == 'I' &&
		 toupper(line.val[line.curPos + 2]) == 'N') {
	tempTimeval.val *= 1000000000000000LL * 60;
	var.object->updateVal(tempTimeval);
	line.curPos +=3;
      }
      else if (toupper(line.val[line.curPos]) == 'H' &&
	       toupper(line.val[line.curPos + 1]) == 'R') {
	tempTimeval.val *= 1000000000000000LL * 3600;
	var.object->updateVal(tempTimeval);
	line.curPos +=2;
      }
      else {
	cout<< " read(VTime) warning: time units bogus" << endl;
	line.curPos = startPos;
	abort();
      }
    }
  }
  return NORMAL_RETURN;
}

int
savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
	    const PhysicalType& var, const Side_t justified, 
	    const int field, TimeUnit_t unit) {
  char *units[] = {"FS", "PS", "NS", "US", "MS", "SEC", "MIN", "HR"};
  int unitmult[] = {1000, 1000, 1000, 1000, 1000, 60, 60};
  char* newline;
  double num;
  LONG value;
  register int i;
  int length, originalLength;

  char numstring[32];
  strstream numstream(numstring, 32, ios::out);
  numstream.seekp(ios::beg);

  value = longlongint((UniversalLongLongInteger& )var.object->readVal());
  // set output format, remove trailing zeros
  num = double(value);
  numstream.setf(ios::fixed, ios::floatfield);
  numstream.unsetf(ios::showpoint);
  if (num < 100) {
    if (value % 10 == 0) {
      numstream.precision(5);
    }
    else {
      numstream.precision(6);
    }
  }
  for (i = 0; i < (int)unit; i++) { // convert FS time to appropriate value
    num = num / unitmult[i];
  }
  if(num == (LONG) num) {
    numstream.precision(0);
    numstream << (LONG) num << " " << units[(int)unit] << ends;
  } else {
    numstream << num << " " << units[(int)unit] << ends;
  }
  length = strlen(numstring);
  originalLength = length;
  int spaceLength = field - length;

  // create new string
  if (field > length) {  // space for user-specified padding
    length = field;
  }
  newline = new char[line.dataLength + length];
  if (line.dataLength != 0) { // copy old line
    memcpy(newline, line.val, line.dataLength);
  }

#ifdef VHDLDBG
  cout << "::write(integer) adding |" <<  numstring<< "| to line|";
  line.print(cout);
  cout << "|" << endl;
#endif

  if (field < originalLength) {
    memcpy(newline + line.dataLength, numstring, originalLength);
  }
  else {
    if (justified == LEFT) { 
      memcpy(newline + line.dataLength, numstring, originalLength);
      for (  i=0; i < spaceLength; i++) {
	newline[ line.dataLength + originalLength +i ] = ' ';
      }
    }
    if (justified == RIGHT) {
      for (  i=0; i < spaceLength; i++) {
	newline[line.dataLength +i] = ' ';
      }
      memcpy(newline + line.dataLength + spaceLength, numstring,originalLength);
    }
  }//endofelse
 
  delete [] line.val;
  line.val = newline;
  line.dataLength = line.dataLength + length;
  return NORMAL_RETURN;
}

int savantread(VHDLKernelBase*, AccessVariable<char*>& line, VTime& time) {
  PhysicalType val(ObjectBase::VARIABLE);
  savantread(NULL, line, val);
  time = val.getVTime();
  return NORMAL_RETURN;
}

int savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
		const VTime& time, const Side_t justified, const int field, 
		TimeUnit_t unit) {
  savantwrite(NULL, line, PhysicalType(ObjectBase::VARIABLE, 
				   UniversalLongLongInteger(time.time)), 
	      justified, field, unit);
  return NORMAL_RETURN;
}

int 
savantread_bit(VHDLKernelBase*, AccessVariable<char*>& line, EnumerationType& var) {
  ASSERT (var.range.get_imageMap() == SavantbitType_info.get_imageMap());
  
  if (eatwhite(line) == false) {
    abort();
  }
  
  UniversalInteger tempval((int)line.val[line.curPos] - '0');
  var.object->updateVal(tempval);
  line.curPos++;
  return NORMAL_RETURN;
}

int
savantread_character(VHDLKernelBase*, AccessVariable<char*>& line, 
		     EnumerationType& var) {
  
  ASSERT (var.range.get_imageMap() == SavantcharacterType_info.get_imageMap());
  
  if (eatwhite(line) == false) {
    abort();
  }
  var.object->updateVal(UniversalInteger((int) line.val[line.curPos]));
  line.curPos++;
  return NORMAL_RETURN;
}

int
savantread_boolean(VHDLKernelBase*, AccessVariable<char*>& line,
		   EnumerationType& var) {
  ASSERT (var.range.get_imageMap() == SavantbooleanType_info.get_imageMap());

  if (eatwhite(line) == false) {
    abort();
  }

  if (line.val[line.curPos] == 'T') {
    var.object->updateVal(UniversalInteger(1));
    line.curPos += 4;
  }
  else if (line.val[line.curPos] == 'F') {
    var.object->updateVal(UniversalInteger(0));
    line.curPos += 5;
  }
  else {
    cerr << "Illegal boolean value read !!" << endl;
    abort();
  }

  return NORMAL_RETURN;
}
    
int 
savantread(VHDLKernelBase *kb, AccessVariable<char*>& line, EnumerationType& var){
  if (eatwhite(line) == false) {
    abort();
  }

  if (var.range.get_imageMap() == SavantcharacterType_info.get_imageMap()) {
    savantread_character(kb, line, var);
  }
  else if (var.range.get_imageMap() == SavantbitType_info.get_imageMap()) {
    savantread_bit(kb, line, var);
  }
  else if (var.range.get_imageMap() == SavantbooleanType_info.get_imageMap()) {
    savantread_boolean(kb, line, var);
  }
  else {
    UniversalInteger tempval(line.val[line.curPos] - '0');
    var.object->updateVal(tempval);
    line.curPos++;
  }
  
  return NORMAL_RETURN;
}

int 
savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
	    const EnumerationType& var, const Side_t justified, const int field){
  char* newline;
  char intstr[24];
  strstream outstream(intstr, 24, ios::out);

  if (var.range.get_imageMap() == SavantcharacterType_info.get_imageMap()) {
    // Okay. This is a simple character so dump it as is...
    outstream << (char) int((const UniversalInteger &) var.getVHDLData());
  }
  else if (var.range.get_imageMap() == SavantbitType_info.get_imageMap()) {
    // Okay. This is a simple bit so dump it as is...
    outstream << (char) (int((const UniversalInteger &) var.getVHDLData())
      + '0');
  }
  else if (var.range.get_imageMap() == SavantbooleanType_info.get_imageMap()) {
    int value = int((UniversalInteger &) var.getVHDLData());
    outstream << var.range.get_imageMap()[value];
  }
  else {
    outstream << var.range.get_imageMap()[int((const UniversalInteger &) var.getVHDLData())];
  }
  
  outstream << ends;
  int length = strlen(intstr);
  int originalLength, i;
  int spaceLength = field - length;
  originalLength = length;
#ifdef VHDLDBG
  cout << "::write(integer) adding |" <<  intstr << "| to line|";
  line.print(cout);
  cout << "|" << endl;
#endif

  if (field > originalLength) {  // space for user-specified padding
    length = field;
  }
  newline = new char[line.dataLength + length];
  if (line.dataLength != 0) { //copy old line first
    memcpy(newline, line.val, line.dataLength);
  }
  
  if (field < originalLength) {
    memcpy(newline + line.dataLength, intstr, originalLength);
  }
  else {
    if (justified == LEFT) { 
      memcpy( newline + line.dataLength, intstr, originalLength);
      for (  i=0; i < spaceLength; i++) {
	newline[line.dataLength + originalLength +i] = ' ';
      }
    }
    if (justified == RIGHT) {
      for ( i=0; i < spaceLength; i++) {
	newline[line.dataLength+i] = ' ';
      }
      memcpy( newline + line.dataLength + spaceLength, intstr, originalLength);
    }
  } //endofelse
  delete [] line.val;
  line.val = newline;
  line.dataLength += length;
  return NORMAL_RETURN;
}

int 
savantread(VHDLKernelBase*, AccessVariable<char*>& line, 
	   IntegerType& var) {
  int integerVal =0;
  char *endPtr;
  
  if (eatwhite(line) == false) {
    abort();
  }
  
  // extract integer value
  integerVal = strtol((const char *)&(line.val[line.curPos]), &endPtr, 10);
  if (endPtr == &(line.val[line.curPos]) && integerVal == 0) {
    cout << "SavantintegerType::read(int time) failed to find a number "
	 <<"for time" << endl;
    abort();
  }
  else {
    line.curPos += endPtr - &line.val[line.curPos];
    var.object->updateVal(UniversalInteger(integerVal));
  }
  return NORMAL_RETURN;
}

int savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
		const IntegerType& var, const Side_t justified, 
		const int field) {
  char* newline;
  char intstr[24];
  strstream outstream(intstr, 24, ios::out);
  var.object->readVal().print(outstream);
  outstream << ends;
  int length = strlen(intstr);
  int originalLength, i;
  int spaceLength = field - length;
  originalLength = length;
#ifdef VHDLDBG
  cout << "savantwrite(SavantintegerType) adding |" <<  intstr << "| to line|";
  line.print(cout);
  cout << "|" << endl;
#endif

  if (field > originalLength) {  // space for user-specified padding
    length = field;
  }
  newline = new char[line.dataLength + length];
  if (line.dataLength != 0) { //copy old line first
    memcpy(newline, line.val, line.dataLength);
  }

  if (field < originalLength) {
    memcpy(newline + line.dataLength, intstr, originalLength);
  }
  else {
    if (justified == LEFT) { 
      memcpy( newline + line.dataLength, intstr, originalLength);
      for (  i=0; i < spaceLength; i++) {
      newline[line.dataLength + originalLength +i] = ' ';
      }
    }
  if (justified == RIGHT) {
    for ( i=0; i < spaceLength; i++) {
      newline[line.dataLength+i] = ' ';
    }
    memcpy( newline + line.dataLength + spaceLength, intstr, originalLength);
  }
  } //endofelse
  delete [] line.val;
  line.val = newline;
  line.dataLength += length;
  return NORMAL_RETURN;
}                      

int 
savantread(VHDLKernelBase*, AccessVariable<char*>& line, 
	   RealType& var) {
  double doubleVal =0;
  char *endPtr;

  if (eatwhite(line) == false) {
    abort();
  }

  // extract integer value
  doubleVal = strtod((const char *)&(line.val[line.curPos]), &endPtr);
  if (endPtr == &(line.val[line.curPos]) && doubleVal == 0) {
    cout << "SavantrealType::read failed to find a number" << endl;
    abort();
  } else {
    line.curPos += endPtr - &line.val[line.curPos];
    var.object->updateVal(UniversalReal(doubleVal));
  }
  return NORMAL_RETURN;
}

int 
savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
	    const RealType& var, const Side_t justified, const int field,
	    const int digits) {
  char* newline;
  char intstr[256];
  strstream outstream(intstr, 256, ios::out);
  if(digits == 0) {
    outstream.setf(ios::scientific);
  }
  var.object->readVal().print(outstream);
  outstream << ends;
  int length = strlen(intstr);
  int originalLength, i;
  int spaceLength = field - length;
  originalLength = length;
#ifdef VHDLDBG
  cout << "savantwrite(SavantintegerType) adding |" <<  intstr << "| to line|";
  line.print(cout);
  cout << "|" << endl;
#endif

  if (field > originalLength) {  // space for user-specified padding
    length = field;
  }
  newline = new char[line.dataLength + length];
  if (line.dataLength != 0) { //copy old line first
    memcpy(newline, line.val, line.dataLength);
  }

  if (field < originalLength) {
    memcpy(newline + line.dataLength, intstr, originalLength);
  }
  else {
    if (justified == LEFT) { 
      memcpy( newline + line.dataLength, intstr, originalLength);
      for (  i=0; i < spaceLength; i++) {
      newline[line.dataLength + originalLength +i] = ' ';
      }
    }
  if (justified == RIGHT) {
    for ( i=0; i < spaceLength; i++) {
      newline[line.dataLength+i] = ' ';
    }
    memcpy( newline + line.dataLength + spaceLength, intstr, originalLength);
  }
  } //endofelse
  delete [] line.val;
  line.val = newline;
  line.dataLength += length;
  return NORMAL_RETURN;
}                      

// int 
// savantread(VHDLKernelBase*, AccessVariable<char*>& line, 
// 	   EnumerationType& var) {
//   if (eatwhite(line) == false) {
//     abort();
//   }
//   var.object->updateVal(UniversalBoolean(line.val[line.curPos] - '0'));
//   line.curPos++;
//   return NORMAL_RETURN;
// }

// int 
// savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
// 	    const SavantbooleanType& var, const Side_t justified, 
// 	    const int field) {
//   char* newline;
//   char intstr[24];
//   strstream outstream(intstr, 24, ios::out);
//   var.object->readVal().print(outstream);
//   outstream << ends;
//   int length = strlen(intstr);
//   int originalLength, i;
//   int spaceLength = field - length;
//   originalLength = length;
// #ifdef VHDLDBG
//   cout << "::write(integer) adding |" <<  intstr << "| to line|";
//   line.print(cout);
//   cout << "|" << endl;
// #endif

//   if (field > originalLength) {  // space for user-specified padding
//     length = field;
//   }
//   newline = new char[line.dataLength + length];
//   if (line.dataLength != 0) { //copy old line first
//     memcpy(newline, line.val, line.dataLength);
//   }

//   if (field < originalLength) {
//     memcpy(newline + line.dataLength, intstr, originalLength);
//   }
//   else {
//     if (justified == LEFT) { 
//       memcpy( newline + line.dataLength, intstr, originalLength);
//       for (  i=0; i < spaceLength; i++) {
// 	newline[line.dataLength + originalLength +i] = ' ';
//       }
//     }
//     if (justified == RIGHT) {
//       for ( i=0; i < spaceLength; i++) {
// 	newline[line.dataLength+i] = ' ';
//       }
//       memcpy( newline + line.dataLength + spaceLength, intstr, originalLength);
//     }
//   } //endofelse
//   delete [] line.val;
//   line.val = newline;
//   line.dataLength += length;
//   return NORMAL_RETURN;
// }

// int savantread(VHDLKernelBase*, AccessVariable<char*>& line, 
// 		SavantcharacterType& var) {
//   if (eatwhite(line) == false) {
//     abort();
//   }
//   var.object->updateVal(UniversalInteger((int) line.val[line.curPos]));
//   line.curPos++;
//   return NORMAL_RETURN;
// }

// int savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
// 		const SavantcharacterType& var, const Side_t justified, 
// 		const int field) {
//   char* newline;
//   int length = 1;
//   int i;

//   if (field > 1) {  // space for user-specified padding
//     length = field;
//   }

// #ifdef VHDLDBG
//   cout << "savantwritewrite(SavantcharacterType) adding |" <<  var
//        << "| to line|";
//   line.print(cout);
//   cout << "|" << endl;
// #endif

//   newline = new char[line.dataLength + length];
//   if (line.dataLength != 0) { //copy old line first
//     memcpy(newline, line.val, line.dataLength);
//   }
//   if (field <= 1) {
//     newline[line.dataLength] = (char)((UniversalInteger *) &var.object->readVal())->val;
//   }
//   else {
//     if (justified == LEFT) { 
//       newline[line.dataLength] = (char)((UniversalInteger&)var.object->readVal()).val;
//       for (i = 0; i < length - 1; i++) {
// 	newline[line.dataLength + 1 + i] = ' ';
//       }
//     }
//     if (justified == RIGHT) {
//       for (i = 0; i < length - 1; i++) {
//        newline[line.dataLength + i] = ' ';
//       }
//       newline[line.dataLength + length - 1] = (char)((UniversalInteger &) var.object->readVal()).val;
//     }
//   }
//   delete [] line.val;
//   line.val = newline;
//   line.dataLength += length;
//   return NORMAL_RETURN;
// }                      

// int savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
// 		const SavantintegerType& var, const Side_t justified, 
// 		const int field, const int digits) {
//   char* newline;
//   register int i;
//   char numbstr[64];
//   strstream outstream(numbstr, 64, ios::out);
//   var.object->readVal().print(outstream);
//   outstream << ends;
//   if ( digits == 0) {
//     outstream.setf(ios::floatfield, ios::scientific);
//   }
//   else {
//     outstream.setf(ios::floatfield, ios::fixed);
//   }
 
//   char* numberstr = outstream.str();
//   int length = strlen(numberstr);

//   //keep the exact digits
//   if( digits != 0) {
//     for ( i =0; i < length; i++) {
//       if (numberstr[i] == '.') {
// 	for ( register int j = 0; j <digits; j++ ) {
// 	  i++;
// 	}
// 	break;
//       }
//     }
//     numberstr[i] = '\0';
//   } //endofif

//   length = strlen(numberstr);
//   int spaceLength = field - length; 

// #ifdef VHDLDBG
//   cout << "savantwrite(SavantintegerType) adding |" <<  numberstr
//        << "| to line|";
//   line.print(cout);
//   cout << "|" << endl;
// #endif
 
//   // create new string
//   if (field > length) {  // space for user-specified padding
//     length = field;
//   }
//   newline = new char[line.dataLength + length];
//   if (line.dataLength != 0) { // copy old line
//     memcpy(newline, line.val, line.dataLength);
//   }

//   if (field < length) {
//     memcpy(newline + line.dataLength, numberstr,strlen(numberstr));
//   }
//   else {
//     if (justified == LEFT) { 
//       memcpy(newline + line.dataLength, numberstr, strlen(numberstr)); 
//       for (  i=0; i < spaceLength; i++) {
// 	newline[line.dataLength + strlen(numberstr) +i] = ' ';
//       }
//     }
//     if (justified == RIGHT) {
//       for (  i=0; i < spaceLength; i++) {
// 	newline[line.dataLength + i] = ' ';
//       }
//       memcpy(newline + line.dataLength + spaceLength, numberstr, strlen(numberstr));
//     }
//   }//endofesle
//   delete [] line.val;
//   line.val = newline;
//   line.dataLength += length;
//   return NORMAL_RETURN;
// }

int savantread(VHDLKernelBase*, AccessVariable<char*>& line, 
		Savantbit_vectorType& var) {
  register int i;
  if(var.object->bounds.dirn() == to) {
    for(i = var.object->bounds.left(); i <= var.object->bounds.right(); i++) {
      savantread(NULL, line, (EnumerationType&) var[i]);
    }
  } else {
    for(i = var.object->bounds.left(); i >= var.object->bounds.right(); i--) {
      savantread(NULL, line, (EnumerationType&) var[i]);
    }
  }
  return NORMAL_RETURN;
}

int savantwrite(VHDLKernelBase* kb, AccessVariable<char*>& line, 
		const Savantbit_vectorType& var, const Side_t justified, 
		const int field) {
  register int i;
  if(var.object->bounds.dirn() == to) {
    for(i = var.object->bounds.left(); i <= var.object->bounds.right(); i++) {
      savantwrite(kb, line, (const EnumerationType &) var[i], justified, field);
    }
  } else {
    for(i = var.object->bounds.left(); i >= var.object->bounds.right(); i--) {
      savantwrite(kb, line, (const EnumerationType &) var[i], justified, field);
    }
  }
  return NORMAL_RETURN;
}

int savantread(VHDLKernelBase*, AccessVariable<char*>& line, 
		SavantstringType& var) {
  register int i;
  int lbound = var.object->bounds.left();
  int rbound = var.object->bounds.right();
  ArrayDirn_t dirn = var.object->bounds.dirn();
  for(i = lbound; i <= rbound; ((dirn == to)? i++ : i--)) {
    savantread(NULL, line, (EnumerationType &) var[i]);
  }
  return NORMAL_RETURN;
}

int savantwrite(VHDLKernelBase*, AccessVariable<char*>& line, 
		const SavantstringType& var, const Side_t justified, 
		const int field) {
  register int i;
  int lbound = var.object->bounds.left();
  int rbound = var.object->bounds.right();
  ArrayDirn_t dirn = var.object->bounds.dirn();
  for(i = lbound; i <= rbound; ((dirn == to)? i++ : i--)) {
    savantwrite(NULL, line, (EnumerationType &)var[i], 
		justified, field);
  }
  return NORMAL_RETURN;
}

// Modified from here

int savantwrite(VHDLKernelBase *base, SavantlineType &line, 
		const PhysicalType &var, const Side_t side, 
		const int field, TimeUnit_t unit)
{
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }

  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  tempStr.dataLength = strlen(tempStr.val);

  returnValue = savantwrite(base, tempStr, var, side, field, unit);

  if (line.val != NULL) {
    delete line.val;
  }
  delete [] outbuf_str;

  strstream newbuf;
  for(int length = 0; (length < tempStr.dataLength); length++) {
    newbuf << tempStr.val[length];
  }
  newbuf << ends;
 
  outbuf_str =  newbuf.str();
  line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
  delete [] outbuf_str;

  return returnValue;
}

int savantwrite(VHDLKernelBase *base, SavantlineType &line, 
		const VTime &time, const Side_t side, const int i,
		TimeUnit_t t_unit)
{
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }

  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  tempStr.dataLength = strlen(tempStr.val);

  returnValue = savantwrite(base, tempStr, time, side, i, t_unit);

  delete [] outbuf_str;

  strstream newbuf;
  for(int length = 0; (length < tempStr.dataLength); length++) {
    newbuf << tempStr.val[length];
  }
  newbuf << ends;
  
  outbuf_str = newbuf.str();
  line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
  delete [] outbuf_str;

  return returnValue;
}

int savantwrite(VHDLKernelBase *base, SavantlineType &line, 
		const EnumerationType &var, const Side_t justified,
		const int field) {
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }

  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  tempStr.dataLength = strlen(tempStr.val);

  returnValue = savantwrite(base, tempStr, var, justified, field);

  if (line.val != NULL) {
    delete line.val;
  }
  delete [] outbuf_str;

  strstream newbuf;
  for(int length = 0; (length < tempStr.dataLength); length++) {
    newbuf << tempStr.val[length];
  }
  
  newbuf << ends;
 
  outbuf_str = newbuf.str();
  line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
  delete [] outbuf_str;

  return returnValue;
}


int savantwrite(VHDLKernelBase *base, SavantlineType &line, 
		const SavantstringType &var, const Side_t justified, 
		const int field) {
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }

  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  delete [] outbuf_str;
  tempStr.dataLength = strlen(tempStr.val);

  returnValue = savantwrite(base, tempStr, var, justified, field);

  if (line.val != NULL) {
    delete line.val;
  }

  strstream newbuf;
  for(int length = 0; (length < tempStr.dataLength); length++) {
    newbuf << tempStr.val[length];
  }
  
  newbuf << ends;
 
  outbuf_str = newbuf.str();
  line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
  delete [] outbuf_str;
  return returnValue;
}

int savantwrite(VHDLKernelBase *base, SavantlineType &line, 
		const Savantbit_vectorType &var, const Side_t justified, 
		const int field) {
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }

  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  delete [] outbuf_str;
  tempStr.dataLength = strlen(tempStr.val);

  returnValue = savantwrite(base, tempStr, var, justified, field);

  if (line.val != NULL) {
    delete line.val;
  }

  // Do not use "outbuf" here.  Once the operator "str()" has been called
  // on an ostrstream, the size of the stream is frozen.  So we need a new
  // one here.
  ostrstream newbuf;
  for(int length = 0; (length < tempStr.dataLength); length++) {
    newbuf << tempStr.val[length];
  }
  newbuf << ends;
  
  outbuf_str = newbuf.str();
  line.val = new SavantstringType(ObjectBase::VARIABLE, newbuf.str());
  delete [] outbuf_str;
  return returnValue;
}

// int savantwrite(VHDLKernelBase *base, SavantlineType &line, 
// 		const SavantbooleanType &var, const Side_t justified,
// 		const int field) {
//   int returnValue;

//   ostrstream outbuf;
//   char *outbuf_str;

//   if (line.val != NULL) {
//     outbuf << line << ends;
//   }
//   else {
//     outbuf << ends;
//   }

//   AccessVariable <char *> tempStr;
//   outbuf_str = outbuf.str();
//   tempStr.val = new char[strlen(outbuf_str) + 1];
//   strcpy(tempStr.val, outbuf_str);
//   tempStr.dataLength = strlen(tempStr.val);

//   returnValue = savantwrite(base, tempStr, var, justified, field);
  
//   if (line.val != NULL) {
//     delete line.val;
//   }
  
//   strstream newbuf;
//   for(int length = 0; (length < tempStr.dataLength); length++) {
//     newbuf << tempStr.val[length];
//   }
//   newbuf << ends;
  
//   outbuf_str = newbuf.str();
//   line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
  
//   return returnValue;
// }

// int savantwrite(VHDLKernelBase *base, SavantlineType &line, 
// 		const SavantbooleanType &var, const Side_t justified, 
// 		const IntegerType &field){
//   int returnValue;
  
//   returnValue = savantwrite(base, line, var, justified, 
// 			    int((UniversalInteger &)(field.object->readVal())));
  
//   return returnValue;
// }

int savantwrite(VHDLKernelBase *base, SavantlineType &line, 
		const IntegerType& var, const Side_t justified, 
		const int field) {
  int returnValue;
  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }

  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  delete [] outbuf_str;
  tempStr.dataLength = strlen(tempStr.val);

  returnValue = savantwrite(base, tempStr, var, justified, field);

  if (line.val != NULL) {
    delete line.val;
  }

  strstream newbuf;
  for(int length = 0; (length < tempStr.dataLength); length++) {
    newbuf << tempStr.val[length];
  }
  newbuf << ends;
  
  outbuf_str = newbuf.str();
  line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
  delete [] outbuf_str;

  return returnValue;
}

// int savantwrite(VHDLKernelBase *base, SavantlineType &line,
// 		const SavantcharacterType &var, const Side_t justified,
// 		const int field) {
//   int returnValue;

//   ostrstream outbuf;
//   char *outbuf_str;

//   if (line.val != NULL) {
//     outbuf << line << ends;
//   }
//   else {
//     outbuf << ends;
//   }
  
//   AccessVariable <char *> tempStr;
//   outbuf_str = outbuf.str();
//   tempStr.val = new char[strlen(outbuf_str) + 1];
//   strcpy(tempStr.val, outbuf_str);
//   tempStr.dataLength = strlen(tempStr.val);

//   returnValue = savantwrite(base, tempStr, var, justified, field);

//   if (line.val != NULL) {
//     delete line.val;
//   }

//   strstream newbuf;

//   for(int length = 0; (length < tempStr.dataLength); length++) {
//     newbuf << tempStr.val[length];
//   }

//   newbuf << ends;
  
//   outbuf_str = newbuf.str();
//   line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);

//   return returnValue;
// }

int savantwrite(VHDLKernelBase *base, SavantlineType &line, 
		const RealType &var, const Side_t justified,
		const int field) {
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }

  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  tempStr.dataLength = strlen(tempStr.val);

  returnValue = savantwrite(base, tempStr, var, justified, field);

  if (line.val != NULL) {
    delete line.val;
  }

  strstream newbuf;

  for(int length = 0; (length < tempStr.dataLength); length++) {
    newbuf << tempStr.val[length];
  }

  newbuf << ends;
    
  outbuf_str = newbuf.str();
  line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);

  return returnValue;
}

int savantread(VHDLKernelBase *base, SavantlineType &line, PhysicalType &var)
{
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }

  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  delete [] outbuf_str;
  tempStr.dataLength = strlen(tempStr.val);
  
  returnValue = savantread(base, tempStr, var);

  if (line.val != NULL) {
    delete line.val;
  }

  if (tempStr.curPos < tempStr.dataLength) {
    strstream newbuf;
    
    for(int length = tempStr.curPos; (length < tempStr.dataLength); length++) {
      newbuf << tempStr.val[length];
    }
    
    newbuf << ends;
    
    outbuf_str = newbuf.str();
    line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
    delete [] outbuf_str;
  }
  else {
    line.val = NULL;
  }
  
  return returnValue;
}
  
int savantread(VHDLKernelBase *base, SavantlineType &line, EnumerationType &var)
{
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }
  
  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  delete [] outbuf_str;
  tempStr.dataLength = strlen(tempStr.val);
  
  returnValue = savantread(base, tempStr, var);

  if (line.val != NULL) {
    delete line.val;
  }

  if (tempStr.curPos < tempStr.dataLength) {
    strstream newbuf;
    
    for(int length = tempStr.curPos; (length < tempStr.dataLength); length++) {
      newbuf << tempStr.val[length];
    }
    
    newbuf << ends;
    
    outbuf_str = newbuf.str();
    line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
    delete [] outbuf_str;
  }
  else {
    line.val = NULL;
  }
  
  return returnValue;
}
  
int savantread(VHDLKernelBase *base, SavantlineType &line, IntegerType &var)
{
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }
  
  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  tempStr.dataLength = strlen(tempStr.val);
  
  returnValue = savantread(base, tempStr, var);

  if (line.val != NULL) {
    delete line.val;
  }

  if (tempStr.curPos < tempStr.dataLength) {
    strstream newbuf;
    
    for(int length = tempStr.curPos; (length < tempStr.dataLength); length++) {
      newbuf << tempStr.val[length];
    }
    
    newbuf << ends;
    
    outbuf_str = newbuf.str();
    line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
  }
  else {
    line.val = NULL;
  }
  
  return returnValue;
}
  
// int savantread(VHDLKernelBase *base, SavantlineType &line, EnumerationType &var)
// {
//   int returnValue;

//   ostrstream outbuf;
//   char *outbuf_str;

//   if (line.val != NULL) {
//     outbuf << line << ends;
//   }
//   else {
//     outbuf << ends;
//   }
  
//   AccessVariable <char *> tempStr;
//   outbuf_str = outbuf.str();
//   tempStr.val = new char[strlen(outbuf_str) + 1];
//   strcpy(tempStr.val, outbuf_str);
//   tempStr.dataLength = strlen(tempStr.val);
  
//   returnValue = savantread(base, tempStr, var);

//   if (tempStr.curPos < tempStr.dataLength) {
//     if (line.val != NULL) {
//       delete line.val;
//     }
    
//     strstream newbuf;
    
//     for(int length = tempStr.curPos; (length < tempStr.dataLength); length++) {
//       newbuf << tempStr.val[length];
//     }
    
//     newbuf << ends;
    
//     outbuf_str = newbuf.str();
//     line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
//   }
//   else {
//     line.val = NULL;
//   }
  
//   return returnValue;
// }
  
// int savantread(VHDLKernelBase *base, SavantlineType &line, SavantcharacterType &var)
// {
//   int returnValue;

//   ostrstream outbuf;
//   char *outbuf_str;

//   if (line.val != NULL) {
//     outbuf << line << ends;
//   }
//   else {
//     outbuf << ends;
//   }
  
//   AccessVariable <char *> tempStr;
//   outbuf_str = outbuf.str();
//   tempStr.val = new char[strlen(outbuf_str) + 1];
//   strcpy(tempStr.val, outbuf_str);
//   tempStr.dataLength = strlen(tempStr.val);
  
//   returnValue = savantread(base, tempStr, var);

//   if (line.val != NULL) {
//     delete line.val;
//   }

//   if (tempStr.curPos < tempStr.dataLength) {
//     strstream newbuf;
    
//     for(int length = tempStr.curPos; (length < tempStr.dataLength); length++) {
//       newbuf << tempStr.val[length];
//     }
    
//     newbuf << ends;
    
//     outbuf_str = newbuf.str();
//     line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
//   }
//   else {
//     line.val = NULL;
//   }
    
//   return returnValue;
// }
  
int savantread(VHDLKernelBase *base, SavantlineType &line, RealType &var)
{
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }
  
  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  tempStr.dataLength = strlen(tempStr.val);
  
  returnValue = savantread(base, tempStr, var);

  if (line.val != NULL) {
    delete line.val;
  }

  if (tempStr.curPos < tempStr.dataLength) {
    strstream newbuf;
    
    for(int length = tempStr.curPos; (length < tempStr.dataLength); length++) {
      newbuf << tempStr.val[length];
    }
    
    newbuf << ends;
    
    outbuf_str = newbuf.str();
    line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
  }
  else {
    line.val = NULL;
  }
  
  return returnValue;
}
  
int savantread(VHDLKernelBase *base, SavantlineType &line, Savantbit_vectorType &var)
{
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }
  
  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  delete [] outbuf_str;
  tempStr.dataLength = strlen(tempStr.val);
  
  returnValue = savantread(base, tempStr, var);

  if (line.val != NULL) {
    delete line.val;
  }

  if (tempStr.curPos < tempStr.dataLength) {
    strstream newbuf;
    
    for(int length = tempStr.curPos; (length < tempStr.dataLength); length++) {
      newbuf << tempStr.val[length];
    }
    
    newbuf << ends;
    
    outbuf_str = newbuf.str();
    line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
    delete [] outbuf_str;
  }
  else {
    line.val = NULL;
  }
  
  return returnValue;
}
  
int savantread(VHDLKernelBase *base, SavantlineType &line, 
	       SavantstringType &var) {
  int returnValue;

  ostrstream outbuf;
  char *outbuf_str;

  if (line.val != NULL) {
    outbuf << line << ends;
  }
  else {
    outbuf << ends;
  }
  
  AccessVariable <char *> tempStr;
  outbuf_str = outbuf.str();
  tempStr.val = new char[strlen(outbuf_str) + 1];
  strcpy(tempStr.val, outbuf_str);
  tempStr.dataLength = strlen(tempStr.val);
  
  returnValue = savantread(base, tempStr, var);

  if (line.val != NULL) {
    delete line.val;
  }

  if (tempStr.curPos < tempStr.dataLength) {
    strstream newbuf;
    
    for(int length = tempStr.curPos; (length < tempStr.dataLength); length++) {
      newbuf << tempStr.val[length];
    }
    
    newbuf << ends;
    
    outbuf_str = newbuf.str();
    line.val = new SavantstringType(ObjectBase::VARIABLE, outbuf_str);
  }
  else {
    line.val = NULL;
  }
  
  return returnValue;
}

// Second set of modifications start here

int
savantwrite_time(VHDLKernelBase* base, SavantlineType &line, 
	    const PhysicalType& var, const EnumerationType& side,
	    const IntegerType& width, const PhysicalType& unit) { 
  UniversalLongLongInteger unit_val = ((UniversalLongLongInteger&)unit.getVHDLData());
  TimeUnit_t time = NS;
  
  if(longlongint(unit_val) == (LONG) 1) {
    time = PS;
  } else if(longlongint(unit_val) == (LONG) 2) {
    time = NS;
  } else if(longlongint(unit_val) == (LONG) 3) {
    time = US;
  } else if(longlongint(unit_val) == (LONG) 4) {
    time = MS;
  } else if(longlongint(unit_val) == (LONG) 5) {
    time = SECONDS;
  } else if(longlongint(unit_val) == (LONG) 6) {
    time = MIN;
  } else if(longlongint(unit_val) == (LONG) 7) {
    time = HR;
  }
  
  if (((UniversalInteger &) side.getObject()->readVal()).val == SavantsideType_info.get_right()) {
    return savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val, time);
  }
  else {
    return savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val, time);
  }
}

int savantwrite(VHDLKernelBase* base, SavantlineType &line,
		const PhysicalType& var, const EnumerationType& side,
		const IntegerType& width, const PhysicalType& unit) {
  if (var.range.get_unit_info() == SavanttimeType_info.get_unit_info()) {
    return savantwrite_time(base, line, var, side, width, unit);
  }

  return NORMAL_RETURN;
}

int
savantwrite(VHDLKernelBase* base, SavantlineType &line, 
	    const VTime& var, const EnumerationType& side,
	    const IntegerType& width, TimeUnit_t time) {
  if (((UniversalInteger &)side.getObject()->readVal()).val == SavantsideType_info.get_right()) {
    return savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val, time);
  }
  else {
    return savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val, time);
  }
}

int
savantwrite(VHDLKernelBase* base, SavantlineType &line, 
	    const EnumerationType& var, const EnumerationType& side,
	    const IntegerType& width) {
  if (((UniversalInteger &)side.getObject()->readVal()).val == SavantsideType_info.get_right()) {
    return savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
  else {
    return savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
}

// int
// savantwrite(VHDLKernelBase* base, SavantlineType &line, 
// 	    const SavantbooleanType& var, const EnumerationType& side,
// 	    const IntegerType& width) {
//   if (((UniversalInteger &)side.getObject()->readVal()).val == EnumerationType::enumright) {
//     return savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val);
//   }
//   else {
//     return savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val);
//   }
// }

int
savantwrite(VHDLKernelBase* base, SavantlineType &line, 
	    const IntegerType& var, const EnumerationType& side,
	    const IntegerType& width) {
  if (((UniversalInteger &)side.getObject()->readVal()).val == SavantsideType_info.get_right()) {
    return savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
  else {
    return savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
}

// int
// savantwrite(VHDLKernelBase* base, SavantlineType &line, 
// 	    const SavantcharacterType& var, const EnumerationType& side,
// 	    const IntegerType& width) {
//   if (((UniversalInteger &)side.getObject()->readVal()).val == EnumerationType::enumright) {
//     return savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val);
//   }
//   else {
//     return savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val);
//   }
// }

int
savantwrite(VHDLKernelBase* base, SavantlineType &line, 
	    const RealType& var, const EnumerationType& side,
	    const IntegerType& width, const IntegerType&) {
  if (((UniversalInteger &)side.getObject()->readVal()).val == SavantsideType_info.get_right()) {
    return savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
  else {
    return savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
}

int
savantwrite(VHDLKernelBase* base, SavantlineType &line, 
	    const Savantbit_vectorType& var, const EnumerationType& side,
	    const IntegerType& width) {
  if (((UniversalInteger &)side.getObject()->readVal()).val == SavantsideType_info.get_right()) {
    return savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
  else {
    return savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
}

int
savantwrite(VHDLKernelBase* base, SavantlineType &line, 
	    const SavantstringType& var, const EnumerationType& side,
	    const IntegerType& width) {
  if (((UniversalInteger &)side.getObject()->readVal()).val == SavantsideType_info.get_right()) {
    return savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
  else {
    return savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
}

// int
// savantwrite(VHDLKernelBase* base, SavantlineType &line,
// 	    const PhysicalType& time, const EnumerationType& side,
// 	    const IntegerType& width, const PhysicalType& phy) {
//   PhysicalType tempTime(ObjectBase::VARIABLE, phy);
//   return savantwrite(base, line, time, side, width, tempTime);
// }
