//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Philipp E. Lim and Ashif S. Harji 1995, 1997
// 
// uAlarm.h -- 
// 
// Author           : Philipp E. Lim
// Created On       : Thu Dec 21 14:01:24 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Oct 10 11:20:01 2005
// Update Count     : 164
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_ALARM_H__
#define __U_ALARM_H__


class uSignalHandler;					// forward declaration


//######################### uEventNode #########################


class uEventNode : public uSeqable {
    friend class uEventList;				// access: everything
    friend class uProcEventList;			// access: constructor
    friend class uEventListPop;				// access: everything
    friend _Coroutine uProcessorKernel;		// access: timerT, private constructor
    friend class uBaseTask;				// access: everything
    friend class uSerial;				// access: everything
    friend class uNBIO;					// access: everything
    friend class uKernelBoot;                           // access: new
    friend class uProcessor;                            // access: new
    friend class uCondLock;				// access: everything

    uTime timerT;					// time when alarm goes off (in internal clock time)
    uDuration timerD;					// if periodic, timerD contains period of alarm (after timerT)
    uSignalHandler *SigHandler;				// signal handler function when timer goes up
    uBaseTask *uWho;					// task that created the event
    bool uExecuteLocked;				// indicates if handler is executed with uEventlock acquired
    uProcessor *proc;					// processor to handle event (NULL => unspecified processor)
    uProcessor *activeProc;				// processor actually handling event (NULL => inactive)

    uEventNode( uProcessor *p = NULL );
    uEventNode( uBaseTask &t, uSignalHandler &sig, uTime tT, uDuration tD = 0, uProcessor *p = NULL );
    uEventNode( uSignalHandler &sig, uProcessor *p = NULL );

    void add( bool block = false );			// activate the event
    void remove();					// deactivate
    void setProcessor( uProcessor *p = NULL );		// change proc
}; // uEventNode


//######################### uEventList #########################


class uEventList {
    friend _Coroutine uProcessorKernel;		// access: new
    friend class uSerial;				// access: addEvent, removeEvent
    friend class uCondLock;				// access: addEvent, removeEvent
    friend class uNBIO;					// access: addEvent, removeEvent, uNextAlarm
    friend class uBaseTask;				// access: addEvent
    friend class uCluster;				// access: uNextAlarm
    friend class uKernelBoot;				// access: new
    friend class uProcessor;				// access: new
    friend class uEventListPop;				// access: uL
    friend class uProcEventList;			// access: addEvent, removeEvent
    friend class uEventNode;				// access: addEvent, removeEvent

  protected:
    uSequence<uEventNode> uL;
    uSpinLock uEventLock;				// protect EventQueue

    void *operator new( size_t, void *storage );
    void *operator new( size_t size );

    virtual ~uEventList() {}

    void addEvent( uEventNode &newAlarm, uProcessor &processor = uThisProcessor(), bool block = false );
    void removeEvent( uEventNode &oldNode, uProcessor &processor = uThisProcessor() );
    static uEventNode *uNextEvent();
    static uTime uNextAlarm();

#ifndef __U_MULTI__
    bool uUserEventPresent();
#endif // ! __U_MULTI__

    void acquireEventLock();
    void releaseEventLock();
    void acquireEventLockNoRF();
    void releaseEventLockNoRF();

    void setTimer( uTime time );
    virtual void setTimer( uDuration dur ) = 0;
  public:
}; // uEventList


//######################### uSysEventList #########################


class uSysEventList : public uEventList {
    virtual void setTimer( uDuration dur );
}; // uSysEventList


#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
//######################### uProcWakeupHndlr #########################


class uProcWakeupHndlr : public uSignalHandler {
    friend class uProcEventList;			// access: constructor

    uProcessor &proc;

    uProcWakeupHndlr( uProcessor &proc );
    void uHandler();
}; // uProcWakeupHndlr


//######################### uProcEventList #########################


class uProcEventList : public uEventList {
    friend class uProcessor;				// access: constructor
    friend class uEventList;				// access: wakeupEvent

    uProcWakeupHndlr procWakeupHandler;			// special time slice handler
    uEventNode wakeupEvent;				// wakeup node for global event list

    uProcEventList( uProcessor &proc );
    virtual void setTimer( uDuration dur );
}; // uProcEventList
#endif // __U_ONETIMER__ && __U_MULTI__


//######################### uEventListPop #########################


class uEventListPop {
    uEventList *uEL;
    uTime curTime;
    uSignalHandler *uCxtSwHandler;                      // ContextSwitch encountered?
    bool uInKernel;
    uQueue<uSignalHandler> deferredEvents;
  public:
    uEventListPop();
    uEventListPop( uEventList &e, bool inKernel );
    ~uEventListPop();
    void over( uEventList &e, bool inKernel );
    bool operator>>( uEventNode *&node );
}; // uEventListPop


#endif // __U_ALARM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
